/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarHelper {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_FORMAT_WINDOWS = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final TimeZone TIME_ZONE = TimeZone.getDefault();
    public static final Locale LOCALE = Locale.getDefault();

    public static Calendar now() {
        return Calendar.getInstance(TIME_ZONE, LOCALE);
    }

    public static String nowDateTimeString() {
        return CalendarHelper.formatDateTime(CalendarHelper.now());
    }

    public static String nowDateString() {
        return CalendarHelper.formatDate(CalendarHelper.now());
    }

    public static String nowTimeString() {
        return CalendarHelper.formatTime(CalendarHelper.now());
    }

    public static Calendar nowDate() {
        Calendar calendar = CalendarHelper.now();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar fromMillis(long millis) {
        Calendar calendar = CalendarHelper.now();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static long toMillis(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    public static Calendar fromString(String s, String format) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format, LOCALE);
            formatter.setTimeZone(TIME_ZONE);
            return CalendarHelper.fromMillis(formatter.parse(s).getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar fromString(String s) {
        Calendar calendar = CalendarHelper.fromString(s, DATE_TIME_FORMAT);
        if (calendar == null) {
            calendar = CalendarHelper.fromString(s, DATE_TIME_FORMAT_WINDOWS);
        }
        return calendar;
    }

    public static String format(Calendar calendar, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, LOCALE);
        formatter.setTimeZone(TIME_ZONE);
        return formatter.format(calendar.getTime());
    }

    public static String formatDateTime(Calendar calendar) {
        return CalendarHelper.format(calendar, DATE_TIME_FORMAT);
    }

    public static String formatDate(Calendar calendar) {
        return CalendarHelper.format(calendar, DATE_FORMAT);
    }

    public static String formatTime(Calendar calendar) {
        return CalendarHelper.format(calendar, TIME_FORMAT);
    }

    public static String format(long timeInMillis, String format) {
        Calendar calendar = CalendarHelper.fromMillis(timeInMillis);
        return CalendarHelper.format(calendar, format);
    }

    public static String formatDateTime(long timeInMillis) {
        return CalendarHelper.format(timeInMillis, DATE_TIME_FORMAT);
    }

    public static String formatDate(long timeInMillis) {
        return CalendarHelper.format(timeInMillis, DATE_FORMAT);
    }

    public static String formatTime(long timeInMillis) {
        return CalendarHelper.format(timeInMillis, TIME_FORMAT);
    }

    public static int compare(Calendar lhs, Calendar rhs) {
        return lhs.compareTo(rhs);
    }

    public static int compareDate(Calendar lhs, Calendar rhs) {
        int lhsYear = lhs.get(1);
        int lhsMonth = lhs.get(2);
        int lhsDate = lhs.get(5);
        int rhsYear = rhs.get(1);
        int rhsMonth = rhs.get(2);
        int rhsDate = rhs.get(5);
        if (lhsYear != rhsYear) {
            return lhsYear - rhsYear;
        }
        if (lhsMonth != rhsMonth) {
            return lhsMonth - rhsMonth;
        }
        return lhsDate - rhsDate;
    }

    public static int compareTime(Calendar lhs, Calendar rhs) {
        int lhsHour = lhs.get(11);
        int lhsMinute = lhs.get(12);
        int lhsSecond = lhs.get(13);
        int rhsHour = rhs.get(11);
        int rhsMinute = rhs.get(12);
        int rhsSecond = rhs.get(13);
        if (lhsHour != rhsHour) {
            return lhsHour - rhsHour;
        }
        if (lhsMinute != rhsMinute) {
            return lhsMinute - rhsMinute;
        }
        return lhsSecond - rhsSecond;
    }

    public static int compareTimeWithMillis(Calendar lhs, Calendar rhs) {
        int i = CalendarHelper.compareTime(lhs, rhs);
        if (i != 0) {
            int lhsMillis = lhs.get(14);
            int rhsMillis = rhs.get(14);
            return lhsMillis - rhsMillis;
        }
        return 0;
    }
}

