/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.Tuple;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.annotations.MethodNoReply;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.errors.NoReply;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.NotConnected;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.utils.LoggingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RemoteInvocationHandler
implements InvocationHandler {
    public static final int CALL_TYPE_SYNC = 0;
    public static final int CALL_TYPE_ASYNC = 1;
    public static final int CALL_TYPE_CALLBACK = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteInvocationHandler.class);
    AbstractConnection conn;
    RemoteObject remote;

    public static Object convertRV(String sig, Object[] rp, Method m, AbstractConnection conn) throws DBusException {
        Class<?> c = m.getReturnType();
        if (null == rp) {
            if (null == c || Void.TYPE.equals(c)) {
                return null;
            }
            throw new DBusException("Wrong return type (got void, expected a value)");
        }
        try {
            LOGGER.trace("Converting return parameters from {} to type {}", (Object)LoggingHelper.arraysDeepString(LOGGER.isTraceEnabled(), rp), (Object)m.getGenericReturnType());
            rp = Marshalling.deSerializeParameters(rp, new Type[]{m.getGenericReturnType()}, conn);
        }
        catch (Exception e) {
            LOGGER.debug("Wrong return type.", (Throwable)e);
            throw new DBusException(String.format("Wrong return type (failed to de-serialize correct types: %s )", e.getMessage()));
        }
        switch (rp.length) {
            case 0: {
                if (null == c || Void.TYPE.equals(c)) {
                    return null;
                }
                throw new DBusException("Wrong return type (got void, expected a value)");
            }
            case 1: {
                return rp[0];
            }
        }
        if (!Tuple.class.isAssignableFrom(c)) {
            throw new DBusException("Wrong return type (not expecting Tuple)");
        }
        Constructor<?> cons = c.getConstructors()[0];
        try {
            return cons.newInstance(rp);
        }
        catch (Exception e) {
            LOGGER.debug("", (Throwable)e);
            throw new DBusException(e.getMessage());
        }
    }

    public static Object executeRemoteMethod(RemoteObject ro, Method m, AbstractConnection conn, int syncmethod, CallbackHandler<?> callback, Object ... args) throws DBusException {
        MethodCall call;
        Type[] ts = m.getGenericParameterTypes();
        String sig = null;
        if (ts.length > 0) {
            try {
                sig = Marshalling.getDBusType(ts);
                args = Marshalling.convertParameters(args, ts, conn);
            }
            catch (DBusException exDbe) {
                throw new DBusExecutionException("Failed to construct D-Bus type: " + exDbe.getMessage());
            }
        }
        byte flags = 0;
        if (!ro.isAutostart()) {
            flags = (byte)(flags | 2);
        }
        if (syncmethod == 1) {
            flags = (byte)(flags | 0x40);
        }
        if (m.isAnnotationPresent(MethodNoReply.class)) {
            flags = (byte)(flags | 1);
        }
        try {
            String name = m.isAnnotationPresent(DBusMemberName.class) ? m.getAnnotation(DBusMemberName.class).value() : m.getName();
            call = null == ro.getInterface() ? new MethodCall(ro.getBusName(), ro.getObjectPath(), null, name, flags, sig, args) : (null != ro.getInterface().getAnnotation(DBusInterfaceName.class) ? new MethodCall(ro.getBusName(), ro.getObjectPath(), ro.getInterface().getAnnotation(DBusInterfaceName.class).value(), name, flags, sig, args) : new MethodCall(ro.getBusName(), ro.getObjectPath(), AbstractConnection.DOLLAR_PATTERN.matcher(ro.getInterface().getName()).replaceAll("."), name, flags, sig, args));
        }
        catch (DBusException dbe) {
            LOGGER.debug("Failed to construct outgoing method call.", (Throwable)dbe);
            throw new DBusExecutionException("Failed to construct outgoing method call: " + dbe.getMessage());
        }
        if (!conn.isConnected()) {
            throw new NotConnected("Not Connected");
        }
        switch (syncmethod) {
            case 1: {
                conn.sendMessage(call);
                return new DBusAsyncReply(call, m, conn);
            }
            case 2: {
                conn.queueCallback(call, m, callback);
                conn.sendMessage(call);
                return null;
            }
            case 0: {
                conn.sendMessage(call);
            }
        }
        if (m.isAnnotationPresent(MethodNoReply.class)) {
            return null;
        }
        Message reply = call.getReply();
        if (null == reply) {
            throw new NoReply("No reply within specified time");
        }
        if (reply instanceof Error) {
            ((Error)reply).throwException();
        }
        try {
            return RemoteInvocationHandler.convertRV(reply.getSig(), reply.getParameters(), m, conn);
        }
        catch (DBusException e) {
            LOGGER.debug("", (Throwable)e);
            throw new DBusExecutionException(e.getMessage());
        }
    }

    public RemoteInvocationHandler(AbstractConnection _conn, RemoteObject _remote) {
        this.remote = _remote;
        this.conn = _conn;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        block21: {
            if (method.getName().equals("isRemote")) {
                return true;
            }
            if (method.getName().equals("getObjectPath")) {
                return this.remote.getObjectPath();
            }
            if (method.getName().equals("clone")) {
                return null;
            }
            if (method.getName().equals("equals")) {
                try {
                    if (1 == args.length) {
                        return this.remote.equals(((RemoteInvocationHandler)Proxy.getInvocationHandler((Object)args[0])).remote);
                    }
                    break block21;
                }
                catch (IllegalArgumentException exIa) {
                    return Boolean.FALSE;
                }
            }
            if (method.getName().equals("finalize")) {
                return null;
            }
            if (method.getName().equals("getClass")) {
                return DBusInterface.class;
            }
            if (method.getName().equals("hashCode")) {
                return this.remote.hashCode();
            }
            if (method.getName().equals("notify")) {
                this.remote.notify();
                return null;
            }
            if (method.getName().equals("notifyAll")) {
                this.remote.notifyAll();
                return null;
            }
            if (method.getName().equals("wait")) {
                if (0 == args.length) {
                    this.remote.wait();
                } else if (1 == args.length && args[0] instanceof Long) {
                    this.remote.wait((Long)args[0]);
                } else if (2 == args.length && args[0] instanceof Long && args[1] instanceof Integer) {
                    this.remote.wait((Long)args[0], (Integer)args[1]);
                }
                if (args.length <= 2) {
                    return null;
                }
            } else if (method.getName().equals("toString")) {
                return this.remote.toString();
            }
        }
        return RemoteInvocationHandler.executeRemoteMethod(this.remote, method, this.conn, 0, null, args);
    }
}

