/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.transport.junixsocket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Optional;
import org.freedesktop.dbus.spi.message.IMessageReader;
import org.freedesktop.dbus.spi.message.IMessageWriter;
import org.freedesktop.dbus.spi.message.ISocketProvider;
import org.freedesktop.dbus.transport.junixsocket.JUnixSocketMessageReader;
import org.freedesktop.dbus.transport.junixsocket.JUnixSocketMessageWriter;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFUNIXSocketChannel;
import org.newsclub.net.unix.FileDescriptorCast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnixSocketSocketProvider
implements ISocketProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnixSocketSocketProvider.class);
    private boolean hasFileDescriptorSupport = true;

    public IMessageReader createReader(SocketChannel _socket) {
        if (!AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_UNIX_DOMAIN)) {
            return null;
        }
        if (_socket instanceof AFUNIXSocketChannel) {
            AFUNIXSocketChannel afUnix = (AFUNIXSocketChannel)_socket;
            return new JUnixSocketMessageReader(afUnix, this);
        }
        return null;
    }

    public IMessageWriter createWriter(SocketChannel _socket) {
        if (!AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_UNIX_DOMAIN)) {
            return null;
        }
        if (_socket instanceof AFUNIXSocketChannel) {
            AFUNIXSocketChannel afUnix = (AFUNIXSocketChannel)_socket;
            return new JUnixSocketMessageWriter(afUnix, this);
        }
        return null;
    }

    public void setFileDescriptorSupport(boolean _support) {
        this.hasFileDescriptorSupport = _support;
    }

    public boolean isFileDescriptorPassingSupported() {
        return this.hasFileDescriptorSupport && AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_FILE_DESCRIPTORS) && AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_UNSAFE);
    }

    public Optional<Integer> getFileDescriptorValue(FileDescriptor _fd) {
        try {
            return Optional.of((Integer)FileDescriptorCast.using((FileDescriptor)_fd).as(Integer.class));
        }
        catch (IOException | ClassCastException _ex) {
            LOGGER.error("Could not get file descriptor by using junixsocket library", (Throwable)_ex);
            return Optional.empty();
        }
    }

    public Optional<FileDescriptor> createFileDescriptor(int _fd) {
        if (!AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_UNSAFE)) {
            LOGGER.debug("Could not create new FileDescriptor instance by using junixsocket library, as unsafe capabilities of that library is disabled.");
            return Optional.empty();
        }
        try {
            return Optional.of(FileDescriptorCast.unsafeUsing((int)_fd).getFileDescriptor());
        }
        catch (IOException _ex) {
            LOGGER.error("Could not create new FileDescriptor instance by using junixsocket library.", (Throwable)_ex);
            return Optional.empty();
        }
    }
}

