/*
 * Decompiled with CFR 0.152.
 */
package com.hzn.lib;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Intent;
import android.view.View;
import android.view.ViewTreeObserver;
import com.hzn.lib.EasyTransitionOptions;
import java.util.ArrayList;

public class EasyTransition {
    public static final String EASY_TRANSITION_OPTIONS = "easy_transition_options";
    public static final long DEFAULT_TRANSITION_ANIM_DURATION = 1000L;

    public static void startActivity(Intent intent, EasyTransitionOptions options) {
        options.update();
        intent.putParcelableArrayListExtra(EASY_TRANSITION_OPTIONS, options.getAttrs());
        Activity activity = options.getActivity();
        activity.startActivity(intent);
        activity.overridePendingTransition(0, 0);
    }

    public static void startActivityForResult(Intent intent, int requestCode, EasyTransitionOptions options) {
        options.update();
        intent.putParcelableArrayListExtra(EASY_TRANSITION_OPTIONS, options.getAttrs());
        Activity activity = options.getActivity();
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(0, 0);
    }

    public static void enter(Activity activity, long duration, TimeInterpolator interpolator, Animator.AnimatorListener listener) {
        Intent intent = activity.getIntent();
        ArrayList attrs = intent.getParcelableArrayListExtra(EASY_TRANSITION_OPTIONS);
        EasyTransition.runEnterAnimation(activity, attrs, duration, interpolator, listener);
    }

    public static void enter(Activity activity, long duration, Animator.AnimatorListener listener) {
        EasyTransition.enter(activity, duration, null, listener);
    }

    public static void enter(Activity activity, TimeInterpolator interpolator, Animator.AnimatorListener listener) {
        EasyTransition.enter(activity, 1000L, interpolator, listener);
    }

    public static void enter(Activity activity, Animator.AnimatorListener listener) {
        EasyTransition.enter(activity, 1000L, null, listener);
    }

    public static void enter(Activity activity) {
        EasyTransition.enter(activity, 1000L, null, null);
    }

    private static void runEnterAnimation(Activity activity, ArrayList<EasyTransitionOptions.ViewAttrs> attrs, final long duration, final TimeInterpolator interpolator, final Animator.AnimatorListener listener) {
        if (null == attrs || attrs.size() == 0) {
            return;
        }
        for (final EasyTransitionOptions.ViewAttrs attr : attrs) {
            final View view = activity.findViewById(attr.id);
            if (null == view) continue;
            view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    int[] location = new int[2];
                    view.getLocationOnScreen(location);
                    view.setPivotX(0.0f);
                    view.setPivotY(0.0f);
                    view.setScaleX(attr.width / (float)view.getWidth());
                    view.setScaleY(attr.height / (float)view.getHeight());
                    view.setTranslationX(attr.startX - (float)location[0]);
                    view.setTranslationY(attr.startY - (float)location[1]);
                    view.animate().scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).setDuration(duration).setInterpolator(interpolator).setListener(listener);
                    return true;
                }
            });
        }
    }

    public static void exit(Activity activity, long duration, TimeInterpolator interpolator) {
        Intent intent = activity.getIntent();
        ArrayList attrs = intent.getParcelableArrayListExtra(EASY_TRANSITION_OPTIONS);
        EasyTransition.runExitAnimation(activity, attrs, duration, interpolator);
    }

    public static void exit(Activity activity, TimeInterpolator interpolator) {
        EasyTransition.exit(activity, 1000L, interpolator);
    }

    public static void exit(Activity activity, long duration) {
        EasyTransition.exit(activity, duration, null);
    }

    public static void exit(Activity activity) {
        EasyTransition.exit(activity, 1000L, null);
    }

    private static void runExitAnimation(final Activity activity, ArrayList<EasyTransitionOptions.ViewAttrs> attrs, long duration, TimeInterpolator interpolator) {
        if (null == attrs || attrs.size() == 0) {
            return;
        }
        for (EasyTransitionOptions.ViewAttrs attr : attrs) {
            View view = activity.findViewById(attr.id);
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            view.setPivotX(0.0f);
            view.setPivotY(0.0f);
            view.animate().scaleX(attr.width / (float)view.getWidth()).scaleY(attr.height / (float)view.getHeight()).translationX(attr.startX - (float)location[0]).translationY(attr.startY - (float)location[1]).setInterpolator(interpolator).setDuration(duration);
        }
        activity.findViewById(attrs.get((int)0).id).postDelayed(new Runnable(){

            @Override
            public void run() {
                activity.finish();
                activity.overridePendingTransition(0, 0);
            }
        }, duration);
    }
}

