/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.model;

import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import com.app.hubert.guide.model.HighLight;
import com.app.hubert.guide.util.LogUtil;
import com.app.hubert.guide.util.ViewUtils;

public class HighlightView
implements HighLight {
    private View mHole;
    private HighLight.Shape shape = HighLight.Shape.RECTANGLE;
    private int round;
    private int padding;

    public static HighlightView newInstance(View view) {
        return new HighlightView(view);
    }

    private HighlightView(View hole) {
        this.mHole = hole;
    }

    public HighlightView setShape(HighLight.Shape shape) {
        this.shape = shape;
        return this;
    }

    public HighlightView setRound(int round) {
        this.round = round;
        return this;
    }

    public HighlightView setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public int getPadding() {
        return this.padding;
    }

    @Override
    public HighLight.Shape getShape() {
        return this.shape;
    }

    @Override
    public int getRound() {
        return this.round;
    }

    @Override
    public float getRadius() {
        if (this.mHole == null) {
            throw new IllegalArgumentException("the hight light view is null!");
        }
        return Math.max(this.mHole.getWidth() / 2, this.mHole.getHeight() / 2) + this.padding;
    }

    @Override
    public RectF getRectF(View target) {
        if (this.mHole == null) {
            throw new IllegalArgumentException("the hight light view is null!");
        }
        RectF rectF = new RectF();
        Rect locationInView = ViewUtils.getLocationInView(target, this.mHole);
        rectF.left = locationInView.left - this.padding;
        rectF.top = locationInView.top - this.padding;
        rectF.right = locationInView.right + this.padding;
        rectF.bottom = locationInView.bottom + this.padding;
        LogUtil.i(this.mHole.getClass().getSimpleName() + "'s location:" + rectF);
        return rectF;
    }
}

