/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.core;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.app.hubert.guide.core.Controller;
import com.app.hubert.guide.listener.AnimationListenerAdapter;
import com.app.hubert.guide.listener.OnLayoutInflatedListener;
import com.app.hubert.guide.model.GuidePage;
import com.app.hubert.guide.model.HighLight;
import com.app.hubert.guide.model.RelativeGuide;
import java.util.List;

public class GuideLayout
extends FrameLayout {
    public static final int DEFAULT_BACKGROUND_COLOR = -1308622848;
    private Controller controller;
    private Paint mPaint;
    public GuidePage guidePage;
    private OnGuideLayoutDismissListener listener;

    public GuideLayout(Context context, GuidePage page, Controller controller) {
        super(context);
        this.init();
        this.setGuidePage(page);
        this.controller = controller;
    }

    private GuideLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private GuideLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        PorterDuffXfermode xfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
        this.mPaint.setXfermode((Xfermode)xfermode);
        this.mPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(10.0f, BlurMaskFilter.Blur.INNER));
        this.setLayerType(1, null);
        this.setWillNotDraw(false);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int backgroundColor = this.guidePage.getBackgroundColor();
        canvas.drawColor(backgroundColor == 0 ? -1308622848 : backgroundColor);
        this.drawHightLights(canvas);
    }

    private void drawHightLights(Canvas canvas) {
        List<HighLight> highLights = this.guidePage.getHighLights();
        if (highLights != null) {
            block5: for (HighLight highLight : highLights) {
                RectF rectF = highLight.getRectF((View)((ViewGroup)this.getParent()));
                switch (highLight.getShape()) {
                    case CIRCLE: {
                        canvas.drawCircle(rectF.centerX(), rectF.centerY(), highLight.getRadius(), this.mPaint);
                        continue block5;
                    }
                    case OVAL: {
                        canvas.drawOval(rectF, this.mPaint);
                        continue block5;
                    }
                    case ROUND_RECTANGLE: {
                        canvas.drawRoundRect(rectF, (float)highLight.getRound(), (float)highLight.getRound(), this.mPaint);
                        continue block5;
                    }
                }
                canvas.drawRect(rectF, this.mPaint);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addCustomToLayout(this.guidePage);
        Animation enterAnimation = this.guidePage.getEnterAnimation();
        if (enterAnimation != null) {
            this.startAnimation(enterAnimation);
        }
    }

    private void setGuidePage(GuidePage page) {
        this.guidePage = page;
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GuideLayout.this.guidePage.isEverywhereCancelable()) {
                    GuideLayout.this.remove();
                }
            }
        });
    }

    private void addCustomToLayout(GuidePage guidePage) {
        List<RelativeGuide> relativeGuides;
        this.removeAllViews();
        int layoutResId = guidePage.getLayoutResId();
        if (layoutResId != 0) {
            OnLayoutInflatedListener inflatedListener;
            View view = LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this, false);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            int[] viewIds = guidePage.getClickToDismissIds();
            if (viewIds != null && viewIds.length > 0) {
                for (int viewId : viewIds) {
                    View click = view.findViewById(viewId);
                    if (click != null) {
                        click.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                GuideLayout.this.remove();
                            }
                        });
                        continue;
                    }
                    Log.w((String)"NewbieGuide", (String)("can't find the view by id : " + viewId + " which used to remove guide page"));
                }
            }
            if ((inflatedListener = guidePage.getOnLayoutInflatedListener()) != null) {
                inflatedListener.onLayoutInflated(view, this.controller);
            }
            this.addView(view, (ViewGroup.LayoutParams)params);
        }
        if ((relativeGuides = guidePage.getRelativeGuides()).size() > 0) {
            for (RelativeGuide relativeGuide : relativeGuides) {
                this.addView(relativeGuide.getGuideLayout((ViewGroup)this.getParent()));
            }
        }
    }

    public void setOnGuideLayoutDismissListener(OnGuideLayoutDismissListener listener) {
        this.listener = listener;
    }

    public void remove() {
        Animation exitAnimation = this.guidePage.getExitAnimation();
        if (exitAnimation != null) {
            exitAnimation.setAnimationListener((Animation.AnimationListener)new AnimationListenerAdapter(){

                @Override
                public void onAnimationEnd(Animation animation) {
                    GuideLayout.this.dismiss();
                }
            });
            this.startAnimation(exitAnimation);
        } else {
            this.dismiss();
        }
    }

    private void dismiss() {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
            if (this.listener != null) {
                this.listener.onGuideLayoutDismiss(this);
            }
        }
    }

    public static interface OnGuideLayoutDismissListener {
        public void onGuideLayoutDismiss(GuideLayout var1);
    }
}

