/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.guide.model;

import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import com.app.hubert.guide.util.LogUtil;
import com.app.hubert.guide.util.ViewUtils;

public class HighLight {
    private View mHole;
    private Shape shape = Shape.RECTANGLE;
    private int round;
    private int padding;

    public static HighLight newInstance(View view) {
        return new HighLight(view);
    }

    private HighLight(View hole) {
        this.mHole = hole;
    }

    public HighLight setShape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public HighLight setRound(int round) {
        this.round = round;
        return this;
    }

    public HighLight setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    public int getPadding() {
        return this.padding;
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getRound() {
        return this.round;
    }

    public int getRadius() {
        return this.mHole != null ? Math.max(this.mHole.getWidth() / 2, this.mHole.getHeight() / 2) : 0;
    }

    public RectF getRectF(View target) {
        RectF rectF = new RectF();
        Rect locationInView = ViewUtils.getLocationInView(target, this.mHole);
        rectF.left = locationInView.left - this.padding;
        rectF.top = locationInView.top - this.padding;
        rectF.right = locationInView.right + this.padding;
        rectF.bottom = locationInView.bottom + this.padding;
        LogUtil.i(this.mHole.getClass().getSimpleName() + "'s location:" + rectF);
        return rectF;
    }

    public static enum Shape {
        CIRCLE,
        RECTANGLE,
        OVAL,
        ROUND_RECTANGLE;

    }
}

