/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.library;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.app.hubert.library.HighLight;
import java.util.List;

public class GuideLayout
extends RelativeLayout {
    public static final int DEFAULT_BACKGROUND_COLOR = -1308622848;
    private int mBackgroundColor = -1308622848;
    private Paint mPaint;
    private List<HighLight> highLights;

    public GuideLayout(Context context) {
        this(context, null);
    }

    public GuideLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GuideLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        PorterDuffXfermode xfermode = new PorterDuffXfermode(PorterDuff.Mode.CLEAR);
        this.mPaint.setXfermode((Xfermode)xfermode);
        this.mPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(10.0f, BlurMaskFilter.Blur.INNER));
        this.setLayerType(1, null);
        this.setClickable(true);
        this.setWillNotDraw(false);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(this.mBackgroundColor);
        if (this.highLights != null) {
            block5: for (HighLight highLight : this.highLights) {
                RectF rectF = highLight.getRectF();
                switch (highLight.getType()) {
                    case CIRCLE: {
                        canvas.drawCircle(rectF.centerX(), rectF.centerY(), (float)highLight.getRadius(), this.mPaint);
                        continue block5;
                    }
                    case OVAL: {
                        canvas.drawOval(rectF, this.mPaint);
                        continue block5;
                    }
                    case ROUND_RECTANGLE: {
                        canvas.drawRoundRect(rectF, (float)highLight.getRound(), (float)highLight.getRound(), this.mPaint);
                        continue block5;
                    }
                }
                canvas.drawRect(rectF, this.mPaint);
            }
        }
    }

    public void setHighLights(List<HighLight> holeList) {
        this.highLights = holeList;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor != 0 ? backgroundColor : -1308622848;
    }
}

