/*
 * Decompiled with CFR 0.152.
 */
package com.app.hubert.library;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.app.hubert.library.Builder;
import com.app.hubert.library.FragmentLifecycleAdapter;
import com.app.hubert.library.GuideLayout;
import com.app.hubert.library.HighLight;
import com.app.hubert.library.ListenerFragment;
import com.app.hubert.library.OnGuideChangedListener;
import com.app.hubert.library.ScreenUtils;
import com.app.hubert.library.V4ListenerFragment;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Controller {
    public static final String TAG = "listener_fragment";
    private Fragment fragment;
    private android.support.v4.app.Fragment v4Fragment;
    private Activity activity;
    private List<HighLight> list = new ArrayList<HighLight>();
    private OnGuideChangedListener onGuideChangedListener;
    private boolean everyWhereCancelable = true;
    private int backgroundColor;
    private String label;
    private boolean alwaysShow;
    private int layoutResId;
    private int[] viewIds;
    private boolean fullScreen;
    private FrameLayout mParentView;
    private GuideLayout guideLayout;
    private SharedPreferences sp;

    public Controller(Builder builder) {
        this.activity = builder.getActivity();
        this.fragment = builder.getFragment();
        this.v4Fragment = builder.getV4Fragment();
        this.list = builder.getList();
        this.backgroundColor = builder.getBackgroundColor();
        this.onGuideChangedListener = builder.getOnGuideChangedListener();
        this.everyWhereCancelable = builder.isEveryWhereCancelable();
        this.label = builder.getLabel();
        this.alwaysShow = builder.isAlwaysShow();
        this.layoutResId = builder.getLayoutResId();
        this.viewIds = builder.getViewIds();
        this.fullScreen = builder.isFullScreen();
        this.mParentView = (FrameLayout)this.activity.getWindow().getDecorView();
        this.sp = this.activity.getSharedPreferences("NewbieGuide", 0);
    }

    public int show() {
        boolean showed;
        if (!this.alwaysShow && (showed = this.sp.getBoolean(this.label, false))) {
            return -1;
        }
        this.activity.getWindow().setFlags(0x1000000, 0x1000000);
        this.guideLayout = new GuideLayout((Context)this.activity);
        this.guideLayout.setHighLights(this.list);
        if (this.backgroundColor != 0) {
            this.guideLayout.setBackgroundColor(this.backgroundColor);
        }
        if (this.layoutResId != 0) {
            View view = LayoutInflater.from((Context)this.activity).inflate(this.layoutResId, (ViewGroup)this.guideLayout, false);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            if (!this.fullScreen) {
                params.topMargin = ScreenUtils.getStatusBarHeight((Context)this.activity);
            }
            params.bottomMargin = ScreenUtils.getNavigationBarHeight(this.activity);
            if (this.viewIds != null) {
                for (int viewId : this.viewIds) {
                    view.findViewById(viewId).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Controller.this.remove();
                        }
                    });
                }
            }
            this.guideLayout.addView(view, (ViewGroup.LayoutParams)params);
        }
        this.mParentView.addView((View)this.guideLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (this.onGuideChangedListener != null) {
            this.onGuideChangedListener.onShowed(this);
        }
        this.sp.edit().putBoolean(this.label, true).apply();
        if (this.everyWhereCancelable) {
            this.guideLayout.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    Controller.this.remove();
                    return true;
                }
            });
        }
        if (this.fragment != null && Build.VERSION.SDK_INT > 16) {
            this.compatibleFragment(this.fragment);
            android.app.FragmentManager fm = this.fragment.getChildFragmentManager();
            ListenerFragment listenerFragment = (ListenerFragment)fm.findFragmentByTag(TAG);
            if (listenerFragment == null) {
                listenerFragment = new ListenerFragment();
                fm.beginTransaction().add((Fragment)listenerFragment, TAG).commitAllowingStateLoss();
            }
            listenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    Controller.this.remove();
                }
            });
        }
        if (this.v4Fragment != null && Build.VERSION.SDK_INT > 16) {
            FragmentManager v4Fm = this.v4Fragment.getChildFragmentManager();
            V4ListenerFragment v4ListenerFragment = (V4ListenerFragment)v4Fm.findFragmentByTag(TAG);
            if (v4ListenerFragment == null) {
                v4ListenerFragment = new V4ListenerFragment();
                v4Fm.beginTransaction().add((android.support.v4.app.Fragment)v4ListenerFragment, TAG).commitAllowingStateLoss();
            }
            v4ListenerFragment.setFragmentLifecycle(new FragmentLifecycleAdapter(){

                @Override
                public void onDestroyView() {
                    Log.e((String)"NewbieGuide", (String)"onDestroyView");
                    Controller.this.remove();
                }
            });
        }
        return 1;
    }

    public void resetLabel(String label) {
        this.sp.edit().putBoolean(label, false).apply();
    }

    public void remove() {
        FragmentManager v4Fm;
        V4ListenerFragment v4ListenerFragment;
        android.app.FragmentManager fm;
        ListenerFragment listenerFragment;
        if (this.guideLayout != null && this.guideLayout.getParent() != null) {
            ((ViewGroup)this.guideLayout.getParent()).removeView((View)this.guideLayout);
            if (this.onGuideChangedListener != null) {
                this.onGuideChangedListener.onRemoved(this);
            }
        }
        if (this.fragment != null && Build.VERSION.SDK_INT > 16 && (listenerFragment = (ListenerFragment)(fm = this.fragment.getChildFragmentManager()).findFragmentByTag(TAG)) != null) {
            fm.beginTransaction().remove((Fragment)listenerFragment).commitAllowingStateLoss();
        }
        if (this.v4Fragment != null && Build.VERSION.SDK_INT > 16 && (v4ListenerFragment = (V4ListenerFragment)(v4Fm = this.v4Fragment.getChildFragmentManager()).findFragmentByTag(TAG)) != null) {
            v4Fm.beginTransaction().remove((android.support.v4.app.Fragment)v4ListenerFragment).commitAllowingStateLoss();
        }
    }

    private void compatibleFragment(Fragment fragment) {
        try {
            Field childFragmentManager = Fragment.class.getDeclaredField("mChildFragmentManager");
            childFragmentManager.setAccessible(true);
            childFragmentManager.set(fragment, null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

