/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.column;

import android.graphics.Paint;
import com.bin.david.form.data.TableInfo;
import com.bin.david.form.data.format.IFormat;
import com.bin.david.form.data.format.count.DecimalCountFormat;
import com.bin.david.form.data.format.count.ICountFormat;
import com.bin.david.form.data.format.count.NumberCountFormat;
import com.bin.david.form.data.format.count.StringCountFormat;
import com.bin.david.form.data.format.draw.FastTextDrawFormat;
import com.bin.david.form.data.format.draw.IDrawFormat;
import com.bin.david.form.data.format.draw.MultiLineDrawFormat;
import com.bin.david.form.data.format.draw.TextDrawFormat;
import com.bin.david.form.listener.OnColumnItemClickListener;
import com.bin.david.form.utils.LetterUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Column<T>
implements Comparable<Column> {
    public static final String INVAL_VALUE = "";
    private String columnName;
    private List<Column> children;
    private IFormat<T> format;
    private IDrawFormat<T> drawFormat;
    private String fieldName;
    private List<T> datas;
    private boolean isFixed;
    private int computeWidth;
    private int level;
    private Comparator<T> comparator;
    private ICountFormat<T, ? extends Number> countFormat;
    private boolean isReverseSort;
    private OnColumnItemClickListener<T> onColumnItemClickListener;
    private Paint.Align textAlign;
    private Paint.Align titleAlign;
    private boolean isAutoCount = false;
    private boolean isAutoMerge = false;
    private int maxMergeCount = Integer.MAX_VALUE;
    private int id;
    private boolean isParent;
    private List<int[]> ranges;
    private boolean isFast;
    private int minWidth;
    private int minHeight;
    private int width;

    public Column(String columnName, List<Column> children) {
        this.columnName = columnName;
        this.children = children;
        this.isParent = true;
    }

    public Column(String columnName, Column ... children) {
        this(columnName, Arrays.asList(children));
    }

    public Column(String columnName, String fieldName) {
        this(columnName, fieldName, null, null);
    }

    public Column(String columnName, String fieldName, IFormat<T> format) {
        this(columnName, fieldName, format, null);
    }

    public Column(String columnName, String fieldName, IDrawFormat<T> drawFormat) {
        this(columnName, fieldName, null, drawFormat);
    }

    public Column(String columnName, String fieldName, IFormat<T> format, IDrawFormat<T> drawFormat) {
        this.columnName = columnName;
        this.format = format;
        this.fieldName = fieldName;
        this.drawFormat = drawFormat;
        this.datas = new ArrayList<T>();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public IFormat<T> getFormat() {
        return this.format;
    }

    public void setFormat(IFormat<T> format) {
        this.format = format;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setChildren(List<Column> children) {
        this.children = children;
    }

    public IDrawFormat<T> getDrawFormat() {
        if (this.drawFormat == null) {
            this.drawFormat = this.isFast ? new FastTextDrawFormat() : new TextDrawFormat();
        }
        return this.drawFormat;
    }

    public void setDrawFormat(IDrawFormat<T> drawFormat) {
        this.drawFormat = drawFormat;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public void setParent(boolean parent) {
        this.isParent = parent;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }

    public T getData(Object o) throws NoSuchFieldException, IllegalAccessException {
        String[] fieldNames = this.fieldName.split("\\.");
        if (fieldNames.length > 0) {
            Object child = o;
            for (int i = 0; i < fieldNames.length; ++i) {
                if (child == null) {
                    return null;
                }
                Class<?> childClazz = child.getClass();
                Field childField = childClazz.getDeclaredField(fieldNames[i]);
                if (childField == null) {
                    return null;
                }
                childField.setAccessible(true);
                if (i == fieldNames.length - 1) {
                    return (T)childField.get(child);
                }
                child = childField.get(child);
            }
        }
        return null;
    }

    public void fillData(List<Object> objects) throws NoSuchFieldException, IllegalAccessException {
        String[] fieldNames;
        if (this.countFormat != null) {
            this.countFormat.clearCount();
        }
        if (objects.size() > 0 && (fieldNames = this.fieldName.split("\\.")).length > 0) {
            Field[] fields = new Field[fieldNames.length];
            int size = objects.size();
            block0: for (int k = 0; k < size; ++k) {
                Object child = objects.get(k);
                for (int i = 0; i < fieldNames.length; ++i) {
                    Field childField;
                    if (child == null) {
                        this.addData(null, true);
                        this.countColumnValue(null);
                        continue block0;
                    }
                    if (fields[i] != null) {
                        childField = fields[i];
                    } else {
                        Class<?> childClazz = child.getClass();
                        childField = childClazz.getDeclaredField(fieldNames[i]);
                        childField.setAccessible(true);
                        fields[i] = childField;
                    }
                    if (childField == null) {
                        this.addData(null, true);
                        this.countColumnValue(null);
                        continue block0;
                    }
                    if (i == fieldNames.length - 1) {
                        Object t = childField.get(child);
                        this.addData(t, true);
                        this.countColumnValue(t);
                        continue;
                    }
                    child = childField.get(child);
                }
            }
        }
    }

    public void addData(List<Object> objects, int startPosition, boolean isFoot) throws NoSuchFieldException, IllegalAccessException {
        String[] fieldNames;
        if (objects.size() + startPosition == this.datas.size()) {
            return;
        }
        if (objects.size() > 0 && (fieldNames = this.fieldName.split("\\.")).length > 0) {
            int size = objects.size();
            block0: for (int k = 0; k < size; ++k) {
                Object child = objects.get(isFoot ? k : size - 1 - k);
                for (int i = 0; i < fieldNames.length; ++i) {
                    if (child == null) {
                        this.addData(null, isFoot);
                        this.countColumnValue(null);
                        continue block0;
                    }
                    Class<?> childClazz = child.getClass();
                    Field childField = childClazz.getDeclaredField(fieldNames[i]);
                    if (childField == null) {
                        this.addData(null, isFoot);
                        this.countColumnValue(null);
                        continue block0;
                    }
                    childField.setAccessible(true);
                    if (i == fieldNames.length - 1) {
                        Object t = childField.get(child);
                        this.addData(t, isFoot);
                        this.countColumnValue(t);
                        continue;
                    }
                    child = childField.get(child);
                }
            }
        }
    }

    public String format(int position) {
        if (position >= 0 && position < this.datas.size()) {
            return this.format(this.datas.get(position));
        }
        return INVAL_VALUE;
    }

    public List<int[]> parseRanges() {
        if (this.isAutoMerge && this.maxMergeCount > 1 && this.datas != null) {
            if (this.ranges != null) {
                this.ranges.clear();
            } else {
                this.ranges = new ArrayList<int[]>();
            }
            int size = this.datas.size();
            String perVal = null;
            int rangeStartPosition = -1;
            int rangeCount = 1;
            for (int i = 0; i < size; ++i) {
                int[] range;
                String val = this.format(this.datas.get(i));
                if (rangeCount < this.maxMergeCount && perVal != null && val != null && val.length() != 0 && val.equals(perVal)) {
                    if (rangeStartPosition == -1) {
                        rangeStartPosition = i - 1;
                    }
                    ++rangeCount;
                    if (i == size - 1) {
                        range = new int[]{rangeStartPosition, i};
                        this.ranges.add(range);
                        rangeStartPosition = -1;
                        rangeCount = 1;
                    }
                } else if (rangeStartPosition != -1) {
                    range = new int[]{rangeStartPosition, i - 1};
                    this.ranges.add(range);
                    rangeStartPosition = -1;
                    rangeCount = 1;
                }
                perVal = val;
            }
        }
        return this.ranges;
    }

    public String format(T t) {
        String value = this.format != null ? this.format.format(t) : (t == null ? INVAL_VALUE : t.toString());
        return value;
    }

    protected void countColumnValue(T t) {
        if (t != null && this.isAutoCount && this.countFormat == null) {
            this.countFormat = LetterUtils.isBasicType(t) ? (LetterUtils.isNumber(t) ? new NumberCountFormat() : new DecimalCountFormat()) : new StringCountFormat(this);
        }
        if (this.countFormat != null) {
            this.countFormat.count(t);
        }
    }

    protected void addData(T t, boolean isFoot) {
        if (isFoot) {
            this.datas.add(t);
        } else {
            this.datas.add(0, t);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getComputeWidth() {
        return this.computeWidth;
    }

    public void setComputeWidth(int computeWidth) {
        this.computeWidth = computeWidth;
    }

    public String getTotalNumString() {
        if (this.countFormat != null) {
            return this.countFormat.getCountString();
        }
        return INVAL_VALUE;
    }

    public List<Column> getChildren() {
        return this.children;
    }

    public void addChildren(Column column) {
        this.children.add(column);
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public ICountFormat<T, ? extends Number> getCountFormat() {
        return this.countFormat;
    }

    public void setCountFormat(ICountFormat<T, ? extends Number> countFormat) {
        this.countFormat = countFormat;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int compareTo(Column o) {
        return this.id - o.getId();
    }

    public boolean isAutoCount() {
        return this.isAutoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.isAutoCount = autoCount;
    }

    public boolean isReverseSort() {
        return this.isReverseSort;
    }

    public void setReverseSort(boolean reverseSort) {
        this.isReverseSort = reverseSort;
    }

    public OnColumnItemClickListener<T> getOnColumnItemClickListener() {
        return this.onColumnItemClickListener;
    }

    public void setOnColumnItemClickListener(OnColumnItemClickListener<T> onColumnItemClickListener) {
        this.onColumnItemClickListener = onColumnItemClickListener;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean fixed) {
        this.isFixed = fixed;
    }

    public Paint.Align getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(Paint.Align textAlign) {
        this.textAlign = textAlign;
    }

    public boolean isAutoMerge() {
        return this.isAutoMerge;
    }

    public void setAutoMerge(boolean autoMerge) {
        this.isAutoMerge = autoMerge;
    }

    public int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    public void setMaxMergeCount(int maxMergeCount) {
        this.maxMergeCount = maxMergeCount;
    }

    public boolean isFast() {
        return this.isFast;
    }

    public void setFast(boolean fast) {
        this.isFast = fast;
        this.drawFormat = this.isFast ? new FastTextDrawFormat() : new TextDrawFormat();
    }

    public int getSeizeCellSize(TableInfo tableInfo, int position) {
        return tableInfo.getArrayLineSize()[position];
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public Paint.Align getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(Paint.Align titleAlign) {
        this.titleAlign = titleAlign;
    }

    public void setWidth(int width) {
        if (width > 0) {
            this.width = width;
            this.setDrawFormat(new MultiLineDrawFormat(width));
        }
    }

    public int getWidth() {
        if (this.width == 0) {
            return this.computeWidth;
        }
        return this.width;
    }

    public List<int[]> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<int[]> ranges) {
        this.ranges = ranges;
    }
}

