/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data;

import android.graphics.Rect;
import com.bin.david.form.data.Cell;
import com.bin.david.form.data.column.ArrayColumn;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.column.ColumnNode;

public class TableInfo {
    private int topHeight;
    private int titleHeight;
    private int tableTitleSize;
    private int yAxisWidth;
    private int countHeight;
    private int titleDirection;
    private Rect tableRect;
    private int maxLevel = 1;
    private int columnSize;
    private int[] lineHeightArray;
    private float zoom = 1.0f;
    private Cell[][] rangeCells;
    private int lineSize;
    private ColumnNode topNode;
    private int[] arrayLineSize;
    private boolean isHasArrayColumn;

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
        this.rangeCells = new Cell[this.lineSize][columnSize];
    }

    public int getTopHeight() {
        return this.topHeight;
    }

    public int getTopHeight(float zoom) {
        return (int)((float)this.topHeight * zoom);
    }

    public void setTopHeight(int topHeight) {
        this.topHeight = topHeight;
    }

    public int getTitleHeight() {
        return (int)((float)this.titleHeight * this.zoom);
    }

    public void setTitleHeight(int titleHeight) {
        this.titleHeight = titleHeight;
    }

    public Rect getTableRect() {
        return this.tableRect;
    }

    public void setTableRect(Rect tableRect) {
        this.tableRect = tableRect;
    }

    public int getyAxisWidth() {
        return this.yAxisWidth;
    }

    public void setLineSize(int lineSize) {
        this.lineSize = lineSize;
        this.lineHeightArray = new int[lineSize];
    }

    public void addLine(int count, boolean isFoot) {
        this.lineSize += count;
        int size = this.lineHeightArray.length;
        int[] tempArray = new int[size + count];
        if (isFoot) {
            System.arraycopy(this.lineHeightArray, 0, tempArray, 0, size);
        } else {
            System.arraycopy(this.lineHeightArray, 0, tempArray, count, size);
        }
        this.lineHeightArray = tempArray;
        if (!this.isHasArrayColumn && size == this.rangeCells.length) {
            Cell[][] tempRangeCells = new Cell[size + count][this.columnSize];
            for (int i = 0; i < size; ++i) {
                tempRangeCells[i + (isFoot ? 0 : count)] = this.rangeCells[i];
            }
            this.rangeCells = tempRangeCells;
        }
    }

    public int getCountHeight() {
        return (int)(this.zoom * (float)this.countHeight);
    }

    public void setCountHeight(int countHeight) {
        this.countHeight = countHeight;
    }

    public int[] getLineHeightArray() {
        return this.lineHeightArray;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setyAxisWidth(int yAxisWidth) {
        this.yAxisWidth = yAxisWidth;
    }

    public int getTableTitleSize() {
        return this.tableTitleSize;
    }

    public void setTableTitleSize(int tableTitleSize) {
        this.tableTitleSize = tableTitleSize;
    }

    public int getTitleDirection() {
        return this.titleDirection;
    }

    public void setTitleDirection(int titleDirection) {
        this.titleDirection = titleDirection;
    }

    public Cell[][] getRangeCells() {
        return this.rangeCells;
    }

    public void clear() {
        this.rangeCells = null;
        this.lineHeightArray = null;
        this.tableRect = null;
        this.topNode = null;
    }

    public ColumnNode getTopNode() {
        return this.topNode;
    }

    public void setTopNode(ColumnNode topNode) {
        this.topNode = topNode;
        if (this.topNode != null) {
            this.isHasArrayColumn = true;
            this.rangeCells = null;
        }
    }

    public void countTotalLineSize(ArrayColumn bottomColumn) {
        if (this.topNode != null) {
            this.arrayLineSize = new int[this.lineSize];
            int totalSize = 0;
            for (int i = 0; i < this.lineSize; ++i) {
                this.arrayLineSize[i] = bottomColumn.getStructure().getLevelCellSize(-1, i);
                totalSize += this.arrayLineSize[i];
            }
            this.lineHeightArray = new int[totalSize];
            this.rangeCells = null;
        }
    }

    public int getSeizeCellSize(Column column, int position) {
        if (this.topNode != null) {
            return column.getSeizeCellSize(this, position);
        }
        return 1;
    }

    public int[] getArrayLineSize() {
        return this.arrayLineSize;
    }
}

