/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data;

import android.util.SparseArray;
import java.util.ArrayList;
import java.util.List;

public class ArrayStructure {
    private SparseArray<List<Integer>> structureArray = new SparseArray();
    private int maxLevel;
    private List<Integer> cellSizes;
    private boolean isEffective;

    public void putNull(int level, boolean isFoot) {
        if (this.isEffective && level <= this.maxLevel) {
            for (int i = level; i <= this.maxLevel; ++i) {
                this.put(i, 1, isFoot);
            }
        }
    }

    public void put(int level, int arraySize, boolean isFoot) {
        if (this.isEffective) {
            ArrayList<Integer> structures = (ArrayList<Integer>)this.structureArray.get(level);
            if (structures == null) {
                structures = new ArrayList<Integer>();
                this.structureArray.put(level, structures);
            }
            this.recordPerSizeList(structures, arraySize, isFoot);
        }
    }

    private void recordPerSizeList(List<Integer> structure, int size, boolean isFoot) {
        int perListSize = structure.size();
        if (perListSize == 0) {
            structure.add(size - 1);
        } else {
            int per = structure.get(perListSize - 1);
            if (isFoot) {
                structure.add(per + size);
            } else {
                this.moveArrayPosition(structure, size);
                structure.add(0, size - 1);
            }
        }
    }

    private void moveArrayPosition(List<Integer> structure, int moveSize) {
        int totalSize = structure.size();
        for (int i = 0; i < totalSize; ++i) {
            Integer perSize = structure.get(i);
            perSize = perSize + moveSize;
            structure.set(i, perSize);
        }
    }

    public void clear() {
        this.structureArray.clear();
    }

    public int getLevelCellSize(int level, int position) {
        if (this.maxLevel <= level) {
            return 1;
        }
        int[] startAndEnd = this.getPerStartAndEnd(level + 1, position);
        if (startAndEnd != null) {
            startAndEnd = this.getStartAndEnd(level + 2, startAndEnd[0], startAndEnd[1]);
            return startAndEnd[1] - startAndEnd[0] + 1;
        }
        return 1;
    }

    private int[] getStartAndEnd(int level, int start, int end) {
        if (this.structureArray.get(level) != null) {
            int[] starts = this.getPerStartAndEnd(level, start);
            int[] ends = this.getPerStartAndEnd(level, end);
            if (starts == null || ends == null) {
                return new int[]{start, end};
            }
            return this.getStartAndEnd(level + 1, starts[0], ends[1]);
        }
        return new int[]{start, end};
    }

    private int[] getPerStartAndEnd(int level, int position) {
        List structures = (List)this.structureArray.get(level);
        if (structures != null && structures.size() > position) {
            int end = (Integer)structures.get(position);
            int start = 0;
            if (position > 0) {
                start = (Integer)structures.get(position - 1) + 1;
            }
            return new int[]{start, end};
        }
        return null;
    }

    public List<Integer> getCellSizes() {
        return this.cellSizes;
    }

    public void setCellSizes(List<Integer> cellSizes) {
        this.cellSizes = cellSizes;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public boolean isEffective() {
        return this.isEffective;
    }

    public void setEffective(boolean effective) {
        this.isEffective = effective;
    }
}

