/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.controls;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.android.iplayer.base.BaseControlWidget;
import com.android.iplayer.manager.IVideoManager;
import com.android.iplayer.manager.IWindowManager;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.AnimationUtils;
import com.android.iplayer.widget.R;
import com.android.iplayer.widget.controls.ControlStatusView;

public class ControWindowView
extends BaseControlWidget
implements View.OnClickListener {
    private static final int MESSAGE_HIDE_CONTROLLER = 20;
    private static final int DELAYED_INVISIBLE = 3000;
    private View mController;
    private ProgressBar mLoadingView;
    private ProgressBar mProgressBar;
    private View mControllerPlay;
    private View mControllerReplay;
    private ImageView mPlayIcon;
    private ControlStatusView mControllerStatus;
    private BaseControlWidget.BaseHandel mExHandel = new BaseControlWidget.BaseHandel(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (null != msg && 20 == msg.what) {
                ControWindowView.this.hideControl(true);
            }
        }
    };

    public ControWindowView(Context context) {
        super(context);
    }

    public int getLayoutId() {
        return R.layout.player_control_window;
    }

    public void initViews() {
        this.hide();
        this.mController = this.findViewById(R.id.window_controller);
        this.findViewById(R.id.window_fullscreen).setOnClickListener((View.OnClickListener)this);
        FrameLayout rootView = (FrameLayout)this.findViewById(R.id.window_root_view);
        rootView.setOnClickListener((View.OnClickListener)this);
        this.mControllerPlay = this.findViewById(R.id.window_play);
        this.mControllerPlay.setOnClickListener((View.OnClickListener)this);
        this.mLoadingView = (ProgressBar)this.findViewById(R.id.window_loading);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.window_progress);
        this.mControllerStatus = new ControlStatusView(this.getContext());
        rootView.addView((View)this.mControllerStatus);
        this.mControllerStatus.setVisibility(8);
        this.mControllerStatus.setSceneType(1);
        this.mControllerStatus.setOnStatusListener(new ControlStatusView.OnStatusListener(){

            @Override
            public void onEvent(int event) {
                if (null != ControWindowView.this.mControlWrapper) {
                    if (1 == event) {
                        IVideoManager.getInstance().setMobileNetwork(true);
                        if (null != ControWindowView.this.mControlWrapper) {
                            ControWindowView.this.mControlWrapper.togglePlay();
                        }
                    } else if (3 == event && null != ControWindowView.this.mControlWrapper) {
                        ControWindowView.this.mControlWrapper.togglePlay();
                    }
                }
            }
        });
        this.mControllerReplay = this.findViewById(R.id.window_replay);
        this.mControllerReplay.setOnClickListener((View.OnClickListener)this);
        this.mPlayIcon = (ImageView)this.findViewById(R.id.window_start);
        this.mPlayIcon.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.window_fullscreen) {
            IWindowManager.getInstance().onClickWindow();
        } else if (id2 == R.id.window_start || id2 == R.id.window_replay || id2 == R.id.window_play) {
            if (null != this.mControlWrapper) {
                this.mControlWrapper.togglePlay();
            }
        } else if (id2 == R.id.window_root_view) {
            this.toggleController();
        }
    }

    public void showControl(boolean isAnimation) {
        if (this.isVisible() && null != this.mController && this.mController.getVisibility() != 0) {
            if (isAnimation) {
                AnimationUtils.getInstance().startAlphaAnimatioFrom(this.mController, this.getAnimationDuration(), false, null);
            } else {
                this.mController.setVisibility(0);
            }
        }
    }

    public void hideControl(boolean isAnimation) {
        if (this.isVisible() && null != this.mController && this.mController.getVisibility() != 8) {
            if (isAnimation) {
                AnimationUtils.getInstance().startAlphaAnimatioTo(this.mController, this.getAnimationDuration(), false, new AnimationUtils.OnAnimationListener(){

                    public void onAnimationEnd(Animation animation) {
                        ControWindowView.this.mController.setVisibility(8);
                    }
                });
            } else {
                this.mController.setVisibility(8);
            }
        }
    }

    public void onPlayerState(PlayerState state, String message) {
        switch (state) {
            case STATE_RESET: 
            case STATE_STOP: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_window_play);
                }
                this.onReset();
                break;
            }
            case STATE_PREPARE: 
            case STATE_BUFFER: {
                this.changedUIState(0, 8, 8, 8, 0, null);
                break;
            }
            case STATE_START: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_window_pause);
                }
                this.showControl(false);
                this.changedUIState(8, 8, 8, 8, 0, null);
                break;
            }
            case STATE_PLAY: 
            case STATE_ON_PLAY: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_window_pause);
                }
                this.changedUIState(8, 8, 8, 8, 0, null);
                break;
            }
            case STATE_PAUSE: 
            case STATE_ON_PAUSE: {
                this.stopDelayedRunnable();
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_window_play);
                }
                this.changedUIState(8, 0, 8, 8, 0, null);
                break;
            }
            case STATE_COMPLETION: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_window_play);
                }
                if (null != this.mProgressBar) {
                    this.mProgressBar.setProgress(0);
                }
                this.changedUIState(8, 8, 0, 8, 0, null);
                break;
            }
            case STATE_MOBILE: {
                this.changedUIState(8, 8, 8, 0, 1, null);
                break;
            }
            case STATE_ERROR: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_window_play);
                }
                this.changedUIState(8, 8, 8, 0, 3, null);
                break;
            }
            case STATE_DESTROY: {
                this.onDestroy();
            }
        }
    }

    public void onOrientation(int direction) {
    }

    public void onPlayerScene(int playerScene) {
        if (this.isWindowScene()) {
            this.show();
            this.findViewById(R.id.window_fullscreen).setVisibility(this.isWindowGlobalScene(playerScene) ? 0 : 8);
        } else {
            this.hide();
        }
    }

    public void onProgress(long currentDurtion, long totalDurtion) {
        if (null != this.mProgressBar) {
            if (this.mProgressBar.getMax() == 0) {
                this.mProgressBar.setMax((int)(this.isPreViewScene() ? this.mControlWrapper.getPreViewTotalDuration() : totalDurtion));
            }
            this.mProgressBar.setProgress((int)currentDurtion);
        }
    }

    public void onBuffer(int percent) {
        if (null != this.mProgressBar && this.mProgressBar.getSecondaryProgress() != percent) {
            this.mProgressBar.setSecondaryProgress(percent);
        }
    }

    private void changedUIState(int loadingView, int playerBtn, int replayBtn, int statuView, int scene, String errorMessage) {
        if (null != this.mLoadingView) {
            this.mLoadingView.setVisibility(loadingView);
        }
        if (null != this.mControllerPlay) {
            this.mControllerPlay.setVisibility(playerBtn);
        }
        if (null != this.mControllerReplay) {
            this.mControllerReplay.setVisibility(replayBtn);
        }
        if (null != this.mControllerStatus) {
            this.mControllerStatus.setVisibility(statuView);
            if (scene > 0) {
                this.mControllerStatus.setScene(scene, errorMessage);
            }
        }
    }

    private void toggleController() {
        this.stopDelayedRunnable();
        if (null == this.mController) {
            return;
        }
        if (this.mController.getVisibility() == 0) {
            this.hideControl(true);
        } else {
            this.showControl(true);
            this.startDelayedRunnable();
        }
    }

    private void startDelayedRunnable() {
        this.startDelayedRunnable(20);
    }

    private void startDelayedRunnable(int msg) {
        if (null != this.mExHandel) {
            this.stopDelayedRunnable();
            Message message = this.mExHandel.obtainMessage();
            message.what = msg;
            this.mExHandel.sendMessageDelayed(message, 3000L);
        }
    }

    private void stopDelayedRunnable() {
        this.stopDelayedRunnable(0);
    }

    private void stopDelayedRunnable(int msg) {
        if (null != this.mExHandel) {
            if (0 == msg) {
                this.mExHandel.removeCallbacksAndMessages(null);
            } else {
                this.mExHandel.removeMessages(msg);
            }
        }
    }

    private void reset() {
        this.stopDelayedRunnable();
        if (null != this.mProgressBar) {
            this.mProgressBar.setProgress(0);
            this.mProgressBar.setSecondaryProgress(0);
            this.mProgressBar.setMax(0);
        }
        if (null != this.mExHandel) {
            this.mExHandel.removeCallbacksAndMessages(null);
        }
        if (null != this.mPlayIcon) {
            this.mPlayIcon.setImageResource(R.mipmap.ic_player_window_play);
        }
    }

    public void onReset() {
        this.reset();
        this.changedUIState(8, 0, 8, 8, 0, null);
    }

    public void onDestroy() {
        this.reset();
        this.changedUIState(8, 0, 8, 8, 0, null);
    }
}

