/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import com.android.iplayer.widget.view.LayoutProvider;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;

public class PlayerUtils {
    private static PlayerUtils mInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PlayerUtils getInstance() {
        Class<PlayerUtils> clazz = PlayerUtils.class;
        synchronized (PlayerUtils.class) {
            if (null == mInstance) {
                mInstance = new PlayerUtils();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public String stringForAudioTime(long timeMs) {
        if (timeMs <= 0L || timeMs >= 86400000L) {
            return "00:00";
        }
        long totalSeconds = timeMs / 1000L;
        int seconds = (int)(totalSeconds % 60L);
        int minutes = (int)(totalSeconds / 60L % 60L);
        int hours = (int)(totalSeconds / 3600L);
        StringBuilder stringBuilder = new StringBuilder();
        Formatter mFormatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0) {
            return mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public boolean isWifiConnected(Context context) {
        if (this.existPermission(this.getContext(), "android.permission.ACCESS_NETWORK_STATE")) {
            try {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                return networkInfo != null && networkInfo.getType() == 1;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean isMobileConnected(Context context) {
        return this.isCheckNetwork() && !this.isWifiConnected(context);
    }

    public boolean isCheckNetwork() {
        Context context = this.getContext();
        if (null != context && this.existPermission(this.getContext(), "android.permission.ACCESS_NETWORK_STATE")) {
            try {
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo networkInfo = cm.getActiveNetworkInfo();
                if (networkInfo == null) {
                    return false;
                }
                int type = networkInfo.getType();
                return type == 0 || type == 1;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }

    public boolean mobileNetwork(boolean isMobileNetwork) {
        if (this.isMobileConnected(this.getContext())) {
            return isMobileNetwork;
        }
        return true;
    }

    public Activity getActivity(Context context) {
        try {
            if (context == null) {
                return null;
            }
            if (context instanceof Activity) {
                return (Activity)context;
            }
            if (context instanceof ContextWrapper) {
                return this.getActivity(((ContextWrapper)context).getBaseContext());
            }
            if (context instanceof ContextThemeWrapper) {
                return this.getActivity(((ContextThemeWrapper)context).getBaseContext());
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public float dpToPx(Context context, float dp) {
        return dp * context.getApplicationContext().getResources().getDisplayMetrics().density;
    }

    public int dpToPxInt(float dp) {
        return (int)(this.dpToPx(PlayerUtils.getInstance().getContext(), dp) + 0.5f);
    }

    public String getPackageName(Context context) {
        int pid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List infos = manager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (info.pid != pid) continue;
            return info.processName;
        }
        return "";
    }

    public int getStatusBarHeight(Context context) {
        int StatusBarHeight = 0;
        try {
            int resourceId = context.getApplicationContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                StatusBarHeight = context.getApplicationContext().getResources().getDimensionPixelSize(resourceId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StatusBarHeight = this.dpToPxInt(25.0f);
        }
        return StatusBarHeight;
    }

    public int getNavigationHeight(Context context) {
        Resources res;
        int resourceId;
        int result = 0;
        if (this.hasNavBar(context) && (resourceId = (res = context.getResources()).getIdentifier("navigation_bar_height", "dimen", "android")) > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        if (result <= 0) {
            result = this.dpToPxInt(24.0f);
        }
        return result;
    }

    @TargetApi(value=14)
    public boolean hasNavBar(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasNav = res.getBoolean(resourceId);
            String sNavBarOverride = PlayerUtils.getNavBarOverride();
            if ("1".equals(sNavBarOverride)) {
                hasNav = false;
            } else if ("0".equals(sNavBarOverride)) {
                hasNav = true;
            }
            return hasNav;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private static String getNavBarOverride() {
        String sNavBarOverride = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sNavBarOverride;
    }

    public Context getContext() {
        try {
            Class<?> ActivityThread = Class.forName("android.app.ActivityThread");
            Method method = ActivityThread.getMethod("currentActivityThread", new Class[0]);
            Object currentActivityThread = method.invoke(ActivityThread, new Object[0]);
            Method method2 = currentActivityThread.getClass().getMethod("getApplication", new Class[0]);
            return (Context)method2.invoke(currentActivityThread, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isLiveStream(String dataSource) {
        if (dataSource.isEmpty()) {
            return false;
        }
        return !(!dataSource.startsWith("htpp") && !dataSource.startsWith("htpps") || !dataSource.endsWith(".m3u8") && !dataSource.endsWith(".hks") && !dataSource.endsWith(".rtmp"));
    }

    public void removeViewFromParent(View view) {
        if (null != view && null != view.getParent() && view.getParent() instanceof ViewGroup) {
            try {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public int parseInt(String content) {
        return this.parseInt(content, 0);
    }

    public int parseInt(String content, int defaultValue) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public long parseLong(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return 0L;
        }
        try {
            return Long.parseLong(content);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public float parseFloat(String content) {
        try {
            float parseFloat = Float.parseFloat(content);
            return parseFloat;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public double parseDouble(String progressStr, double defaultvalue) {
        try {
            return Double.parseDouble(progressStr);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return defaultvalue;
        }
    }

    public boolean existPermission(Context context, String permission2) {
        if (TextUtils.isEmpty((CharSequence)permission2)) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
            String[] requestedPermissions = packageInfo.requestedPermissions;
            if (null != requestedPermissions && requestedPermissions.length > 0) {
                for (String requestedPermission : requestedPermissions) {
                    if (!requestedPermission.equals(permission2)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public Spanned formatHtml(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return new SpannableString((CharSequence)"");
        }
        try {
            return Html.fromHtml((String)content);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new SpannableString((CharSequence)content);
        }
    }

    public void setOutlineProvider(View view, float radius) {
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                view.setOutlineProvider((ViewOutlineProvider)new LayoutProvider(radius));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean hasNet(String dataSource, AssetFileDescriptor assetsSource) {
        if (null != assetsSource) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)dataSource)) {
            return false;
        }
        if (dataSource.startsWith("file") || dataSource.startsWith("android")) {
            return false;
        }
        return !dataSource.contains("127.0.0.1");
    }

    public String getCurrentTimeStr() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public int formatBufferPercent(int bufferPercent, long durtion) {
        if (bufferPercent <= 0) {
            return 0;
        }
        if (durtion <= 0L) {
            return 100;
        }
        try {
            return (int)(durtion / 100L) * bufferPercent;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean checkWindowsPermission(Context context) {
        if (!this.existPermission(context, "android.permission.SYSTEM_ALERT_WINDOW")) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return true;
        }
        try {
            Class[] arrayOfClass;
            if (Build.VERSION.SDK_INT >= 23) {
                return Settings.canDrawOverlays((Context)context);
            }
            Object object = context.getSystemService("appops");
            if (object == null) {
                return false;
            }
            Class<?> localClass = object.getClass();
            Method method = localClass.getMethod("checkOp", arrayOfClass = new Class[]{Integer.TYPE, Integer.TYPE, String.class});
            if (method == null) {
                return false;
            }
            Object[] arrayOfObject1 = new Object[]{24, Binder.getCallingUid(), context.getPackageName()};
            int m = (Integer)method.invoke(object, arrayOfObject1);
            return m == 0;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean isEdge(Context context, MotionEvent e) {
        float edgeSize = this.dpToPx(context, 40.0f);
        return e.getRawX() < edgeSize || e.getRawX() > (float)this.getScreenWidth(context) - edgeSize || e.getRawY() < edgeSize || e.getRawY() > (float)this.getScreenHeight(context) - edgeSize;
    }
}

