/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.controls;

import android.content.Context;
import android.view.View;
import android.widget.ProgressBar;
import com.android.iplayer.R;
import com.android.iplayer.base.BaseControlWidget;
import com.android.iplayer.model.PlayerState;

public class ControlLoadingView
extends BaseControlWidget {
    private ProgressBar mLoadingView;
    private View mControllerPlay;

    public ControlLoadingView(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.player_control_loading;
    }

    @Override
    public void initViews() {
        this.mLoadingView = (ProgressBar)this.findViewById(R.id.controller_loading);
        this.mControllerPlay = this.findViewById(R.id.controller_play);
        this.mControllerPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ControlLoadingView.this.togglePlay();
            }
        });
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        switch (state) {
            case STATE_RESET: 
            case STATE_STOP: 
            case STATE_PAUSE: 
            case STATE_ON_PAUSE: {
                this.changedUi(8, 0);
                break;
            }
            case STATE_PREPARE: 
            case STATE_BUFFER: {
                this.changedUi(0, 8);
                break;
            }
            default: {
                this.changedUi(8, 8);
            }
        }
    }

    @Override
    public void onOrientation(int direction) {
    }

    @Override
    public void onPlayerScene(int playerScene) {
        if (this.isWindowScene(playerScene)) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void changedUi(int loading, int playIcon) {
        if (null != this.mLoadingView) {
            this.mLoadingView.setVisibility(loading);
        }
        if (null != this.mControllerPlay) {
            this.mControllerPlay.setVisibility(playIcon);
        }
    }
}

