/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.base;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.iplayer.controller.ControlWrapper;
import com.android.iplayer.interfaces.IControllerView;
import com.android.iplayer.interfaces.IPlayerControl;
import com.android.iplayer.interfaces.IVideoController;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.PlayerUtils;
import com.android.iplayer.widget.controls.ControWindowView;
import com.android.iplayer.widget.controls.ControlCompletionView;
import com.android.iplayer.widget.controls.ControlFunctionBarView;
import com.android.iplayer.widget.controls.ControlGestureView;
import com.android.iplayer.widget.controls.ControlLoadingView;
import com.android.iplayer.widget.controls.ControlStatusView;
import com.android.iplayer.widget.controls.ControlToolBarView;
import java.util.LinkedList;

public abstract class BaseController
extends FrameLayout
implements IVideoController {
    protected static final String TAG = BaseController.class.getSimpleName();
    protected IPlayerControl mVideoPlayerControl;
    protected int mScreenOrientation = 0;
    protected int mPlayerScene = 0;
    protected LinkedList<IControllerView> mIControllerViews = new LinkedList();
    private ControlWrapper mControlWrapper;
    protected long mAnimationDuration = 300L;
    protected boolean isCompletion;
    protected long mPreViewTotalDuration;

    public BaseController(Context context) {
        this(context, null);
    }

    public BaseController(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseController(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int layoutId = this.getLayoutId();
        if (0 != layoutId) {
            View inflate = View.inflate((Context)context, (int)this.getLayoutId(), null);
            this.addView(inflate, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.initViews();
    }

    public abstract int getLayoutId();

    public abstract void initViews();

    protected void attachedPlayer(IPlayerControl playerControl) {
        this.mVideoPlayerControl = playerControl;
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onPlayerState(state, message);
        }
    }

    @Override
    public void onProgress(long currentDurtion, long totalDurtion) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onProgress(currentDurtion, totalDurtion);
        }
    }

    @Override
    public void onBuffer(int bufferPercent) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onBuffer(bufferPercent);
        }
    }

    @Override
    public void onScreenOrientation(int orientation) {
        this.mScreenOrientation = orientation;
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onOrientation(orientation);
        }
    }

    @Override
    public void onPlayerScene(int playerScene) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onPlayerScene(this.getPlayerScene());
        }
    }

    @Override
    public void onMute(boolean isMute) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onMute(isMute);
        }
    }

    @Override
    public void onMirror(boolean isMirror) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onMirror(isMirror);
        }
    }

    @Override
    public void onZoomModel(int zoomModel) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onZoomModel(zoomModel);
        }
    }

    @Override
    public void onResume() {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onResume();
        }
    }

    @Override
    public void onPause() {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onPause();
        }
    }

    @Override
    public void onReset() {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onReset();
        }
    }

    @Override
    public void onDestroy() {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.onDestroy();
        }
        this.removeAllControllerWidget();
    }

    @Override
    public void setListPlayerMode(boolean listPlayerScene) {
        this.setPlayerScene(listPlayerScene ? 4 : 0);
    }

    @Override
    public void enterPipWindow() {
        this.setPlayerScene(3);
    }

    @Override
    public void quitPipWindow() {
        this.setPlayerScene(0);
    }

    public void setWindowPropertyPlayer(boolean isActivityWindow, boolean isGlobalWindow) {
        if (isActivityWindow) {
            this.setPlayerScene(1);
        } else if (isGlobalWindow) {
            this.setPlayerScene(2);
        } else {
            this.setPlayerScene(0);
        }
    }

    public void initControlComponents() {
        this.initControlComponents(false);
    }

    public void initControlComponents(boolean showBack) {
        this.initControlComponents(showBack, true);
    }

    public void initControlComponents(boolean showBack, boolean addWindowWidget) {
        ControlToolBarView toolBarView = new ControlToolBarView(this.getContext());
        toolBarView.setTarget("toolBar");
        toolBarView.showBack(showBack);
        ControlFunctionBarView functionBarView = new ControlFunctionBarView(this.getContext());
        functionBarView.setTarget("functionBar");
        ControlGestureView gestureView = new ControlGestureView(this.getContext());
        gestureView.setTarget("gestureBar");
        ControlCompletionView completionView = new ControlCompletionView(this.getContext());
        completionView.setTarget("completionBar");
        ControlStatusView statusView = new ControlStatusView(this.getContext());
        statusView.setTarget("statusBar");
        ControlLoadingView loadingView = new ControlLoadingView(this.getContext());
        loadingView.setTarget("loadingBar");
        if (addWindowWidget) {
            ControWindowView windowView = new ControWindowView(this.getContext());
            windowView.setTarget("windowBar");
            this.addControllerWidget(toolBarView, functionBarView, gestureView, completionView, statusView, loadingView, windowView);
        } else {
            this.addControllerWidget(toolBarView, functionBarView, gestureView, completionView, statusView, loadingView);
        }
    }

    @Override
    public void addControllerWidget(IControllerView controllerView) {
        this.addControllerWidget(controllerView, -1);
    }

    @Override
    public void addControllerWidget(IControllerView controllerView, String target) {
        this.addControllerWidget(controllerView, target, -1);
    }

    @Override
    public void addControllerWidget(IControllerView controllerView, int index) {
        this.addControllerWidget(controllerView, null, index);
    }

    @Override
    public void addControllerWidget(IControllerView controllerView, String target, int index) {
        if (null == controllerView) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        if (null == this.mControlWrapper) {
            this.mControlWrapper = new ControlWrapper(this, this.mVideoPlayerControl);
        }
        controllerView.attachControlWrapper(this.mControlWrapper);
        if (TextUtils.isEmpty((CharSequence)controllerView.getTarget())) {
            controllerView.setTarget(target);
        }
        this.mIControllerViews.add(controllerView);
        if (-1 == index) {
            this.addView(controllerView.getView(), (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.addView(controllerView.getView(), index, (ViewGroup.LayoutParams)layoutParams);
        }
        controllerView.onCreate();
        controllerView.onOrientation(this.getOrientation());
        controllerView.onPlayerScene(this.getPlayerScene());
    }

    @Override
    public void addControllerWidget(IControllerView ... iControllerViews) {
        if (null != iControllerViews && iControllerViews.length > 0) {
            for (IControllerView iControllerView : iControllerViews) {
                this.addControllerWidget(iControllerView);
            }
        }
    }

    @Override
    public IControllerView findControlWidgetByTag(String target) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            if (!target.equals(iControllerView.getTarget())) continue;
            return iControllerView;
        }
        return null;
    }

    @Override
    public void removeControllerWidget(IControllerView controllerView) {
        if (null != controllerView) {
            this.removeView(controllerView.getView());
        }
        if (null != this.mIControllerViews) {
            this.mIControllerViews.remove(controllerView);
        }
    }

    @Override
    public void removeAllControllerWidget() {
        if (null != this.mIControllerViews) {
            for (IControllerView iControllerView : this.mIControllerViews) {
                this.removeView(iControllerView.getView());
            }
            this.mIControllerViews.clear();
        }
    }

    @Override
    public boolean isCompletion() {
        return this.isCompletion;
    }

    @Override
    public boolean isOrientationPortrait() {
        return this.mScreenOrientation == 0;
    }

    @Override
    public boolean isOrientationLandscape() {
        return this.mScreenOrientation == 1;
    }

    @Override
    public void setPlayerScene(int playerScene) {
        this.mPlayerScene = playerScene;
        this.onPlayerScene(this.mPlayerScene);
    }

    @Override
    public int getPlayerScene() {
        return this.mPlayerScene;
    }

    @Override
    public long getPreViewTotalDuration() {
        return this.mPreViewTotalDuration;
    }

    protected Activity getActivity() {
        if (null != this.mVideoPlayerControl && null != this.mVideoPlayerControl.getParentContext()) {
            return PlayerUtils.getInstance().getActivity(this.mVideoPlayerControl.getParentContext());
        }
        return PlayerUtils.getInstance().getActivity(this.getContext());
    }

    protected Context getParentContext() {
        if (null != this.mVideoPlayerControl && null != this.mVideoPlayerControl.getParentContext()) {
            return this.mVideoPlayerControl.getParentContext();
        }
        return this.getContext();
    }

    protected boolean isPlayering() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.isPlaying();
        }
        return false;
    }

    protected boolean isWorking() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.isWorking();
        }
        return false;
    }

    protected long getDuration() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.getDuration();
        }
        return 0L;
    }

    protected long getCurrentPosition() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.getCurrentPosition();
        }
        return 0L;
    }

    protected int getVideoWidth() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.getVideoWidth();
        }
        return 0;
    }

    protected int getVideoHeight() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.getVideoHeight();
        }
        return 0;
    }

    protected int getBuffer() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.getBuffer();
        }
        return 0;
    }

    protected void seekTo(long msec) {
        if (null != this.mVideoPlayerControl) {
            this.mVideoPlayerControl.seekTo(msec);
        }
    }

    protected void togglePlay() {
        if (null != this.mVideoPlayerControl) {
            this.mVideoPlayerControl.togglePlay();
        }
    }

    protected void stopPlay() {
        if (null != this.mVideoPlayerControl) {
            this.mVideoPlayerControl.onStop();
        }
    }

    protected void startFullScreen() {
        if (null != this.mVideoPlayerControl) {
            this.mVideoPlayerControl.startFullScreen();
        }
    }

    protected void toggleFullScreen() {
        if (null != this.mVideoPlayerControl) {
            this.mVideoPlayerControl.toggleFullScreen();
        }
    }

    protected boolean isSoundMute() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.isSoundMute();
        }
        return false;
    }

    protected boolean setSoundMute(boolean soundMute) {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.setSoundMute(soundMute);
        }
        return false;
    }

    protected boolean toggleMute() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.toggleMute();
        }
        return false;
    }

    protected boolean toggleMirror() {
        if (null != this.mVideoPlayerControl) {
            return this.mVideoPlayerControl.toggleMirror();
        }
        return false;
    }

    protected int getOrientation() {
        return this.mScreenOrientation;
    }

    protected String getOrientationStr() {
        return ",Orientation:" + this.getOrientation();
    }

    protected boolean isActivityWindow() {
        return 1 == this.getPlayerScene();
    }

    protected boolean isGlobalWindow() {
        return 2 == this.getPlayerScene();
    }

    protected boolean isPipWindow() {
        return 3 == this.getPlayerScene();
    }

    protected boolean isListPlayerScene() {
        return 4 == this.getPlayerScene();
    }

    protected void showWidget(boolean isAnimation) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.showControl(isAnimation);
        }
    }

    protected void hideWidget(boolean isAnimation) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.hideControl(isAnimation);
        }
    }

    protected String getString(int resId) {
        return this.getContext().getResources().getString(resId);
    }

    @Override
    public void setPreViewTotalDuration(long preTotalDuration) {
        this.mPreViewTotalDuration = preTotalDuration;
    }

    @Override
    public boolean isControllerShowing() {
        boolean isShowing = false;
        for (IControllerView iControllerView : this.mIControllerViews) {
            if (!iControllerView.isSeekBarShowing()) continue;
            isShowing = true;
            break;
        }
        return isShowing;
    }

    @Override
    public void hideAllController(boolean isAnimation) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.hideControl(isAnimation);
        }
    }

    @Override
    public void setTitle(String videoTitle) {
        for (IControllerView iControllerView : this.mIControllerViews) {
            iControllerView.setTitle(videoTitle);
        }
    }

    @Override
    public void startDelayedRunnable() {
    }

    @Override
    public void stopDelayedRunnable() {
    }

    @Override
    public void reStartDelayedRunnable() {
    }

    @Override
    public void setAnimationDuration(long animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    @Override
    public long getAnimationDuration() {
        return this.mAnimationDuration;
    }

    protected class ExHandel
    extends Handler {
        public ExHandel(Looper looper) {
            super(looper);
        }
    }
}

