/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.controller;

import com.android.iplayer.interfaces.IVideoController;
import com.android.iplayer.interfaces.IVideoPlayerControl;
import com.android.iplayer.model.PlayerState;

public final class ControlWrapper {
    private IVideoController mController;
    private IVideoPlayerControl mVideoPlayer;

    public ControlWrapper(IVideoController controllerControl, IVideoPlayerControl playerControl) {
        this.mController = controllerControl;
        this.mVideoPlayer = playerControl;
    }

    public IVideoController getController() {
        return this.mController;
    }

    public IVideoPlayerControl getVideoPlayer() {
        return this.mVideoPlayer;
    }

    public boolean isCompletion() {
        if (null != this.mController) {
            return this.mController.isCompletion();
        }
        return false;
    }

    public boolean isOrientationPortrait() {
        if (null != this.mController) {
            return this.mController.isOrientationPortrait();
        }
        return true;
    }

    public boolean isOrientationLandscape() {
        if (null != this.mController) {
            return this.mController.isOrientationLandscape();
        }
        return false;
    }

    public int getPlayerScene() {
        if (null != this.mController) {
            return this.mController.getPlayerScene();
        }
        return 0;
    }

    public long getPreViewTotalTime() {
        if (null != this.mController) {
            return this.mController.getPreViewTotalTime();
        }
        return 0L;
    }

    public void onPlayerState(PlayerState state, String message) {
        if (null != this.mController) {
            this.mController.onPlayerState(state, message);
        }
    }

    public void startDelayedRunnable() {
        if (null != this.mController) {
            this.mController.startDelayedRunnable();
        }
    }

    public void stopDelayedRunnable() {
        if (null != this.mController) {
            this.mController.stopDelayedRunnable();
        }
    }

    public void reStartDelayedRunnable() {
        if (null != this.mController) {
            this.mController.reStartDelayedRunnable();
        }
    }

    public void hideAllController(boolean isAnimation) {
        if (null != this.mController) {
            this.mController.hideAllController(isAnimation);
        }
    }

    public long getAnimationDuration() {
        if (null != this.mController) {
            return this.mController.getAnimationDuration();
        }
        return 300L;
    }

    public void togglePlay() {
        if (null != this.mVideoPlayer) {
            this.mVideoPlayer.togglePlay();
        }
    }

    public void stopPlay() {
        if (null != this.mVideoPlayer) {
            this.mVideoPlayer.onStop();
        }
    }

    public void startFullScreen() {
        if (null != this.mVideoPlayer) {
            this.mVideoPlayer.startFullScreen();
        }
    }

    public void quitFullScreen() {
        if (null != this.mVideoPlayer) {
            this.mVideoPlayer.quitFullScreen();
        }
    }

    public void toggleFullScreen() {
        if (null != this.mVideoPlayer) {
            this.mVideoPlayer.toggleFullScreen();
        }
    }

    public boolean toggleMirror() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.toggleMirror();
        }
        return false;
    }

    public boolean isPlaying() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.isPlaying();
        }
        return false;
    }

    public boolean isWorking() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.isWorking();
        }
        return false;
    }

    public boolean isSoundMute() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.isSoundMute();
        }
        return false;
    }

    public boolean setSoundMute(boolean soundMute) {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.setSoundMute(soundMute);
        }
        return false;
    }

    public boolean toggleMute() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.toggleMute();
        }
        return false;
    }

    public int getVideoWidth() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.getVideoWidth();
        }
        return 0;
    }

    public int getVideoHeight() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.getVideoHeight();
        }
        return 0;
    }

    public void onCompletion() {
        if (null != this.mVideoPlayer) {
            this.mVideoPlayer.onCompletion();
        }
    }

    public long getDuration() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.getDuration();
        }
        return 0L;
    }

    public long getCurrentPosition() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.getCurrentPosition();
        }
        return 0L;
    }

    public int getBuffer() {
        if (null != this.mVideoPlayer) {
            return this.mVideoPlayer.getBuffer();
        }
        return 0;
    }

    public void seekTo(long msec) {
        if (null != this.mVideoPlayer) {
            this.mVideoPlayer.seekTo(msec);
        }
    }
}

