/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.utils;

import android.content.Context;
import android.media.AudioManager;
import com.android.iplayer.utils.PlayerUtils;

public class AudioFocus {
    private int mVolumeWhenFocusLossTransientCanDuck;
    private AudioManager mAudioManager;
    private AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: 
                case 2: 
                case 3: {
                    int volume = AudioFocus.this.mAudioManager.getStreamVolume(3);
                    if (AudioFocus.this.mVolumeWhenFocusLossTransientCanDuck > 0 && volume == AudioFocus.this.mVolumeWhenFocusLossTransientCanDuck / 2) {
                        AudioFocus.this.mAudioManager.setStreamVolume(3, AudioFocus.this.mVolumeWhenFocusLossTransientCanDuck, 8);
                    }
                    if (null == AudioFocus.this.mFocusListener) break;
                    AudioFocus.this.mFocusListener.onFocusStart();
                    break;
                }
                case -1: {
                    if (null == AudioFocus.this.mFocusListener) break;
                    AudioFocus.this.mFocusListener.onFocusStop();
                    break;
                }
                case -2: {
                    if (null == AudioFocus.this.mFocusListener) break;
                    AudioFocus.this.mFocusListener.onFocusStop();
                    break;
                }
                case -3: {
                    if (null == AudioFocus.this.mFocusListener) break;
                    int volume = AudioFocus.this.mAudioManager.getStreamVolume(3);
                    if (volume > 0) {
                        AudioFocus.this.mVolumeWhenFocusLossTransientCanDuck = volume;
                        AudioFocus.this.mAudioManager.setStreamVolume(3, AudioFocus.this.mVolumeWhenFocusLossTransientCanDuck / 2, 8);
                    }
                    AudioFocus.this.mFocusListener.onFocusStart();
                }
            }
        }
    };
    public OnAudioFocusListener mFocusListener;

    public AudioFocus() {
        this(PlayerUtils.getInstance().getContext());
    }

    public AudioFocus(Context context) {
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
    }

    public int requestAudioFocus(OnAudioFocusListener focusListener) {
        this.mFocusListener = focusListener;
        if (null != this.mAudioManager) {
            int requestAudioFocus = this.mAudioManager.requestAudioFocus(this.onAudioFocusChangeListener, 3, 2);
            return requestAudioFocus;
        }
        return 1;
    }

    public void releaseAudioFocus() {
        if (null != this.mAudioManager && null != this.onAudioFocusChangeListener) {
            this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        }
    }

    public void onDestroy() {
        this.releaseAudioFocus();
        this.mAudioManager = null;
        this.mFocusListener = null;
    }

    public static interface OnAudioFocusListener {
        public void onFocusStart();

        public void onFocusStop();
    }
}

