/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.controls;

import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.android.iplayer.R;
import com.android.iplayer.base.BaseControllerWidget;
import com.android.iplayer.controller.ControlWrapper;
import com.android.iplayer.model.PlayerState;
import com.android.iplayer.utils.AnimationUtils;
import com.android.iplayer.utils.PlayerUtils;

public class ControlFunctionBarView
extends BaseControllerWidget
implements View.OnClickListener {
    private View mController;
    private SeekBar mSeekBar;
    private ProgressBar mProgressBar;
    private TextView mCurrentDuration;
    private TextView mTotalDuration;
    private ImageView mPlayIcon;
    private boolean isTouchSeekBar;

    public ControlFunctionBarView(Context context) {
        super(context);
    }

    @Override
    public int getLayoutId() {
        return R.layout.player_control_functionbar;
    }

    @Override
    public void initViews() {
        this.hide();
        this.mPlayIcon = (ImageView)this.findViewById(R.id.controller_start);
        this.mSeekBar = (SeekBar)this.findViewById(R.id.controller_seek_bar);
        this.mController = this.findViewById(R.id.controller_controller);
        this.mCurrentDuration = (TextView)this.findViewById(R.id.controller_current_duration);
        this.mTotalDuration = (TextView)this.findViewById(R.id.controller_total_duration);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.controller_bottom_progress);
        this.mPlayIcon.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.controller_btn_mute).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.controller_btn_fullscreen).setOnClickListener((View.OnClickListener)this);
        this.mSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (null != ControlFunctionBarView.this.mCurrentDuration) {
                    ControlFunctionBarView.this.mCurrentDuration.setText((CharSequence)PlayerUtils.getInstance().stringForAudioTime(progress));
                }
                if (null != ControlFunctionBarView.this.mProgressBar) {
                    ControlFunctionBarView.this.mProgressBar.setProgress(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                ControlFunctionBarView.this.isTouchSeekBar = true;
                ControlFunctionBarView.this.mControlWrapper.stopDelayedRunnable();
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                ControlFunctionBarView.this.isTouchSeekBar = false;
                ControlFunctionBarView.this.mControlWrapper.startDelayedRunnable();
                if (null != ControlFunctionBarView.this.mControlWrapper) {
                    if (ControlFunctionBarView.this.mControlWrapper.isCompletion() && ControlFunctionBarView.this.mControlWrapper.getPreViewTotalTime() > 0L) {
                        if (null != ControlFunctionBarView.this.mControlWrapper) {
                            ControlFunctionBarView.this.mControlWrapper.onCompletion();
                        }
                        return;
                    }
                    int seekBarProgress = seekBar.getProgress();
                    if (ControlFunctionBarView.this.mControlWrapper.getPreViewTotalTime() > 0L) {
                        long durtion = ControlFunctionBarView.this.mControlWrapper.getDuration();
                        if (0 == seekBarProgress) {
                            ControlFunctionBarView.this.mControlWrapper.onPlayerState(PlayerState.STATE_BUFFER, "seek");
                            ControlFunctionBarView.this.mControlWrapper.seekTo(0L);
                        } else if ((long)seekBarProgress >= durtion) {
                            ControlFunctionBarView.this.mControlWrapper.onCompletion();
                        } else {
                            ControlFunctionBarView.this.mControlWrapper.onPlayerState(PlayerState.STATE_BUFFER, "seek");
                            ControlFunctionBarView.this.mControlWrapper.seekTo(seekBarProgress);
                        }
                    } else {
                        ControlFunctionBarView.this.mControlWrapper.onPlayerState(PlayerState.STATE_BUFFER, "seek");
                        ControlFunctionBarView.this.mControlWrapper.seekTo(seekBarProgress);
                    }
                }
            }
        });
    }

    @Override
    public void attachControlWrapper(ControlWrapper controlWrapper) {
        super.attachControlWrapper(controlWrapper);
        if (null != this.mTotalDuration) {
            this.mTotalDuration.setText((CharSequence)PlayerUtils.getInstance().stringForAudioTime(this.mControlWrapper.getPreViewTotalTime()));
        }
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.updateMute();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.controller_start) {
            this.reStartDelayedRunnable();
            this.togglePlay();
        } else if (view.getId() == R.id.controller_btn_mute) {
            this.reStartDelayedRunnable();
            this.toggleMute();
        } else if (view.getId() == R.id.controller_btn_fullscreen) {
            this.toggleFullScreen();
            this.reStartDelayedRunnable();
        }
    }

    @Override
    public boolean isSeekBarShowing() {
        return null != this.mController && this.mController.getVisibility() == 0;
    }

    @Override
    public void showControl(boolean isAnimation) {
        if (null != this.mController && this.mController.getVisibility() != 0) {
            if (null != this.mProgressBar) {
                this.mProgressBar.setVisibility(8);
            }
            if (isAnimation) {
                AnimationUtils.getInstance().startTranslateBottomToLocat(this.mController, this.getAnimationDuration(), null);
            } else {
                this.mController.setVisibility(0);
            }
        }
    }

    @Override
    public void hideControl(boolean isAnimation) {
        if (null != this.mController && this.mController.getVisibility() != 8) {
            if (isAnimation) {
                AnimationUtils.getInstance().startTranslateLocatToBottom(this.mController, this.getAnimationDuration(), new AnimationUtils.OnAnimationListener(){

                    @Override
                    public void onAnimationEnd(Animation animation) {
                        ControlFunctionBarView.this.mController.setVisibility(8);
                        AnimationUtils.getInstance().startAlphaAnimatioFrom((View)ControlFunctionBarView.this.mProgressBar, ControlFunctionBarView.this.getAnimationDuration(), false, null);
                    }
                });
            } else {
                this.mController.setVisibility(8);
                if (null != this.mProgressBar) {
                    this.mProgressBar.setVisibility(0);
                }
            }
        }
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
        switch (state) {
            case STATE_RESET: 
            case STATE_STOP: {
                this.onReset();
                break;
            }
            case STATE_PREPARE: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_play);
                }
                this.hide();
                break;
            }
            case STATE_BUFFER: 
            case STATE_PAUSE: 
            case STATE_ON_PAUSE: {
                if (null == this.mPlayIcon) break;
                this.mPlayIcon.setImageResource(R.mipmap.ic_player_play);
                break;
            }
            case STATE_START: {
                if (this.isNoimalScene()) {
                    this.show();
                }
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_pause);
                }
                this.showControl(true);
                break;
            }
            case STATE_PLAY: 
            case STATE_ON_PLAY: {
                if (null == this.mPlayIcon) break;
                this.mPlayIcon.setImageResource(R.mipmap.ic_player_pause);
                break;
            }
            case STATE_COMPLETION: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_play);
                }
                this.resetProgressBar();
                break;
            }
            case STATE_MOBILE: {
                break;
            }
            case STATE_ERROR: {
                if (null != this.mPlayIcon) {
                    this.mPlayIcon.setImageResource(R.mipmap.ic_player_play);
                }
                this.onReset();
                break;
            }
            case STATE_DESTROY: {
                this.onDestroy();
            }
        }
    }

    @Override
    public void onOrientation(int direction) {
        if (null == this.mController) {
            return;
        }
        if (1 == direction) {
            int margin22 = PlayerUtils.getInstance().dpToPxInt(22.0f);
            this.mController.setPadding(margin22, 0, margin22, 0);
            this.show();
            if (this.isPlaying()) {
                this.reStartDelayedRunnable();
            }
        } else {
            int margin5 = PlayerUtils.getInstance().dpToPxInt(5.0f);
            this.mController.setPadding(margin5, 0, margin5, 0);
            if (this.isNoimalScene()) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    @Override
    public void onPlayerScene(int playerScene) {
        this.findViewById(R.id.controller_progress).setVisibility(this.isListPlayerScene() ? 8 : 0);
        if (this.isNoimalScene()) {
            this.show();
            if (this.isPlaying()) {
                this.showControl(false);
                this.reStartDelayedRunnable();
            }
        } else {
            this.hide();
        }
    }

    @Override
    public void onProgress(long currentDurtion, long totalDurtion) {
        if (null != this.mSeekBar && null != this.mControlWrapper) {
            if (null != this.mProgressBar && this.mProgressBar.getMax() == 0) {
                this.mProgressBar.setMax((int)(this.mControlWrapper.getPreViewTotalTime() > 0L ? this.mControlWrapper.getPreViewTotalTime() : totalDurtion));
            }
            if (null != this.mSeekBar) {
                if (this.mSeekBar.getMax() <= 0) {
                    this.mSeekBar.setMax((int)(this.mControlWrapper.getPreViewTotalTime() > 0L ? this.mControlWrapper.getPreViewTotalTime() : totalDurtion));
                    if (null != this.mTotalDuration) {
                        this.mTotalDuration.setText((CharSequence)PlayerUtils.getInstance().stringForAudioTime(this.mControlWrapper.getPreViewTotalTime() > 0L ? this.mControlWrapper.getPreViewTotalTime() : totalDurtion));
                    }
                }
                if (!this.isTouchSeekBar) {
                    this.mSeekBar.setProgress((int)currentDurtion);
                }
            }
        }
    }

    @Override
    public void onBuffer(int bufferPercent) {
        if (null != this.mControlWrapper) {
            int percent = PlayerUtils.getInstance().formatBufferPercent(bufferPercent, this.mControlWrapper.getDuration());
            if (null != this.mSeekBar && this.mSeekBar.getSecondaryProgress() != percent) {
                this.mSeekBar.setSecondaryProgress(percent);
            }
            if (null != this.mProgressBar && this.mProgressBar.getSecondaryProgress() != percent) {
                this.mProgressBar.setSecondaryProgress(percent);
            }
        }
    }

    @Override
    public void onMute(boolean isMute) {
        ImageView muteImage = (ImageView)this.findViewById(R.id.controller_btn_mute);
        muteImage.setImageResource(isMute ? R.mipmap.ic_player_mute_true : R.mipmap.ic_player_mute_false);
    }

    private void updateMute() {
        if (null != this.mControlWrapper) {
            boolean soundMute = this.mControlWrapper.isSoundMute();
            ImageView muteImge = (ImageView)this.findViewById(R.id.controller_btn_mute);
            muteImge.setImageResource(soundMute ? R.mipmap.ic_player_mute_true : R.mipmap.ic_player_mute_false);
        }
    }

    public void showSoundMute(boolean showSound) {
        ImageView muteImage = (ImageView)this.findViewById(R.id.controller_btn_mute);
        muteImage.setVisibility(showSound ? 0 : 8);
    }

    public void showSoundMute(boolean showSound, boolean soundMute) {
        ImageView muteImage = (ImageView)this.findViewById(R.id.controller_btn_mute);
        muteImage.setVisibility(showSound ? 0 : 8);
        if (null != this.mControlWrapper) {
            this.mControlWrapper.setSoundMute(soundMute);
        }
    }

    public void enableFullScreen(boolean enable) {
        this.findViewById(R.id.controller_btn_fullscreen).setVisibility(enable ? 0 : 8);
    }

    private void resetProgressBar() {
        if (null != this.mProgressBar) {
            this.mProgressBar.setProgress(0);
            this.mProgressBar.setSecondaryProgress(0);
            this.mProgressBar.setMax(0);
        }
    }

    @Override
    public void onReset() {
        if (null != this.mSeekBar) {
            this.mSeekBar.setProgress(0);
            this.mSeekBar.setSecondaryProgress(0);
            this.mSeekBar.setMax(0);
        }
        this.resetProgressBar();
        this.hideControl(false);
        if (null != this.mTotalDuration) {
            this.mTotalDuration.setText((CharSequence)PlayerUtils.getInstance().stringForAudioTime(0L));
        }
        if (null != this.mCurrentDuration) {
            this.mCurrentDuration.setText((CharSequence)PlayerUtils.getInstance().stringForAudioTime(0L));
        }
        if (null != this.mPlayIcon) {
            this.mPlayIcon.setImageResource(R.mipmap.ic_player_play);
        }
    }
}

