/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.base;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.iplayer.controller.ControlWrapper;
import com.android.iplayer.interfaces.IControllerView;
import com.android.iplayer.model.PlayerState;

public abstract class BaseControllerWidget
extends FrameLayout
implements IControllerView {
    protected static final String TAG = "BaseCoustomView";
    protected static final int MATION_DRAUTION = 300;
    private String mTarget;
    protected ControlWrapper mControlWrapper;

    public BaseControllerWidget(Context context) {
        this(context, null);
    }

    public BaseControllerWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseControllerWidget(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.initViews();
    }

    public abstract int getLayoutId();

    public abstract void initViews();

    protected int getPlayerScene() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getPlayerScene();
        }
        return 0;
    }

    protected boolean isOrientationPortrait() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.isOrientationPortrait();
        }
        return true;
    }

    protected boolean isOrientationLandscape() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.isOrientationLandscape();
        }
        return false;
    }

    protected boolean isNoimalScene() {
        return 0 == this.getPlayerScene();
    }

    protected boolean isNoimalScene(int scene) {
        return 0 == scene;
    }

    protected boolean isWindowScene() {
        return this.isWindowScene(this.getPlayerScene());
    }

    protected boolean isWindowScene(int scene) {
        return this.isWindowActivityScene(scene) || this.isWindowGlobalScene(scene) || this.isWindowPipScene(scene);
    }

    protected boolean isWindowActivityScene() {
        return this.isWindowActivityScene(this.getPlayerScene());
    }

    protected boolean isWindowActivityScene(int scene) {
        return 1 == scene;
    }

    protected boolean isWindowGlobalScene() {
        return this.isWindowGlobalScene(this.getPlayerScene());
    }

    protected boolean isWindowGlobalScene(int scene) {
        return 2 == scene;
    }

    protected boolean isWindowPipScene() {
        return this.isWindowPipScene(this.getPlayerScene());
    }

    protected boolean isWindowPipScene(int scene) {
        return 3 == scene;
    }

    protected boolean isListPlayerScene() {
        return this.isListPlayerScene(this.getPlayerScene());
    }

    protected boolean isListPlayerScene(int scene) {
        return 4 == scene;
    }

    protected long getPreViewTotalTime() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getPreViewTotalTime();
        }
        return 0L;
    }

    protected boolean isPreViewScene() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getPreViewTotalTime() > 0L;
        }
        return false;
    }

    protected boolean isVisible() {
        return this.getVisibility() == 0;
    }

    protected long getDuration() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getDuration();
        }
        return 0L;
    }

    protected long getCurrentPosition() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getCurrentPosition();
        }
        return 0L;
    }

    protected int getVideoWidth() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getVideoWidth();
        }
        return 0;
    }

    protected int getVideoHeight() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getVideoHeight();
        }
        return 0;
    }

    protected int getBuffer() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.getBuffer();
        }
        return 0;
    }

    protected void seekTo(long msec) {
        if (null != this.mControlWrapper) {
            this.mControlWrapper.seekTo(msec);
        }
    }

    protected boolean isCompletion() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.isCompletion();
        }
        return false;
    }

    protected boolean isPlaying() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.isPlaying();
        }
        return false;
    }

    protected boolean isWorking() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.isWorking();
        }
        return false;
    }

    protected String getString(int resId) {
        return this.getContext().getResources().getString(resId);
    }

    protected void togglePlay() {
        if (null != this.mControlWrapper) {
            this.mControlWrapper.togglePlay();
        }
    }

    protected void stopPlay() {
        if (null != this.mControlWrapper) {
            this.mControlWrapper.stopPlay();
        }
    }

    protected void startFullScreen() {
        if (null != this.mControlWrapper) {
            this.mControlWrapper.startFullScreen();
        }
    }

    protected void toggleFullScreen() {
        if (null != this.mControlWrapper) {
            this.mControlWrapper.toggleFullScreen();
        }
    }

    protected boolean isSoundMute() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.isSoundMute();
        }
        return false;
    }

    protected boolean setSoundMute(boolean soundMute) {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.setSoundMute(soundMute);
        }
        return false;
    }

    protected boolean toggleMute() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.toggleMute();
        }
        return false;
    }

    protected boolean toggleMirror() {
        if (null != this.mControlWrapper) {
            return this.mControlWrapper.toggleMirror();
        }
        return false;
    }

    protected void reStartDelayedRunnable() {
        if (null != this.mControlWrapper) {
            this.mControlWrapper.reStartDelayedRunnable();
        }
    }

    protected void hideAllController(boolean isAnimation) {
        if (null != this.mControlWrapper) {
            this.mControlWrapper.hideAllController(isAnimation);
        }
    }

    @Override
    public void attachControlWrapper(ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void show() {
        if (this.getVisibility() != 0) {
            this.setVisibility(0);
        }
    }

    @Override
    public void hide() {
        if (this.getVisibility() != 8) {
            this.setVisibility(8);
        }
    }

    @Override
    public void setTarget(String tag) {
        this.mTarget = tag;
    }

    @Override
    public String getTarget() {
        if (TextUtils.isEmpty((CharSequence)this.mTarget)) {
            return "";
        }
        return this.mTarget;
    }

    @Override
    public void showControl(boolean isAnimation) {
    }

    @Override
    public void hideControl(boolean isAnimation) {
    }

    @Override
    public boolean isSeekBarShowing() {
        return false;
    }

    @Override
    public void onPlayerState(PlayerState state, String message) {
    }

    @Override
    public void onOrientation(int direction) {
    }

    @Override
    public void onPlayerScene(int playerScene) {
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void onProgress(long currentDurtion, long totalDurtion) {
    }

    @Override
    public void onBuffer(int bufferPercent) {
    }

    @Override
    public void onMute(boolean isMute) {
    }

    @Override
    public void onMirror(boolean isMirror) {
    }

    @Override
    public void onZoomModel(int zoomModel) {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onReset() {
    }

    @Override
    public void onDestroy() {
    }

    protected class BaseHandel
    extends Handler {
        public BaseHandel(Looper looper) {
            super(looper);
        }
    }
}

