/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.view;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import com.android.iplayer.manager.IVideoManager;

public class MediaTextureView
extends TextureView {
    private static final String TAG = "MediaTextureView";
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private int mMeasureWidth;
    private int mMeasureHeight;
    protected int mScaleMode = IVideoManager.getInstance().getZoomModel();
    private int mDegree;
    private boolean mMirror = false;
    private boolean mVerticalOrientation;
    boolean mUseSettingRatio = false;
    private float mHOffset = 0.0f;
    private float mVOffset = 0.0f;
    private Matrix mMatrix = new Matrix();
    private int mLayoutWidth;
    private int mLayoutHeight;
    private float mCenterPointX;
    private float mCenterPointY;
    private float mDeltaX;
    private float mDeltaY;
    private float mCurrentVideoWidth;
    private float mCurrentVideoHeight;
    private float mTotalTranslateX;
    private float mTotalTranslateY;
    private float mTotalRatio = 1.0f;
    private float mScaledRatio;
    private float mInitRatio;
    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_ZOOM = 2;
    public static final int STATUS_MOVE = 3;
    private int mCurrentDispStatus = 1;

    public MediaTextureView(Context context) {
        this(context, null);
    }

    public MediaTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void Zoom() {
        Matrix matrix = this.mMatrix;
        int videoWidth = this.mVideoWidth;
        int videoHeight = this.mVideoHeight;
        if (this.mMirror) {
            this.mCenterPointX = (float)this.mLayoutWidth - this.mCenterPointX;
        }
        if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
            videoWidth = videoWidth * this.mVideoSarNum / this.mVideoSarDen;
        }
        float scaleX = (float)videoWidth / (float)this.mLayoutWidth;
        float scaleY = (float)videoHeight / (float)this.mLayoutHeight;
        if (this.mScaleMode == 2) {
            if (this.mDegree / 90 % 2 != 0) {
                scaleX = (float)this.mLayoutHeight / (float)this.mLayoutWidth;
                scaleY = (float)this.mLayoutWidth / (float)this.mLayoutHeight;
            } else {
                scaleX = 1.0f;
                scaleY = 1.0f;
            }
        }
        matrix.reset();
        matrix.postScale(this.mTotalRatio * scaleX, this.mTotalRatio * scaleY);
        matrix.postRotate((float)this.mDegree);
        float scaledWidth = (float)this.mLayoutWidth * this.mTotalRatio * scaleX;
        float scaledHeight = (float)this.mLayoutHeight * this.mTotalRatio * scaleY;
        if (this.mDegree / 90 % 2 != 0) {
            scaledWidth = (float)this.mLayoutHeight * this.mTotalRatio * scaleY;
            scaledHeight = (float)this.mLayoutWidth * this.mTotalRatio * scaleX;
        }
        float translateX = 0.0f;
        float translateY = 0.0f;
        translateX = this.mTotalTranslateX * this.mScaledRatio + this.mCenterPointX * (1.0f - this.mScaledRatio);
        translateY = this.mTotalTranslateY * this.mScaledRatio + this.mCenterPointY * (1.0f - this.mScaledRatio);
        switch (this.mDegree) {
            case 0: {
                if (scaledWidth < (float)this.mLayoutWidth) {
                    translateX = ((float)this.mLayoutWidth - scaledWidth) / 2.0f;
                } else if (translateX > 0.0f) {
                    translateX = 0.0f;
                } else if (scaledWidth + translateX < (float)this.mLayoutWidth) {
                    translateX = (float)this.mLayoutWidth - scaledWidth;
                }
                if (scaledHeight < (float)this.mLayoutHeight) {
                    translateY = ((float)this.mLayoutHeight - scaledHeight) / 2.0f;
                    break;
                }
                if (translateY > 0.0f) {
                    translateY = 0.0f;
                    break;
                }
                if (!(scaledHeight + translateY < (float)this.mLayoutHeight)) break;
                translateY = (float)this.mLayoutHeight - scaledHeight;
                break;
            }
            case -90: {
                if (scaledWidth < (float)this.mLayoutWidth) {
                    translateX = ((float)this.mLayoutWidth - scaledWidth) / 2.0f;
                } else if (translateX > 0.0f) {
                    translateX = 0.0f;
                } else if (scaledWidth + translateX < (float)this.mLayoutWidth) {
                    translateX = (float)this.mLayoutWidth - scaledWidth;
                }
                if (scaledHeight < (float)this.mLayoutHeight) {
                    translateY = ((float)this.mLayoutHeight + scaledHeight) / 2.0f;
                    break;
                }
                if (translateY > scaledHeight) {
                    translateY = scaledHeight;
                    break;
                }
                if (!(translateY < (float)this.mLayoutHeight)) break;
                translateY = this.mLayoutHeight;
                break;
            }
            case -180: {
                if (scaledWidth < (float)this.mLayoutWidth) {
                    translateX = ((float)this.mLayoutWidth + scaledWidth) / 2.0f;
                } else if (translateX > scaledWidth) {
                    translateX = scaledWidth;
                } else if (translateX < (float)this.mLayoutWidth) {
                    translateX = this.mLayoutWidth;
                }
                if (scaledHeight < (float)this.mLayoutHeight) {
                    translateY = ((float)this.mLayoutHeight + scaledHeight) / 2.0f;
                    break;
                }
                if (translateY > scaledHeight) {
                    translateY = scaledHeight;
                    break;
                }
                if (!(translateY < (float)this.mLayoutHeight)) break;
                translateY = this.mLayoutHeight;
                break;
            }
            case -270: {
                if (scaledWidth < (float)this.mLayoutWidth) {
                    translateX = ((float)this.mLayoutWidth + scaledWidth) / 2.0f;
                } else if (translateX > scaledWidth) {
                    translateX = scaledWidth;
                } else if (translateX < (float)this.mLayoutWidth) {
                    translateX = this.mLayoutWidth;
                }
                if (scaledHeight < (float)this.mLayoutHeight) {
                    translateY = ((float)this.mLayoutHeight - scaledHeight) / 2.0f;
                    break;
                }
                if (translateY > 0.0f) {
                    translateY = 0.0f;
                    break;
                }
                if (!(scaledHeight + translateY < (float)this.mLayoutHeight)) break;
                translateY = (float)this.mLayoutHeight - scaledHeight;
            }
        }
        matrix.postTranslate(translateX, translateY);
        this.mTotalTranslateX = translateX;
        this.mTotalTranslateY = translateY;
        this.mCurrentVideoWidth = scaledWidth;
        this.mCurrentVideoHeight = scaledHeight;
    }

    private void Move() {
        Matrix matrix = this.mMatrix;
        int videoWidth = this.mVideoWidth;
        int videoHeight = this.mVideoHeight;
        if (this.mMirror) {
            this.mDeltaX = -this.mDeltaX;
        }
        if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
            videoWidth = videoWidth * this.mVideoSarNum / this.mVideoSarDen;
        }
        float scaleX = (float)videoWidth / (float)this.mLayoutWidth;
        float scaleY = (float)videoHeight / (float)this.mLayoutHeight;
        if (this.mScaleMode == 2) {
            if (this.mDegree / 90 % 2 != 0) {
                scaleX = (float)this.mLayoutHeight / (float)this.mLayoutWidth;
                scaleY = (float)this.mLayoutWidth / (float)this.mLayoutHeight;
            } else {
                scaleX = 1.0f;
                scaleY = 1.0f;
            }
        }
        matrix.reset();
        matrix.postScale(this.mTotalRatio * scaleX, this.mTotalRatio * scaleY);
        matrix.postRotate((float)this.mDegree);
        float xoffset = 0.0f;
        float yoffset = 0.0f;
        switch (this.mDegree) {
            case 0: {
                xoffset = ((float)this.mLayoutWidth - this.mCurrentVideoWidth) / 2.0f;
                yoffset = ((float)this.mLayoutHeight - this.mCurrentVideoHeight) / 2.0f;
                break;
            }
            case -90: {
                xoffset = ((float)this.mLayoutWidth - this.mCurrentVideoWidth) / 2.0f;
                yoffset = ((float)this.mLayoutHeight + this.mCurrentVideoHeight) / 2.0f;
                break;
            }
            case -180: {
                xoffset = ((float)this.mLayoutWidth + this.mCurrentVideoWidth) / 2.0f;
                yoffset = ((float)this.mLayoutHeight + this.mCurrentVideoHeight) / 2.0f;
                break;
            }
            case -270: {
                xoffset = ((float)this.mLayoutWidth + this.mCurrentVideoWidth) / 2.0f;
                yoffset = ((float)this.mLayoutHeight - this.mCurrentVideoHeight) / 2.0f;
            }
        }
        if (this.mTotalTranslateX + this.mDeltaX > xoffset + (this.mCurrentVideoWidth - (float)this.mLayoutWidth) / 2.0f) {
            this.mDeltaX = 0.0f;
        } else if (this.mTotalTranslateX + this.mDeltaX < xoffset - (this.mCurrentVideoWidth - (float)this.mLayoutWidth) / 2.0f) {
            this.mDeltaX = 0.0f;
        }
        if (this.mTotalTranslateY + this.mDeltaY > yoffset + (this.mCurrentVideoHeight - (float)this.mLayoutHeight) / 2.0f) {
            this.mDeltaY = 0.0f;
        } else if (this.mTotalTranslateY + this.mDeltaY < yoffset - (this.mCurrentVideoHeight - (float)this.mLayoutHeight) / 2.0f) {
            this.mDeltaY = 0.0f;
        }
        float translateX = this.mTotalTranslateX + this.mDeltaX;
        float translateY = this.mTotalTranslateY + this.mDeltaY;
        matrix.postTranslate(translateX, translateY);
        this.mTotalTranslateX = translateX;
        this.mTotalTranslateY = translateY;
    }

    private void Normal(int widthSpecMode, int heightSpecMode) {
        float ratio = 1.0f;
        float hOffset = 0.0f;
        float vOffset = 0.0f;
        int videoWidth = this.mVideoWidth;
        int videoHeight = this.mVideoHeight;
        int width = this.mLayoutWidth;
        int height = this.mLayoutHeight;
        Matrix matrix = this.mMatrix;
        if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
            videoWidth = videoWidth * this.mVideoSarNum / this.mVideoSarDen;
        }
        float scaleX = (float)videoWidth / (float)this.mLayoutWidth;
        float scaleY = (float)videoHeight / (float)this.mLayoutHeight;
        if (this.mDegree / 90 % 2 != 0) {
            videoHeight = this.mVideoWidth;
            videoWidth = this.mVideoHeight;
            if (this.mVideoSarNum > 0 && this.mVideoSarDen > 0) {
                videoHeight = videoHeight * this.mVideoSarNum / this.mVideoSarDen;
            }
        }
        this.mInitRatio = Math.min((float)width / (float)videoWidth, (float)height / (float)videoHeight);
        switch (this.mScaleMode) {
            case 1: {
                ratio = Math.max((float)width / (float)videoWidth, (float)height / (float)videoHeight);
                vOffset = 0.0f;
                hOffset = 0.0f;
                this.mTotalRatio = ratio;
                break;
            }
            case 0: {
                ratio = Math.min((float)width / (float)videoWidth, (float)height / (float)videoHeight);
                hOffset = this.mHOffset;
                vOffset = this.mVOffset;
                this.mTotalRatio = ratio;
                break;
            }
            case 2: {
                if (this.mDegree / 90 % 2 != 0) {
                    scaleX = (float)height / (float)width;
                    scaleY = (float)width / (float)height;
                } else {
                    scaleX = 1.0f;
                    scaleY = 1.0f;
                }
                this.mTotalRatio = this.mInitRatio = ratio;
            }
        }
        if (this.mDegree / 90 % 2 != 0) {
            this.mCurrentVideoWidth = (float)height * scaleY * ratio;
            this.mCurrentVideoHeight = (float)width * scaleX * ratio;
        } else {
            this.mCurrentVideoWidth = (float)width * scaleX * ratio;
            this.mCurrentVideoHeight = (float)height * scaleY * ratio;
        }
        matrix.reset();
        matrix.postScale(ratio * scaleX, ratio * scaleY);
        matrix.postRotate((float)this.mDegree);
        float translateX = 0.0f;
        float translateY = 0.0f;
        switch (this.mDegree) {
            case 0: {
                translateX = ((float)width - this.mCurrentVideoWidth) / 2.0f;
                translateY = ((float)height - this.mCurrentVideoHeight) / 2.0f;
                break;
            }
            case -90: {
                translateX = ((float)width - this.mCurrentVideoWidth) / 2.0f;
                translateY = ((float)height + this.mCurrentVideoHeight) / 2.0f;
                break;
            }
            case -180: {
                translateX = ((float)width + this.mCurrentVideoWidth) / 2.0f;
                translateY = ((float)height + this.mCurrentVideoHeight) / 2.0f;
                break;
            }
            case -270: {
                translateX = ((float)width + this.mCurrentVideoWidth) / 2.0f;
                translateY = ((float)height - this.mCurrentVideoHeight) / 2.0f;
            }
        }
        this.mTotalTranslateX = translateX + hOffset * (float)width / 2.0f;
        this.mTotalTranslateY = translateY - vOffset * (float)height / 2.0f;
        matrix.postTranslate(this.mTotalTranslateX, this.mTotalTranslateY);
        this.mMeasureWidth = (int)((float)width * ratio * scaleX);
        this.mMeasureHeight = (int)((float)height * ratio * scaleY);
    }

    private void Measure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            return;
        }
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mLayoutWidth = widthSpecSize;
        this.mLayoutHeight = heightSpecSize;
        if (this.mCurrentDispStatus == 1) {
            this.Normal(widthSpecMode, heightSpecMode);
        }
        this.setTransform(this.mMatrix);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.Measure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    public void setMeasureSize(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    public void setSarSize(int sarNum, int sarDen) {
        this.mVideoSarNum = sarNum;
        this.mVideoSarDen = sarDen;
    }

    public boolean setMirror(boolean mirror) {
        this.mMirror = mirror;
        this.setScaleX(mirror ? -1.0f : 1.0f);
        return this.mMirror;
    }

    public boolean toggleMirror() {
        this.mMirror = !this.mMirror;
        this.setScaleX(this.mMirror ? -1.0f : 1.0f);
        return this.mMirror;
    }

    public void setDegree(int degree) {
        this.mDegree = degree;
        this.mCurrentDispStatus = 1;
        this.requestLayout();
    }

    public void setZoomMode(int zoomMode) {
        this.mScaleMode = zoomMode;
        this.mUseSettingRatio = false;
        this.mCurrentDispStatus = 1;
        this.requestLayout();
    }

    public void setVideoScaleRatio(float ratio, float x, float y) {
        if ((double)ratio < 0.25 || ratio > 100.0f) {
            return;
        }
        if (this.mScaleMode == 0 && (this.mHOffset > 0.0f || this.mHOffset < 0.0f || this.mVOffset > 0.0f || this.mVOffset < 0.0f)) {
            return;
        }
        this.mScaledRatio = ratio / this.mTotalRatio;
        this.mTotalRatio = ratio;
        this.mCenterPointX = x;
        this.mCenterPointY = y;
        this.mCurrentDispStatus = 2;
        this.Zoom();
        this.requestLayout();
    }

    public float getVideoScaleRatio() {
        return this.mTotalRatio;
    }

    public void setVerticalOrientation(boolean vertical) {
        this.mVerticalOrientation = vertical;
        this.mCurrentDispStatus = 1;
        this.requestLayout();
    }

    void setVideoOffset(float horizontal, float vertical) {
        this.mHOffset = horizontal;
        this.mVOffset = vertical;
        this.mCurrentDispStatus = 1;
        this.requestLayout();
    }

    void moveVideo(float deltaX, float deltaY) {
        if (this.mScaleMode == 0 && (this.mHOffset > 0.0f || this.mHOffset < 0.0f || this.mVOffset > 0.0f || this.mVOffset < 0.0f)) {
            return;
        }
        this.mDeltaX = deltaX;
        this.mDeltaY = deltaY;
        this.mCurrentDispStatus = 3;
        this.Move();
        this.requestLayout();
    }

    public int getMeasureWidth() {
        return this.mMeasureWidth;
    }

    public int getMeasureHeight() {
        return this.mMeasureHeight;
    }
}

