/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.media.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.media.TimedText;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.android.iplayer.base.AbstractMediaPlayer;
import com.android.iplayer.interfaces.IMediaPlayer;
import com.android.iplayer.utils.PlayerUtils;
import java.io.IOException;
import java.util.Map;

public class MediaPlayer
extends AbstractMediaPlayer {
    private android.media.MediaPlayer mMediaPlayer = new android.media.MediaPlayer();
    private int mBuffer;

    public MediaPlayer(Context context) {
        super(context);
    }

    @Override
    public void setLooping(boolean loop) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setLooping(loop);
        }
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setVolume(leftVolume, rightVolume);
        }
    }

    @Override
    public void setBufferTimeMax(float timeSecond) {
    }

    @Override
    public void setSurface(Surface surface) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setSurface(surface);
        }
    }

    @Override
    public void setDataSource(String dataSource) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (null != this.mMediaPlayer) {
            try {
                Uri uri = Uri.parse((String)dataSource);
                this.mMediaPlayer.setDataSource(null == this.getContext() ? PlayerUtils.getInstance().getContext() : this.getContext(), uri);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (null != this.mMediaPlayer) {
            try {
                this.mMediaPlayer.setDataSource(this.getContext(), Uri.parse((String)path), headers);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDataSource(AssetFileDescriptor dataSource) throws IOException, IllegalArgumentException, IllegalStateException {
        if (null != this.mMediaPlayer && Build.VERSION.SDK_INT >= 24) {
            try {
                this.mMediaPlayer.setDataSource(dataSource);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setTimeout(int prepareTimeout, int readTimeout) {
    }

    @Override
    public void setSpeed(float speed) {
    }

    @Override
    public void seekTo(long msec) throws IllegalStateException {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.seekTo((int)msec);
        }
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    @RequiresApi(api=26)
    public void seekTo(long msec, boolean accurate) throws IllegalStateException {
        if (null != this.mMediaPlayer) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mMediaPlayer.seekTo(msec, accurate ? 1 : 0);
            } else {
                this.mMediaPlayer.seekTo((int)msec);
            }
        }
    }

    @Override
    public boolean isPlaying() {
        if (null != this.mMediaPlayer) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public long getCurrentPosition() {
        if (null != this.mMediaPlayer) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (null != this.mMediaPlayer) {
            return this.mMediaPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public int getBuffer() {
        return this.mBuffer;
    }

    @Override
    public void prepare() throws IOException, IllegalStateException {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.prepare();
        }
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.prepareAsync();
        }
    }

    @Override
    public void start() {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.start();
        }
    }

    @Override
    public void pause() {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.pause();
        }
    }

    @Override
    public void stop() {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.stop();
        }
    }

    @Override
    public void reset() {
        this.mBuffer = 0;
        if (null != this.mMediaPlayer) {
            final android.media.MediaPlayer mediaPlayer = this.mMediaPlayer;
            new Thread(){

                @Override
                public void run() {
                    try {
                        mediaPlayer.reset();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    @Override
    public void release() {
        this.mBuffer = 0;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnInfoListener(null);
            this.mMediaPlayer.setOnBufferingUpdateListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.setSurface(null);
            this.mMediaPlayer.setDisplay(null);
            final android.media.MediaPlayer mediaPlayer = this.mMediaPlayer;
            this.mMediaPlayer = null;
            new Thread(){

                @Override
                public void run() {
                    try {
                        mediaPlayer.release();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        super.onRelease();
    }

    @Override
    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(android.media.MediaPlayer mediaPlayer) {
                    if (null != MediaPlayer.this.mOnPreparedListener) {
                        MediaPlayer.this.mOnPreparedListener.onPrepared(MediaPlayer.this);
                    }
                }
            });
        }
    }

    @Override
    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(android.media.MediaPlayer mediaPlayer) {
                    if (null != MediaPlayer.this.mOnCompletionListener) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(MediaPlayer.this);
                    }
                }
            });
        }
    }

    @Override
    public void setOnBufferingUpdateListener(IMediaPlayer.OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnBufferingUpdateListener(new MediaPlayer.OnBufferingUpdateListener(){

                public void onBufferingUpdate(android.media.MediaPlayer mediaPlayer, int percent) {
                    MediaPlayer.this.mBuffer = percent;
                    if (null != MediaPlayer.this.mOnBufferingUpdateListener) {
                        MediaPlayer.this.mOnBufferingUpdateListener.onBufferingUpdate(MediaPlayer.this, percent);
                    }
                }
            });
        }
    }

    @Override
    public void setOnSeekCompleteListener(IMediaPlayer.OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                public void onSeekComplete(android.media.MediaPlayer mediaPlayer) {
                    if (null != MediaPlayer.this.mOnSeekCompleteListener) {
                        MediaPlayer.this.mOnSeekCompleteListener.onSeekComplete(MediaPlayer.this);
                    }
                }
            });
        }
    }

    @Override
    public void setOnVideoSizeChangedListener(IMediaPlayer.OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                public void onVideoSizeChanged(android.media.MediaPlayer mediaPlayer, int width, int height) {
                    if (null != MediaPlayer.this.mOnVideoSizeChangedListener) {
                        MediaPlayer.this.mOnVideoSizeChangedListener.onVideoSizeChanged(MediaPlayer.this, width, height, 0, 0);
                    }
                }
            });
        }
    }

    @Override
    public void setOnErrorListener(IMediaPlayer.OnErrorListener listener) {
        this.mOnErrorListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(android.media.MediaPlayer mediaPlayer, int what, int extra) {
                    if (null != MediaPlayer.this.mOnErrorListener) {
                        return MediaPlayer.this.mOnErrorListener.onError(MediaPlayer.this, what, extra);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void setOnInfoListener(IMediaPlayer.OnInfoListener listener) {
        this.mOnInfoListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                public boolean onInfo(android.media.MediaPlayer mediaPlayer, int what, int extra) {
                    if (null != MediaPlayer.this.mOnInfoListener) {
                        return MediaPlayer.this.mOnInfoListener.onInfo(MediaPlayer.this, what, extra);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void setOnTimedTextListener(IMediaPlayer.OnTimedTextListener listener) {
        this.mOnTimedTextListener = listener;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnTimedTextListener(new MediaPlayer.OnTimedTextListener(){

                public void onTimedText(android.media.MediaPlayer mediaPlayer, TimedText timedText) {
                    if (null != MediaPlayer.this.mOnTimedTextListener) {
                        MediaPlayer.this.mOnTimedTextListener.onTimedText(MediaPlayer.this, null != timedText ? timedText.getText() : "");
                    }
                }
            });
        }
    }

    @Override
    public void setOnMessageListener(IMediaPlayer.OnMessageListener listener) {
    }
}

