/*
 * Decompiled with CFR 0.152.
 */
package com.danikula.videocache.file;

import com.danikula.videocache.CacheLog;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

class Files {
    Files() {
    }

    static void makeDir(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("File " + directory + " is not directory!");
            }
        } else {
            boolean isCreated = directory.mkdirs();
            if (!isCreated) {
                throw new IOException(String.format("Directory %s can't be created", directory.getAbsolutePath()));
            }
        }
    }

    static List<File> getLruListFiles(File directory) {
        List<File> result = new LinkedList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            result = Arrays.asList(files);
            Collections.sort(result, new LastModifiedComparator());
        }
        return result;
    }

    static void setLastModifiedNow(File file) throws IOException {
        long now;
        boolean modified;
        if (file.exists() && !(modified = file.setLastModified(now = System.currentTimeMillis()))) {
            Files.modify(file);
            if (file.lastModified() < now) {
                CacheLog.warn("Last modified date {} is not set for file {}last:" + new Date(file.lastModified()) + ",path:" + file.getAbsolutePath());
            }
        }
    }

    static void modify(File file) throws IOException {
        long size = file.length();
        if (size == 0L) {
            Files.recreateZeroSizeFile(file);
            return;
        }
        RandomAccessFile accessFile = new RandomAccessFile(file, "rwd");
        accessFile.seek(size - 1L);
        byte lastByte = accessFile.readByte();
        accessFile.seek(size - 1L);
        accessFile.write(lastByte);
        accessFile.close();
    }

    private static void recreateZeroSizeFile(File file) throws IOException {
        if (!file.delete() || !file.createNewFile()) {
            throw new IOException("Error recreate zero-size file " + file);
        }
    }

    private static final class LastModifiedComparator
    implements Comparator<File> {
        private LastModifiedComparator() {
        }

        @Override
        public int compare(File lhs, File rhs) {
            return this.compareLong(lhs.lastModified(), rhs.lastModified());
        }

        private int compareLong(long first, long second) {
            return first < second ? -1 : (first == second ? 0 : 1);
        }
    }
}

