/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.image.bigimage;

import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.github.piasy.biv.view.BigImageView;
import com.hss01248.image.ImageLoader;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PagerAdapterForBigImage
extends PagerAdapter {
    List<String> urls;
    private LinkedList<BigImageView> mViewCache = null;
    private Map<String, File> cachedFiles;

    public PagerAdapterForBigImage(List<String> urls) {
        this.urls = urls;
        this.mViewCache = new LinkedList();
        this.cachedFiles = new HashMap<String, File>();
    }

    public void changeDatas(List<String> urls) {
        if (urls != null) {
            this.urls.clear();
            this.urls.addAll(urls);
            this.notifyDataSetChanged();
        }
    }

    public void onPageSelected(int i) {
    }

    public int getCount() {
        return this.urls.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Log.e((String)"instantiateItem", (String)("postion:" + position));
        BigImageView imageView = null;
        if (this.mViewCache.size() < 4) {
            imageView = new BigImageView(container.getContext());
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
            imageView.setLayoutParams(params);
            imageView.setCachedFileMap(this.cachedFiles);
            this.mViewCache.add(imageView);
        } else {
            imageView = this.mViewCache.removeFirst();
        }
        Log.e((String)"instantiateItem", (String)imageView.toString());
        String url = this.urls.get(position);
        ImageLoader.loadBigImage((View)imageView, url);
        if (imageView.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)imageView.getParent();
            viewGroup.removeView((View)imageView);
        }
        container.addView((View)imageView);
        return imageView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        Log.e((String)"destroyItem", (String)("postion------------------:" + position));
        BigImageView contentView = (BigImageView)object;
        container.removeView((View)contentView);
        this.mViewCache.addLast(contentView);
    }
}

