/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.view;

import android.graphics.PointF;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;

public class DisplayOptimizeListener
implements SubsamplingScaleImageView.OnImageEventListener {
    private static final int LONG_IMAGE_SIZE_RATIO = 2;
    private final SubsamplingScaleImageView mImageView;
    private int mInitScaleType;

    public DisplayOptimizeListener(SubsamplingScaleImageView imageView) {
        this.mImageView = imageView;
    }

    public void onReady() {
        float result = 0.5f;
        int imageWidth = this.mImageView.getSWidth();
        int imageHeight = this.mImageView.getSHeight();
        int viewWidth = this.mImageView.getWidth();
        int viewHeight = this.mImageView.getHeight();
        boolean hasZeroValue = false;
        if (imageWidth == 0 || imageHeight == 0 || viewWidth == 0 || viewHeight == 0) {
            result = 0.5f;
            hasZeroValue = true;
        }
        if (!hasZeroValue) {
            result = imageWidth <= imageHeight ? (float)viewWidth / (float)imageWidth : (float)viewHeight / (float)imageHeight;
        }
        if (!hasZeroValue && (float)imageHeight / (float)imageWidth > 2.0f) {
            this.mImageView.animateScaleAndCenter(result, new PointF((float)(imageWidth / 2), 0.0f)).withEasing(1).start();
        }
        if (Math.abs((double)result - 0.1) < (double)0.2f) {
            result += 0.2f;
        }
        if (this.mInitScaleType == 3) {
            float maxScale = Math.max((float)viewWidth / (float)imageWidth, (float)viewHeight / (float)imageHeight);
            if (maxScale > 1.0f) {
                this.mImageView.setMinScale(1.0f);
                float defaultMaxScale = this.mImageView.getMaxScale();
                this.mImageView.setMaxScale(Math.max(defaultMaxScale, maxScale * 1.2f));
            } else {
                float minScale = Math.min((float)viewWidth / (float)imageWidth, (float)viewHeight / (float)imageHeight);
                this.mImageView.setMinScale(minScale);
            }
            this.mImageView.setScaleAndCenter(maxScale, new PointF((float)(imageWidth / 2), (float)(imageHeight / 2)));
        }
        this.mImageView.setDoubleTapZoomScale(result);
    }

    public void onImageLoaded() {
    }

    public void onPreviewLoadError(Exception e) {
    }

    public void onImageLoadError(Exception e) {
    }

    public void onTileLoadError(Exception e) {
    }

    public void onPreviewReleased() {
    }

    public void setInitScaleType(int initScaleType) {
        this.mInitScaleType = initScaleType;
    }
}

