/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.building;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.AnimationDrawable;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.hss01248.dialog.R;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.bottomsheet.BottomSheetHolder;
import com.hss01248.dialog.bottomsheet.RightMdBottomSheetDialog;
import com.hss01248.dialog.config.BottomSheetStyle;
import com.hss01248.dialog.config.ConfigBean;
import com.hss01248.dialog.ios.IosActionSheetHolder;
import com.hss01248.dialog.ios.IosAlertDialogHolder;
import com.hss01248.dialog.ios.IosCenterItemHolder;
import com.hss01248.dialog.material.MaterialDialogHolder;
import com.hss01248.dialog.material.MdInputHolder;
import com.hss01248.dialog.view.AdXHolder;
import java.util.ArrayList;

public class MyDialogBuilder {
    protected static int singleChosen;

    protected ConfigBean buildByType(ConfigBean bean) {
        Tool.fixContext(bean);
        switch (bean.type) {
            case 1: {
                Tool.newCustomDialog(bean);
                this.buildMdLoading(bean);
                break;
            }
            case 15: {
                this.buildProgress(bean);
                break;
            }
            case 2: 
            case 16: {
                if (bean.context instanceof Activity && !bean.showAsActivity) {
                    this.buildMdAlert(bean);
                    break;
                }
                this.buildMyMd(bean);
                break;
            }
            case 3: {
                if (bean.context instanceof Activity && !bean.showAsActivity) {
                    this.buildMdSingleChoose(bean);
                    break;
                }
                this.buildMyMd(bean);
                break;
            }
            case 4: {
                if (bean.context instanceof Activity && !bean.showAsActivity) {
                    this.buildMdMultiChoose(bean);
                    break;
                }
                this.buildMyMd(bean);
                break;
            }
            case 5: {
                Tool.newCustomDialog(bean);
                this.buildIosAlert(bean);
                break;
            }
            case 6: {
                Tool.newCustomDialog(bean);
                this.buildIosAlertVertical(bean);
                break;
            }
            case 7: {
                Tool.newCustomDialog(bean);
                this.buildBottomItemDialog(bean);
                break;
            }
            case 9: {
                Tool.newCustomDialog(bean);
                this.buildNormalInput(bean);
                break;
            }
            case 8: {
                Tool.newCustomDialog(bean);
                this.buildIosSingleChoose(bean);
                break;
            }
            case 10: {
                Tool.newCustomDialog(bean);
                View rootView = this.getCustomRootView(bean);
                bean.dialog.setContentView(rootView);
                break;
            }
            case 11: {
                this.buildBottomSheet(bean);
                break;
            }
            case 12: {
                this.buildBottomSheetLv(bean);
                break;
            }
            case 13: {
                this.buildBottomSheetLv(bean);
                break;
            }
            case 14: {
                Tool.newCustomDialog(bean);
                this.buildLoading(bean);
                break;
            }
        }
        AlertDialog dialog = bean.dialog == null ? bean.alertDialog : bean.dialog;
        Window window = dialog.getWindow();
        window.addFlags(0x4000000);
        Tool.setWindowAnimation(window, bean);
        Tool.setCancelable(bean);
        Tool.setListener((Dialog)dialog, bean);
        Tool.adjustStyle(bean);
        return bean;
    }

    private View getCustomRootView(ConfigBean bean) {
        if (bean.customContentHolder != null) {
            Tool.removeFromParent(bean.customContentHolder.rootView);
            if (bean.asAdXStyle) {
                AdXHolder adXHolder = new AdXHolder(bean.context);
                adXHolder.assingDatasAndEvents(bean.context, bean);
                return adXHolder.rootView;
            }
            return bean.customContentHolder.rootView;
        }
        Tool.removeFromParent(bean.customView);
        if (bean.asAdXStyle) {
            AdXHolder adXHolder = new AdXHolder(bean.context);
            adXHolder.assingDatasAndEvents(bean.context, bean);
            return adXHolder.rootView;
        }
        return bean.customView;
    }

    private void buildMyMd(ConfigBean bean) {
        Tool.newCustomDialog(bean);
        MaterialDialogHolder holder = new MaterialDialogHolder(bean.context);
        bean.viewHolder = holder;
        holder.assingDatasAndEvents(bean.context, bean);
        bean.dialog.setContentView(holder.rootView);
    }

    private void buildProgress(ConfigBean bean) {
        ProgressDialog dialog = new ProgressDialog(bean.context);
        dialog.setTitle((CharSequence)"");
        dialog.setMessage(bean.msg);
        dialog.setProgressStyle(bean.isProgressHorzontal ? 1 : 0);
        dialog.setIndeterminate(false);
        bean.dialog = dialog;
    }

    private void buildBottomSheetLv(ConfigBean bean) {
        RightMdBottomSheetDialog dialog = null;
        if (bean.hasBehaviour) {
            dialog = new RightMdBottomSheetDialog(bean.context);
            bean.forceWidthPercent = 1.0f;
        } else {
            Tool.newCustomDialog(bean);
            dialog = bean.dialog;
            bean.gravity = 81;
            bean.forceWidthPercent = 1.0f;
            bean.bgRes = R.color.dialogutil_bg_white;
        }
        bean.dialog = dialog;
        if (bean.bottomSheetStyle == null) {
            bean.bottomSheetStyle = BottomSheetStyle.newBuilder().build();
        }
        BottomSheetHolder bottomSheetHolder = new BottomSheetHolder(bean.context);
        bottomSheetHolder.assingDatasAndEvents(bean.context, bean);
        bean.viewHolder = bottomSheetHolder;
        dialog.setContentView(bottomSheetHolder.rootView);
    }

    private void buildBottomSheet(ConfigBean bean) {
        BottomSheetDialog dialog = new BottomSheetDialog(bean.context);
        Tool.removeFromParent(bean.customView);
        dialog.setContentView(bean.customView);
        bean.forceWidthPercent = 1.0f;
        dialog.setCancelable(bean.cancelable);
        dialog.setCanceledOnTouchOutside(bean.outsideTouchable);
        bean.dialog = dialog;
    }

    protected ConfigBean buildLoading(ConfigBean bean) {
        View root = View.inflate((Context)bean.context, (int)R.layout.loading, null);
        ImageView gifMovieView = (ImageView)root.findViewById(R.id.iv_loading);
        AnimationDrawable drawable2 = (AnimationDrawable)gifMovieView.getDrawable();
        if (drawable2 != null) {
            drawable2.start();
        }
        TextView tvMsg = (TextView)root.findViewById(R.id.loading_msg);
        tvMsg.setText(bean.msg);
        bean.dialog.setContentView(root);
        return bean;
    }

    protected ConfigBean buildMdLoading(ConfigBean bean) {
        View root = View.inflate((Context)bean.context, (int)R.layout.progressview_wrapconent, null);
        TextView tvMsg = (TextView)root.findViewById(R.id.loading_msg);
        tvMsg.setText(bean.msg);
        bean.dialog.setContentView(root);
        return bean;
    }

    protected ConfigBean buildMdAlert(final ConfigBean bean) {
        Tool.fixContext(bean);
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.context);
        if (bean.customContentHolder == null) {
            if (bean.type == 16) {
                MdInputHolder holder = new MdInputHolder(bean.context);
                bean.viewHolder = holder;
                bean.setNeedSoftKeyboard(true);
                holder.assingDatasAndEvents(bean.context, bean);
                builder.setView(bean.viewHolder.rootView);
            } else {
                builder.setMessage(bean.msg);
            }
        } else {
            builder.setView(bean.customContentHolder.rootView);
        }
        builder.setTitle(bean.title).setPositiveButton(bean.text1, null).setNegativeButton(bean.text2, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                bean.listener.onSecond();
                Tool.hideKeyBorad(bean);
                dialog.dismiss();
            }
        }).setNeutralButton(bean.text3, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                bean.listener.onThird();
                Tool.hideKeyBorad(bean);
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                Tool.hideKeyBorad(bean);
                if (bean.listener != null) {
                    bean.listener.onCancle();
                }
            }
        });
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (bean.listener != null) {
                    bean.listener.onDismiss();
                }
            }
        });
        bean.alertDialog = dialog;
        return bean;
    }

    protected ConfigBean buildMdSingleChoose(final ConfigBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.context);
        singleChosen = bean.defaultChosen;
        builder.setTitle(bean.title).setPositiveButton(bean.text1, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (bean.listener != null) {
                    bean.listener.onFirst();
                    bean.listener.onGetChoose(singleChosen, bean.wordsMd[singleChosen]);
                }
                Tool.dismiss(bean, true);
            }
        }).setNegativeButton(bean.text2, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (bean.listener != null) {
                    bean.listener.onSecond();
                }
                Tool.dismiss(bean);
            }
        }).setSingleChoiceItems(bean.wordsMd, bean.defaultChosen, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                singleChosen = i;
                if (bean.itemListener != null) {
                    bean.itemListener.onItemClick(bean.wordsMd[i], i);
                }
                Tool.dismiss(bean, true);
            }
        });
        bean.alertDialog = dialog = builder.create();
        return bean;
    }

    protected ConfigBean buildMdMultiChoose(final ConfigBean bean) {
        AlertDialog dialog;
        AlertDialog.Builder builder = new AlertDialog.Builder(bean.context);
        builder.setTitle(bean.title).setCancelable(true).setPositiveButton(bean.text1, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (bean.listener != null) {
                    bean.listener.onFirst();
                    bean.listener.onGetChoose(bean.checkedItems);
                    ArrayList<Integer> selectedIndex = new ArrayList<Integer>();
                    ArrayList<CharSequence> selectedStrs = new ArrayList<CharSequence>();
                    for (int j = 0; j < bean.checkedItems.length; ++j) {
                        if (!bean.checkedItems[j]) continue;
                        selectedIndex.add(j);
                        selectedStrs.add(bean.wordsMd[j]);
                    }
                    bean.listener.onChoosen(selectedIndex, selectedStrs, bean.checkedItems);
                }
                Tool.dismiss(bean, true);
            }
        }).setNegativeButton(bean.text2, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (bean.listener != null) {
                    bean.listener.onSecond();
                }
                Tool.dismiss(bean);
            }
        }).setMultiChoiceItems(bean.wordsMd, bean.checkedItems, new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialogInterface, int i, boolean b) {
            }
        });
        bean.alertDialog = dialog = builder.create();
        return bean;
    }

    protected ConfigBean buildIosAlert(ConfigBean bean) {
        bean.isVertical = false;
        bean.hint1 = "";
        bean.hint2 = "";
        this.buildIosCommon(bean);
        return bean;
    }

    protected ConfigBean buildIosAlertVertical(ConfigBean bean) {
        bean.isVertical = true;
        bean.hint1 = "";
        bean.hint2 = "";
        this.buildIosCommon(bean);
        return bean;
    }

    protected ConfigBean buildIosSingleChoose(ConfigBean bean) {
        IosCenterItemHolder holder = new IosCenterItemHolder(bean.context);
        bean.viewHolder = holder;
        bean.dialog.setContentView(holder.rootView);
        holder.assingDatasAndEvents(bean.context, bean);
        bean.viewHeight = Tool.mesureHeight(holder.rootView, new View[]{holder.lv});
        Window window = bean.dialog.getWindow();
        window.setGravity(17);
        return bean;
    }

    protected ConfigBean buildBottomItemDialog(ConfigBean bean) {
        IosActionSheetHolder holder = new IosActionSheetHolder(bean.context);
        bean.viewHolder = holder;
        bean.dialog.setContentView(holder.rootView);
        holder.assingDatasAndEvents(bean.context, bean);
        bean.viewHeight = Tool.mesureHeight(holder.rootView, new View[]{holder.lv});
        Window window = bean.dialog.getWindow();
        window.setGravity(80);
        window.setWindowAnimations(R.style.mystyle);
        return bean;
    }

    protected ConfigBean buildNormalInput(ConfigBean bean) {
        this.buildIosCommon(bean);
        return bean;
    }

    private ConfigBean buildIosCommon(ConfigBean bean) {
        int height;
        IosAlertDialogHolder holder = new IosAlertDialogHolder(bean.context);
        bean.viewHolder = holder;
        bean.dialog.setContentView(holder.rootView);
        holder.assingDatasAndEvents(bean.context, bean);
        bean.viewHeight = height = Tool.mesureHeight(holder.rootView, new View[]{holder.tvMsg, holder.et1, holder.et2});
        return bean;
    }
}

