/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.bottomsheet;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.annotation.Nullable;
import com.hss01248.dialog.ScreenUtil;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.adapter.SuperLvAdapter;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.adapter.SuperPagerHolder;
import com.hss01248.dialog.bottomsheet.BottomSheetBean;
import com.hss01248.dialog.bottomsheet.BsGvHolder;
import com.hss01248.dialog.config.BottomSheetStyle;
import com.hss01248.dialog.config.ConfigBean;
import java.util.List;

public class BottomSheetPagerHolder
extends SuperPagerHolder<List<BottomSheetBean>> {
    GridView mGridView;
    ConfigBean mConfigBean;
    SuperLvAdapter adapter;
    int pageNum;

    public BottomSheetPagerHolder(Context context) {
        super(context);
    }

    public BottomSheetPagerHolder setPageNum(int pageNum) {
        this.pageNum = pageNum;
        return this;
    }

    @Override
    protected ViewGroup setRootView(Context context) {
        this.mGridView = new GridView(context);
        return this.mGridView;
    }

    public BottomSheetPagerHolder setConfigBean(ConfigBean configBean) {
        this.mConfigBean = configBean;
        this.setGridViewStyle(configBean);
        return this;
    }

    private void setGridViewStyle(final ConfigBean bean) {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
        BottomSheetStyle bottomSheetStyle = bean.bottomSheetStyle;
        this.mGridView.setLayoutParams(params);
        this.mGridView.setNumColumns(bean.gridColumns);
        this.mGridView.setVerticalSpacing(ScreenUtil.dip2px(bottomSheetStyle.gvItemMargin_V));
        this.mGridView.setHorizontalSpacing(ScreenUtil.dip2px(bottomSheetStyle.gvItemMargin_H));
        this.adapter = new SuperLvAdapter(bean.context){

            @Override
            protected SuperLvHolder generateNewHolder(Context context, int itemViewType) {
                BsGvHolder holder = new BsGvHolder(context);
                holder.setStyle(bean.bottomSheetStyle);
                return holder;
            }
        };
        this.mGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (bean.itemListener != null) {
                    int actualPosition = BottomSheetPagerHolder.this.pageNum * bean.gridColumns * 2 + position;
                    bean.itemListener.onItemClick(bean.lvDatas.get((int)actualPosition).text, actualPosition);
                }
                Tool.dismiss(bean, true);
            }
        });
        this.mGridView.setAdapter((ListAdapter)this.adapter);
    }

    @Override
    protected int setLayoutRes() {
        return 0;
    }

    @Override
    protected void findViews() {
    }

    @Override
    public void assingDatasAndEvents(Context context, @Nullable List<BottomSheetBean> bean, int position) {
        this.adapter.refresh(bean);
    }
}

