/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.material;

import android.content.Context;
import android.text.TextUtils;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.View;
import android.widget.EditText;
import com.hss01248.dialog.R;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.config.ConfigBean;

public class MdInputHolder
extends SuperLvHolder<ConfigBean> {
    EditText et1;
    EditText et2;
    ConfigBean bean;

    public MdInputHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.et1 = (EditText)this.rootView.findViewById(R.id.et_1);
        this.et2 = (EditText)this.rootView.findViewById(R.id.et_2);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.dialogutil_md_input;
    }

    @Override
    public void assingDatasAndEvents(Context context, ConfigBean bean) {
        this.bean = bean;
        this.setInputStyle(context, bean);
    }

    public String getTxt1() {
        if (this.et1 != null) {
            return this.et1.getText().toString().trim();
        }
        return "";
    }

    public String getTxt2() {
        if (this.et2 != null) {
            return this.et2.getText().toString().trim();
        }
        return "";
    }

    public EditText getEt1() {
        return this.et1;
    }

    public EditText getEt2() {
        return this.et2;
    }

    private void setInputStyle(Context context, ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.hint1)) {
            this.et1.setVisibility(8);
        } else {
            bean.setNeedSoftKeyboard(true);
            this.et1.setVisibility(0);
            this.et1.setHint(bean.hint1);
            this.et1.setTextColor(Tool.getColor(this.et1.getContext(), bean.inputTxtColor));
            this.et1.setTextSize((float)bean.inputTxtSize);
        }
        if (TextUtils.isEmpty((CharSequence)bean.hint2)) {
            this.et2.setVisibility(8);
        } else {
            bean.setNeedSoftKeyboard(true);
            this.et2.setVisibility(0);
            this.et2.setHint(bean.hint2);
            this.et2.setTextColor(Tool.getColor(this.et2.getContext(), bean.inputTxtColor));
            this.et2.setTextSize((float)bean.inputTxtSize);
            if (bean.isInput2HideAsPassword) {
                this.et2.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            } else {
                this.et2.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
            }
        }
    }

    @Override
    public void showKeyBoard() {
        if (TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.showKeyBoard((View)this.et1);
        } else if (TextUtils.isEmpty((CharSequence)this.bean.hint1) && !TextUtils.isEmpty((CharSequence)this.bean.hint2)) {
            Tool.showKeyBoard((View)this.et2);
        } else if (!TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.showKeyBoard((View)this.et1);
        }
    }

    @Override
    public void hideKeyBoard() {
        if (TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.hideKeyBoard((View)this.et1);
        } else if (TextUtils.isEmpty((CharSequence)this.bean.hint1) && !TextUtils.isEmpty((CharSequence)this.bean.hint2)) {
            Tool.hideKeyBoard((View)this.et2);
        } else if (!TextUtils.isEmpty((CharSequence)this.bean.hint2) && !TextUtils.isEmpty((CharSequence)this.bean.hint1)) {
            Tool.hideKeyBoard((View)this.et1);
        }
    }
}

