/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.app.AppCompatDialog;
import android.view.View;
import android.widget.TextView;
import com.hss01248.dialog.DialogAssigner;
import com.hss01248.dialog.R;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.config.ConfigBean;
import com.hss01248.dialog.config.DefaultConfig;
import com.hss01248.dialog.interfaces.MyDialogListener;
import com.hss01248.dialog.interfaces.MyItemDialogListener;
import java.util.List;

public class StyledDialog {
    public static Context context;
    private static int singleChosen;
    private static DialogInterface loadingDialog;
    private static long startTime;
    private static boolean isMiUi8;
    private static Handler mainHandler;

    public static DialogInterface getLoadingDialog() {
        return loadingDialog;
    }

    public static Handler getMainHandler() {
        if (mainHandler == null) {
            mainHandler = new Handler(Looper.getMainLooper());
        }
        return mainHandler;
    }

    public static void init(Context context) {
        StyledDialog.context = context;
        mainHandler = new Handler(Looper.getMainLooper());
        DefaultConfig.initBtnTxt(context);
    }

    public static void setLoadingObj(DialogInterface loading) {
        StyledDialog.dismiss(loadingDialog);
        loadingDialog = loading;
        startTime = System.currentTimeMillis();
    }

    public static void dismissLoading() {
        if (loadingDialog != null) {
            StyledDialog.getMainHandler().post(new Runnable(){

                @Override
                public void run() {
                    StyledDialog.dismiss(loadingDialog);
                    loadingDialog = null;
                }
            });
        }
    }

    public static void dismiss(DialogInterface ... dialogs) {
        if (dialogs != null && dialogs.length > 0) {
            for (DialogInterface dialog : dialogs) {
                AppCompatDialog dialog2;
                if (dialog instanceof Dialog) {
                    Dialog dialog1 = (Dialog)dialog;
                    if (!dialog1.isShowing()) continue;
                    try {
                        dialog1.dismiss();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(dialog instanceof AppCompatDialog) || !(dialog2 = (AppCompatDialog)dialog).isShowing()) continue;
                try {
                    dialog2.dismiss();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ConfigBean buildProgress(CharSequence msg, boolean isHorizontal) {
        return DialogAssigner.getInstance().assignProgress(null, msg, isHorizontal);
    }

    public static void updateLoadingMsg(final String msg, final Dialog dialog) {
        if (dialog == null) {
            return;
        }
        if (!dialog.isShowing()) {
            return;
        }
        StyledDialog.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    View view = dialog.getWindow().getDecorView().findViewById(R.id.loading_msg);
                    if (view instanceof TextView) {
                        TextView textView = (TextView)view;
                        textView.setText((CharSequence)msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void updateProgress(final Dialog dialog, final int progress, final int max, final CharSequence msg, final boolean isHorizontal) {
        StyledDialog.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (dialog instanceof ProgressDialog && dialog.isShowing()) {
                    ProgressDialog progressDialog = (ProgressDialog)dialog;
                    if (isHorizontal) {
                        progressDialog.setProgress(progress);
                        progressDialog.setMax(max);
                    } else {
                        String pmsg = new StringBuilder(msg).append(":").append(progress * 100 / max).append("%").toString();
                        progressDialog.setMessage((CharSequence)pmsg);
                    }
                }
            }
        });
    }

    public static ConfigBean buildLoading(CharSequence msg) {
        return DialogAssigner.getInstance().assignLoading(null, msg, true, false);
    }

    public static ConfigBean buildLoading() {
        return DialogAssigner.getInstance().assignLoading(null, DefaultConfig.loadingTxt, true, false);
    }

    public static ConfigBean buildMdLoading() {
        return DialogAssigner.getInstance().assignMdLoading(null, DefaultConfig.loadingTxt, true, false);
    }

    public static ConfigBean buildMdLoading(CharSequence msg) {
        return DialogAssigner.getInstance().assignMdLoading(null, msg, true, false);
    }

    public static ConfigBean buildMdAlert(CharSequence title, CharSequence msg, MyDialogListener listener) {
        return DialogAssigner.getInstance().assignMdAlert(null, title, msg, listener);
    }

    public static ConfigBean buildMdSingleChoose(CharSequence title, int defaultChosen, CharSequence[] words, MyItemDialogListener listener) {
        return DialogAssigner.getInstance().assignMdSingleChoose(null, title, defaultChosen, words, listener);
    }

    @Deprecated
    public static ConfigBean buildMdMultiChoose(CharSequence title, CharSequence[] words, boolean[] checkedItems, MyDialogListener btnListener) {
        return DialogAssigner.getInstance().assignMdMultiChoose(null, title, words, checkedItems, btnListener);
    }

    public static ConfigBean buildMdMultiChoose(CharSequence title, CharSequence[] words, List<Integer> selectedIndexs, MyDialogListener btnListener) {
        return DialogAssigner.getInstance().assignMdMultiChoose(null, title, words, selectedIndexs, btnListener);
    }

    public static ConfigBean buildIosAlert(CharSequence title, CharSequence msg, MyDialogListener listener) {
        return DialogAssigner.getInstance().assignIosAlert(null, title, msg, listener);
    }

    public static ConfigBean buildIosAlertVertical(CharSequence title, CharSequence msg, MyDialogListener listener) {
        return DialogAssigner.getInstance().assignIosAlertVertical(null, title, msg, listener);
    }

    public static ConfigBean buildIosSingleChoose(List<? extends CharSequence> words, MyItemDialogListener listener) {
        return DialogAssigner.getInstance().assignIosSingleChoose(null, words, listener);
    }

    public static ConfigBean buildBottomItemDialog(List<? extends CharSequence> words, CharSequence bottomTxt, MyItemDialogListener listener) {
        return DialogAssigner.getInstance().assignBottomItemDialog(null, words, bottomTxt, listener);
    }

    public static ConfigBean buildNormalInput(CharSequence title, CharSequence hint1, CharSequence hint2, CharSequence firstTxt, CharSequence secondTxt, MyDialogListener listener) {
        return DialogAssigner.getInstance().assignNormalInput(null, title, hint1, hint2, firstTxt, secondTxt, listener);
    }

    public static ConfigBean buildMdInput(CharSequence title, CharSequence hint1, CharSequence hint2, CharSequence firstTxt, CharSequence secondTxt, MyDialogListener listener) {
        return DialogAssigner.getInstance().buildMdInput(title, hint1, hint2, firstTxt, secondTxt, listener);
    }

    public static ConfigBean buildCustomInMd(SuperLvHolder customViewHolder, MyDialogListener listener) {
        return DialogAssigner.getInstance().buildCustomInMd(customViewHolder, listener);
    }

    public static ConfigBean buildCustomInIos(SuperLvHolder customViewHolder, MyDialogListener listener) {
        return DialogAssigner.getInstance().buildCustomInIos(customViewHolder, listener);
    }

    @Deprecated
    public static ConfigBean buildCustom(View contentView, int gravity) {
        return DialogAssigner.getInstance().assignCustom(null, contentView, gravity);
    }

    public static ConfigBean buildCustom(SuperLvHolder viewHolder) {
        return DialogAssigner.getInstance().assignCustom(null, viewHolder);
    }

    public static ConfigBean buildCustomBottomSheet(View contentView) {
        return DialogAssigner.getInstance().assignCustomBottomSheet(null, contentView);
    }

    public static ConfigBean buildBottomSheetLv(CharSequence title, List datas, CharSequence bottomTxt, MyItemDialogListener listener) {
        return DialogAssigner.getInstance().assignBottomSheetLv(null, title, datas, bottomTxt, listener);
    }

    public static ConfigBean buildBottomSheetGv(CharSequence title, List datas, CharSequence bottomTxt, int columnsNum, MyItemDialogListener listener) {
        return DialogAssigner.getInstance().assignBottomSheetGv(null, title, datas, bottomTxt, columnsNum, listener);
    }

    static {
        isMiUi8 = false;
    }
}

