/*
 * Decompiled with CFR 0.152.
 */
package ozaydin.serkan.com.image_zoom_view;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.FragmentActivity;
import ozaydin.serkan.com.image_zoom_view.Dialog;
import ozaydin.serkan.com.image_zoom_view.ImageProperties;
import ozaydin.serkan.com.image_zoom_view.ImageSaveProperties;
import ozaydin.serkan.com.image_zoom_view.ImageViewZoomConfig;
import ozaydin.serkan.com.image_zoom_view.Permission;
import ozaydin.serkan.com.image_zoom_view.R;
import ozaydin.serkan.com.image_zoom_view.SaveFileListener;

public class ImageViewZoom
extends AppCompatImageView
implements View.OnClickListener {
    private Boolean isCircle = false;
    private ImageViewZoomConfig imageViewZoomConfig;
    private ImageSaveProperties imageSaveProperties;

    public ImageViewZoom(Context context) {
        super(context);
        this.setOnClickListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageViewZoom(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnClickListener(this);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ImageViewZoom, 0, 0);
        try {
            this.isCircle = a.getBoolean(R.styleable.ImageViewZoom_circle, false);
        }
        finally {
            a.recycle();
        }
    }

    public ImageViewZoom(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOnClickListener(this);
    }

    public String getBase64() {
        return ImageProperties.bitmapToBase64(((BitmapDrawable)this.getDrawable()).getBitmap());
    }

    public Bitmap getBitmap() {
        return ((BitmapDrawable)this.getDrawable()).getBitmap();
    }

    public void saveImage(Activity activity, String folderName, String fileName, Bitmap.CompressFormat compressFormat, int permissionRequestCode, ImageViewZoomConfig imageViewZoomConfig, SaveFileListener saveFileListener) {
        if (imageViewZoomConfig.getImageViewZoomConfigSaveMethod() == null) {
            Log.e((String)"ImageViewZoom", (String)"Please set ImageViewZoomConfig save method\n\n");
            throw new RuntimeException();
        }
        switch (imageViewZoomConfig.getImageViewZoomConfigSaveMethod()) {
            case always: {
                if (!Permission.askPermissionForActivity(activity, "android.permission.WRITE_EXTERNAL_STORAGE", permissionRequestCode)) break;
                ImageProperties.saveImage(this.getBitmap(), folderName, fileName, compressFormat, saveFileListener);
                this.imageSaveProperties = new ImageSaveProperties(folderName, fileName, compressFormat, permissionRequestCode, saveFileListener);
                break;
            }
            case onlyOnDialog: {
                this.imageSaveProperties = new ImageSaveProperties(folderName, fileName, compressFormat, permissionRequestCode, saveFileListener);
                break;
            }
            default: {
                this.imageSaveProperties = new ImageSaveProperties(folderName, fileName, compressFormat, permissionRequestCode, saveFileListener);
            }
        }
    }

    public void setConfig(ImageViewZoomConfig config) {
        this.imageViewZoomConfig = config;
    }

    public void onClick(View view) {
        if (this.getDrawable() != null) {
            if (this.imageSaveProperties != null) {
                new Dialog().show(((FragmentActivity)this.getContext()).getSupportFragmentManager(), this.getBitmap(), this.imageViewZoomConfig, this.imageSaveProperties);
            } else {
                new Dialog().show(((FragmentActivity)this.getContext()).getSupportFragmentManager(), this.getBitmap(), this.imageViewZoomConfig);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isCircle.booleanValue()) {
            this.drawAsCircle(canvas);
        } else {
            super.onDraw(canvas);
        }
    }

    public void drawAsCircle(Canvas canvas) {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        Bitmap b = ((BitmapDrawable)drawable).getBitmap();
        Bitmap bitmap = b.copy(Bitmap.Config.ARGB_8888, true);
        int w = this.getWidth();
        int h = this.getHeight();
        Bitmap roundBitmap = this.getCroppedBitmap(bitmap, w);
        canvas.drawBitmap(roundBitmap, 0.0f, 0.0f, null);
    }

    public Bitmap getCroppedBitmap(Bitmap bmp, int radius) {
        Bitmap sbmp;
        if (bmp.getWidth() != radius || bmp.getHeight() != radius) {
            float smallest = Math.min(bmp.getWidth(), bmp.getHeight());
            float factor = smallest / (float)radius;
            sbmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)((int)((float)bmp.getWidth() / factor)), (int)((int)((float)bmp.getHeight() / factor)), (boolean)false);
        } else {
            sbmp = bmp;
        }
        Bitmap output = Bitmap.createBitmap((int)radius, (int)radius, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, radius, radius);
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawCircle((float)(radius / 2) + 0.7f, (float)(radius / 2) + 0.7f, (float)(radius / 2) + 0.1f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(sbmp, rect, rect, paint);
        return output;
    }

    public Boolean getCircle() {
        return this.isCircle;
    }

    public void setCircle(Boolean circle) {
        this.isCircle = circle;
    }
}

