/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.resourcereader;

import com.github.houbie.lesscss.resourcereader.ResourceReader;
import com.github.houbie.lesscss.utils.IOUtils;
import com.github.houbie.lesscss.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathResourceReader
implements ResourceReader {
    private static Logger logger = LoggerFactory.getLogger(ClasspathResourceReader.class);
    private String basePath;
    private String encoding;

    public ClasspathResourceReader() {
        this(null);
    }

    public ClasspathResourceReader(String basePath) {
        this(basePath, null);
    }

    public ClasspathResourceReader(String basePath, String encoding) {
        this.setBasePath(basePath);
        this.encoding = encoding;
    }

    private void setBasePath(String basePath) {
        if (StringUtils.isEmpty(basePath)) {
            this.basePath = "";
        } else {
            this.basePath = basePath.trim();
            if (this.basePath.startsWith("/")) {
                this.basePath = this.basePath.substring(1);
            }
            if (!this.basePath.endsWith("/")) {
                this.basePath = this.basePath + '/';
            }
        }
    }

    @Override
    public boolean canRead(String location) {
        return this.getUrl(location) != null;
    }

    @Override
    public String read(String location) throws IOException {
        if (StringUtils.isEmpty(location)) {
            return null;
        }
        logger.debug("reading {} with basePath {}", (Object)location, (Object)this.basePath);
        URL url = this.getUrl(location);
        return url != null ? IOUtils.read(url, this.encoding) : null;
    }

    @Override
    public byte[] readBytes(String location) throws IOException {
        if (StringUtils.isEmpty(location)) {
            return null;
        }
        logger.debug("reading bytes {} with basePath {}", (Object)location, (Object)this.basePath);
        URL url = this.getUrl(location);
        if (url != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copyLarge(url.openStream(), bos);
            return bos.toByteArray();
        }
        return null;
    }

    private URL getUrl(String location) {
        String path = location.startsWith("/") ? location.substring(1) : this.basePath + location;
        return this.getClass().getClassLoader().getResource(path);
    }

    @Override
    public long lastModified(String location) {
        return this.canRead(location) ? Long.MIN_VALUE : Long.MAX_VALUE;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathResourceReader that = (ClasspathResourceReader)o;
        if (!this.basePath.equals(that.basePath)) {
            return false;
        }
        return !(this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null);
    }

    public int hashCode() {
        int result = this.basePath.hashCode();
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        return result;
    }
}

