/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.handler.archive;

import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.compress.handler.archive.AbstractUnArchiveHandler;
import com.github.houbb.compress.handler.io.SevenZArchiveInputStream;
import com.github.houbb.heaven.annotation.CommonEager;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.id.impl.Ids;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

@ThreadSafe
public class ServenZUnArchiveHandler
extends AbstractUnArchiveHandler {
    @Override
    protected ArchiveInputStream getArchiveInputStream(InputStream inputStream, String password) {
        try {
            File sourceFile = this.inputStreamToFile(inputStream);
            SevenZFile sevenZFile = StringUtil.isEmpty((String)password) ? new SevenZFile(sourceFile) : new SevenZFile(sourceFile, password.toCharArray());
            return new SevenZArchiveInputStream(sevenZFile);
        }
        catch (IOException e) {
            throw new CompressRuntimeException(e);
        }
    }

    @CommonEager
    private File inputStreamToFile(InputStream inputStream) {
        if (ObjectUtil.isNull((Object)inputStream)) {
            return null;
        }
        try {
            File temp = File.createTempFile(Ids.uuid32(), "temp");
            temp.deleteOnExit();
            Files.copy(inputStream, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file = temp;
            return file;
        }
        catch (IOException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
        finally {
            StreamUtil.closeStream((Closeable)inputStream);
        }
    }
}

