/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.handler.archive;

import com.github.houbb.compress.api.ICompressContext;
import com.github.houbb.compress.api.IUncompressResult;
import com.github.houbb.compress.api.impl.UncompressResult;
import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.compress.handler.IUncompressHandler;
import com.github.houbb.compress.support.file.impl.FileInfo;
import com.github.houbb.heaven.util.guava.Guavas;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;

abstract class AbstractUnArchiveHandler
implements IUncompressHandler {
    AbstractUnArchiveHandler() {
    }

    protected abstract ArchiveInputStream getArchiveInputStream(InputStream var1, String var2);

    protected int getEntrySize(ArchiveEntry entry) {
        return (int)entry.getSize();
    }

    @Override
    public IUncompressResult handle(ICompressContext context) {
        return this.doHandler(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IUncompressResult doHandler(ICompressContext context) {
        InputStream sourceStream = context.uncompressStream();
        File targetDir = context.targetPath().toFile();
        String password = context.password();
        boolean createFile = context.createFile();
        UncompressResult uncompressResult = UncompressResult.newInstance();
        List fileInfos = Guavas.newArrayList();
        try (ArchiveInputStream inputStream = this.getArchiveInputStream(sourceStream, password);){
            ArchiveEntry entry = inputStream.getNextEntry();
            while (entry != null) {
                String path = this.buildFilePath(targetDir, entry);
                FileInfo fileInfo = FileInfo.newInstance().path(path);
                if (entry.isDirectory()) {
                    if (createFile) {
                        File dir = new File(path);
                        dir.mkdirs();
                    }
                    fileInfo.directory(true);
                } else {
                    int entrySize = this.getEntrySize(entry);
                    byte[] content = new byte[entrySize];
                    for (int readCount = 0; readCount < entrySize && readCount != -1; readCount += inputStream.read(content, readCount, entrySize - readCount)) {
                    }
                    fileInfo.content(content);
                    if (createFile) {
                        File file = new File(path);
                        file.getParentFile().mkdirs();
                        try (FileOutputStream out = new FileOutputStream(file);){
                            out.write(content);
                        }
                    }
                }
                fileInfos.add(fileInfo);
                entry = inputStream.getNextEntry();
            }
            uncompressResult.fileInfos(fileInfos);
            UncompressResult uncompressResult2 = uncompressResult;
            return uncompressResult2;
        }
        catch (IOException e) {
            throw new CompressRuntimeException(e);
        }
    }

    @Deprecated
    private File buildFile(File targetDir, ArchiveEntry entry) {
        String path = this.buildFilePath(targetDir, entry);
        return new File(path);
    }

    private String buildFilePath(File targetDir, ArchiveEntry entry) {
        return targetDir.getPath() + File.separator + entry.getName();
    }
}

