/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.bs;

import com.github.houbb.compress.api.ICompress;
import com.github.houbb.compress.api.impl.Compress;
import com.github.houbb.compress.bs.CompressContextBs;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;

public final class CompressBs {
    private CompressTypeEnum compressType;
    private String[] sourcePaths;
    private String target;
    private String password = null;
    private boolean relativePath = true;
    private ICompress compress = (ICompress)Instances.singleton(Compress.class);

    private CompressBs() {
    }

    public static CompressBs newInstance(CompressTypeEnum compressTypeEnum) {
        CompressBs compressBs = new CompressBs();
        compressBs.compressType = compressTypeEnum;
        return compressBs;
    }

    private CompressBs compressType(CompressTypeEnum compressTypeEnum) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        this.compressType = compressTypeEnum;
        return this;
    }

    public CompressBs source(String ... sources) {
        ArgUtil.notEmpty((Object[])sources, (String)"sources");
        this.sourcePaths = sources;
        return this;
    }

    public CompressBs target(String target) {
        ArgUtil.notEmpty((String)target, (String)"target");
        this.target = target;
        return this;
    }

    public CompressBs password(String password) {
        ArgUtil.notEmpty((String)password, (String)"password");
        this.password = password;
        return this;
    }

    public CompressBs relativePath(boolean relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public void compress() {
        CompressContextBs context = this.buildCompressContextBs();
        this.compress.compress(context);
    }

    public void uncompress() {
        CompressContextBs context = this.buildCompressContextBs();
        this.compress.uncompress(context);
    }

    private CompressContextBs buildCompressContextBs() {
        return CompressContextBs.newInstance().isRelativePath(this.relativePath).source(this.sourcePaths).target(this.target).compressType(this.compressType).password(this.password);
    }
}

