/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.bs;

import com.github.houbb.compress.bs.CompressContextBs;
import com.github.houbb.compress.constant.CompressTypeEnum;
import com.github.houbb.compress.handler.factory.CompressFactory;
import com.github.houbb.compress.handler.factory.UnCompressFactory;
import com.github.houbb.heaven.util.common.ArgUtil;

public final class CompressBs {
    private CompressTypeEnum compressTypeEnum;
    private CompressContextBs compressContextBs = CompressContextBs.newInstance();

    private CompressBs() {
    }

    public static CompressBs newInstance(CompressTypeEnum compressTypeEnum) {
        CompressBs compressBs = new CompressBs();
        return compressBs.compressTypeEnum(compressTypeEnum);
    }

    private CompressBs compressTypeEnum(CompressTypeEnum compressTypeEnum) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        this.compressTypeEnum = compressTypeEnum;
        return this;
    }

    public CompressBs source(String source) {
        ArgUtil.notEmpty((String)source, (String)"source");
        this.compressContextBs.source(source);
        return this;
    }

    public CompressBs target(String target) {
        ArgUtil.notEmpty((String)target, (String)"target");
        this.compressContextBs.target(target);
        return this;
    }

    public CompressBs password(String password) {
        ArgUtil.notEmpty((String)password, (String)"password");
        this.compressContextBs.password(password);
        return this;
    }

    public CompressBs relativePath(boolean relativePath) {
        this.compressContextBs.isRelativePath(relativePath);
        return this;
    }

    public void compress() {
        CompressFactory.getHandler(this.compressTypeEnum).handle(this.compressContextBs);
    }

    public void uncompress() {
        UnCompressFactory.getHandler(this.compressTypeEnum).handle(this.compressContextBs);
    }
}

