/*
 * Decompiled with CFR 0.152.
 */
package com.hosopy.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class EventLoop
extends Thread {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            eventLoop = new EventLoop(runnable);
            eventLoop.setName("EventLoop");
            return eventLoop;
        }
    };
    private static EventLoop eventLoop;
    private static ExecutorService executorService;
    private static int counter;

    private EventLoop(Runnable runnable) {
        super(runnable);
    }

    public static boolean isCurrentThread() {
        return EventLoop.currentThread() == eventLoop;
    }

    public static void execute(Runnable task) {
        if (EventLoop.isCurrentThread()) {
            task.run();
        } else {
            EventLoop.post(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(final Runnable task) {
        Class<EventLoop> clazz = EventLoop.class;
        synchronized (EventLoop.class) {
            ++counter;
            if (executorService == null) {
                executorService = Executors.newSingleThreadExecutor(THREAD_FACTORY);
            }
            ExecutorService executor = executorService;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        Class<EventLoop> clazz = EventLoop.class;
                        synchronized (EventLoop.class) {
                            counter--;
                            if (counter == 0) {
                                executorService.shutdown();
                                executorService = null;
                                eventLoop = null;
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                }
            });
            return;
        }
    }

    static {
        counter = 0;
    }
}

