/*
 * Decompiled with CFR 0.152.
 */
package com.hosopy.actioncable;

import com.hosopy.actioncable.ActionCableException;
import com.hosopy.actioncable.Command;
import com.hosopy.actioncable.Connection;
import com.hosopy.actioncable.ConnectionMonitor;
import com.hosopy.actioncable.Message;
import com.hosopy.actioncable.Subscriptions;
import java.net.URI;

public class Consumer {
    private Connection connection;
    private ConnectionMonitor connectionMonitor;
    private Subscriptions subscriptions = new Subscriptions(this);

    Consumer(URI uri, Options options) {
        this.connection = new Connection(uri, options);
        this.connectionMonitor = new ConnectionMonitor(this.connection, options);
        this.connection.setListener(new Connection.Listener(){

            @Override
            public void onOpen() {
                Consumer.this.connectionMonitor.recordConnect();
                Consumer.this.subscriptions.reload();
            }

            @Override
            public void onFailure(Exception e) {
                Consumer.this.subscriptions.notifyFailed(new ActionCableException(e));
            }

            @Override
            public void onMessage(String string) {
                Message message = Message.fromJson(string);
                if (message.isPing()) {
                    Consumer.this.connectionMonitor.recordPing();
                } else if (message.isConfirmation()) {
                    Consumer.this.subscriptions.notifyConnected(message.getIdentifier());
                } else if (message.isRejection()) {
                    Consumer.this.subscriptions.reject(message.getIdentifier());
                } else {
                    Consumer.this.subscriptions.notifyReceived(message.getIdentifier(), message.getMessage());
                }
            }

            @Override
            public void onClose() {
                Consumer.this.subscriptions.notifyDisconnected();
                Consumer.this.connectionMonitor.recordDisconnect();
            }
        });
    }

    Consumer(URI uri) {
        this(uri, new Options());
    }

    public Subscriptions getSubscriptions() {
        return this.subscriptions;
    }

    public void connect() {
        this.connection.open();
        this.connectionMonitor.start();
    }

    public void disconnect() {
        this.connection.close();
        this.connectionMonitor.stop();
    }

    boolean send(Command command) {
        return this.connection.send(command.toJson());
    }

    Connection getConnection() {
        return this.connection;
    }

    public static class Options
    extends Connection.Options {
    }
}

