/*
 * Decompiled with CFR 0.152.
 */
package com.github.hervian.lambdas.util;

import com.github.hervian.lambdas.util.CombinatoricsUtil;
import com.github.hervian.lambdas.util.GenerateLambda;
import com.github.hervian.lambdas.util.MethodParameter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class GenerateLambdaProcessor
extends AbstractProcessor {
    private static final String END_OF_SIGNATURE = ");";
    private static final String NEWLINE_TAB = "\n\t";
    private static final String NEWLINE = "\n";
    private static final String INTERFACE_NAME = "Lambda";
    private static final String PACKAGE = "com.github.hervian.lambdas";
    static final String METHOD_NAME = "invoke_for_";
    private static final String METHOD_NAME_BOOLEAN = "invoke_for_" + Boolean.TYPE.getSimpleName();
    private static final String METHOD_NAME_CHAR = "invoke_for_" + Character.TYPE.getSimpleName();
    private static final String METHOD_NAME_BYTE = "invoke_for_" + Byte.TYPE.getSimpleName();
    private static final String METHOD_NAME_SHORT = "invoke_for_" + Short.TYPE.getSimpleName();
    private static final String METHOD_NAME_INT = "invoke_for_" + Integer.TYPE.getSimpleName();
    private static final String METHOD_NAME_FLOAT = "invoke_for_" + Float.TYPE.getSimpleName();
    private static final String METHOD_NAME_LONG = "invoke_for_" + Long.TYPE.getSimpleName();
    private static final String METHOD_NAME_DOUBLE = "invoke_for_" + Double.TYPE.getSimpleName();
    private static final String METHOD_NAME_OBJECT = "invoke_for_" + Object.class.getSimpleName();
    private static final String METHOD_NAME_VOID = "invoke_for_" + Void.TYPE.getSimpleName();
    private static final String METHOD_NAME_PART_BOOLEAN = " " + METHOD_NAME_BOOLEAN + "(";
    private static final String METHOD_NAME_PART_CHAR = " " + METHOD_NAME_CHAR + "(";
    private static final String METHOD_NAME_PART_BYTE = " " + METHOD_NAME_BYTE + "(";
    private static final String METHOD_NAME_PART_SHORT = " " + METHOD_NAME_SHORT + "(";
    private static final String METHOD_NAME_PART_INT = " " + METHOD_NAME_INT + "(";
    private static final String METHOD_NAME_PART_FLOAT = " " + METHOD_NAME_FLOAT + "(";
    private static final String METHOD_NAME_PART_LONG = " " + METHOD_NAME_LONG + "(";
    private static final String METHOD_NAME_PART_DOUBLE = " " + METHOD_NAME_DOUBLE + "(";
    private static final String METHOD_NAME_PART_OBJECT = " " + METHOD_NAME_OBJECT + "(";
    private static final String METHOD_NAME_PART_VOID = " " + METHOD_NAME_VOID + "(";
    private Filer filer;
    private static boolean fileCreated;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotataions = new LinkedHashSet<String>();
        annotataions.add(GenerateLambda.class.getCanonicalName());
        return annotataions;
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Element element;
        Set<? extends Element> elements;
        Iterator<? extends Element> iterator;
        if (!roundEnv.processingOver() && !fileCreated && (iterator = (elements = roundEnv.getElementsAnnotatedWith(GenerateLambda.class)).iterator()).hasNext() && (element = iterator.next()).getKind() == ElementKind.CLASS) {
            GenerateLambda generateSignatureContainerAnnotation = element.getAnnotation(GenerateLambda.class);
            this.generateCode(PACKAGE, INTERFACE_NAME, generateSignatureContainerAnnotation);
            return true;
        }
        return true;
    }

    private void generateCode(String packageOfMarkerClass, String className, GenerateLambda generateSignatureContainerAnnotation) {
        String fqcn = packageOfMarkerClass + "." + className;
        try (Writer writer = this.filer.createSourceFile(fqcn, new Element[0]).openWriter();){
            StringBuilder javaFile = new StringBuilder();
            javaFile.append("package ").append(packageOfMarkerClass).append(";");
            javaFile.append("\n\n/**\n * Copyright 2016 Anders Granau H\u00f8fft\n * The invocation methods throws an AbstractMethodError, if arguments provided does not match \n * the type defined by the Method over which the lambda was created.\n * A typical example of this is that the caller forget to cast a primitive number to its proper type. \n * Fx. forgetting to explicitly cast a number as a short, byte etc. \n * The AbstractMethodException will also be thrown if the caller does not provide\n * an Object instance as the first argument to a non-static method, and vice versa.\n * @author Anders Granau H\u00f8fft").append("\n */").append("\n@javax.annotation.processing.Generated(value=\"com.github.hervian.lambdas.util.GenerateLambdaProcessor\", date=\"").append(new Date()).append("\")").append("\npublic interface " + className + "{\n");
            this.generateAbstractandConcreteMethods(javaFile, generateSignatureContainerAnnotation);
            javaFile.append("\n}");
            writer.write(javaFile.toString());
            fileCreated = true;
        }
        catch (IOException e) {
            throw new RuntimeException("An exception occurred while generating the source file invoke_for_", e);
        }
    }

    private void generateAbstractandConcreteMethods(StringBuilder javaFile, GenerateLambda generateSignatureContainerAnnotation) {
        MethodParameter[] types = generateSignatureContainerAnnotation.paramTypes();
        int maxNumberOfParams = generateSignatureContainerAnnotation.maxNumberOfParameters();
        this.generateAbstractMethods(javaFile, types, maxNumberOfParams);
    }

    private void generateAbstractMethods(StringBuilder javaFile, MethodParameter[] types, int maxNumberOfParams) {
        List<MethodParameter> typesList = Arrays.asList(types);
        List<String> returnTypes = typesList.stream().map(type -> type.getTypeAsSourceCodeString()).collect(Collectors.toList());
        returnTypes.add("void");
        this.generateInterfaceMethodsForStaticCallsWithMaxNumOfArgs(javaFile, typesList, returnTypes, maxNumberOfParams + 1);
        this.generateInterfaceMethodCombinationsRecursively(javaFile, typesList, returnTypes, maxNumberOfParams);
    }

    private void generateInterfaceMethodsForStaticCallsWithMaxNumOfArgs(StringBuilder javaFile, List<MethodParameter> types, List<String> returnTypes, int numberOfParams) {
        List<List<MethodParameter>> permutations = CombinatoricsUtil.createPermutationsWithRepetitionsRecursively(types, numberOfParams);
        for (String returnTypeAsString : returnTypes) {
            for (List<MethodParameter> paramTypes : permutations) {
                if (paramTypes.get(0) != MethodParameter.OBJECT) continue;
                String parameters = this.getParametersString(paramTypes, javaFile);
                javaFile.append(NEWLINE_TAB).append(returnTypeAsString).append(GenerateLambdaProcessor.getSignatureExclArgsAndReturn(returnTypeAsString)).append(parameters).append(END_OF_SIGNATURE);
            }
        }
    }

    private void generateInterfaceMethodCombinationsRecursively(StringBuilder javaFile, List<MethodParameter> types, List<String> returnTypes, int numberOfParams) {
        if (numberOfParams >= 0) {
            javaFile.append(NEWLINE);
            List<List<MethodParameter>> permutations = CombinatoricsUtil.createPermutationsWithRepetitionsRecursively(types, numberOfParams);
            for (String returnTypeAsString : returnTypes) {
                this.generateInterfaceMethods(permutations, returnTypeAsString, javaFile);
            }
            this.generateInterfaceMethodCombinationsRecursively(javaFile, types, returnTypes, --numberOfParams);
        }
    }

    private void generateInterfaceMethods(List<List<MethodParameter>> permutations, String returnTypeAsString, StringBuilder javaFile) {
        javaFile.append(NEWLINE);
        for (List<MethodParameter> paramTypes : permutations) {
            String parameters = this.getParametersString(paramTypes, javaFile);
            javaFile.append(NEWLINE_TAB).append(returnTypeAsString).append(GenerateLambdaProcessor.getSignatureExclArgsAndReturn(returnTypeAsString)).append(parameters).append(END_OF_SIGNATURE);
        }
    }

    private String getParametersString(List<MethodParameter> paramTypes, StringBuilder javaFile) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return paramTypes.stream().map(t -> t.getTypeAsSourceCodeString() + " arg" + atomicInteger.getAndIncrement()).collect(Collectors.joining(", "));
    }

    private static String getSignatureExclArgsAndReturn(String returnType) {
        switch (returnType) {
            case "boolean": {
                return METHOD_NAME_PART_BOOLEAN;
            }
            case "byte": {
                return METHOD_NAME_PART_BYTE;
            }
            case "char": {
                return METHOD_NAME_PART_CHAR;
            }
            case "double": {
                return METHOD_NAME_PART_DOUBLE;
            }
            case "float": {
                return METHOD_NAME_PART_FLOAT;
            }
            case "int": {
                return METHOD_NAME_PART_INT;
            }
            case "long": {
                return METHOD_NAME_PART_LONG;
            }
            case "Object": {
                return METHOD_NAME_PART_OBJECT;
            }
            case "short": {
                return METHOD_NAME_PART_SHORT;
            }
            case "void": {
                return METHOD_NAME_PART_VOID;
            }
        }
        return METHOD_NAME_PART_OBJECT;
    }

    public static String getMethodName(String returnType) {
        switch (returnType) {
            case "boolean": {
                return METHOD_NAME_BOOLEAN;
            }
            case "byte": {
                return METHOD_NAME_BYTE;
            }
            case "char": {
                return METHOD_NAME_CHAR;
            }
            case "double": {
                return METHOD_NAME_DOUBLE;
            }
            case "float": {
                return METHOD_NAME_FLOAT;
            }
            case "int": {
                return METHOD_NAME_INT;
            }
            case "long": {
                return METHOD_NAME_LONG;
            }
            case "Object": {
                return METHOD_NAME_OBJECT;
            }
            case "short": {
                return METHOD_NAME_SHORT;
            }
            case "void": {
                return METHOD_NAME_VOID;
            }
        }
        return METHOD_NAME_OBJECT;
    }
}

