/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.ext.util;

import android.app.Activity;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.hgj.jetpackmvvm.core.JetpackMvvmKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0006\u0010\u000f\u001a\u00020\u0003\u001a\u0006\u0010\u0010\u001a\u00020\u0003\u001a\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u0006\u0010\u0012\u001a\u00020\u0003\u001a\u0006\u0010\u0013\u001a\u00020\u0003\u001a\u0006\u0010\u0014\u001a\u00020\u0003\u001a\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0006\u0010\u0019\u001a\u00020\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\u0005\u001a\u00020\u0003*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u001a"}, d2={"getDisplayMetrics", "", "dp2px", "", "dpValue", "dp", "getDp", "(F)F", "(I)I", "px2dp", "pxValue", "sp2px", "spVal", "px2sp", "pxVal", "getScreenWidth", "getScreenHeight", "getScreenWidth2", "getScreenHeight2", "getAllScreenHeight", "getStatusBarHeight", "getStatusBarHeight2", "activity", "Landroid/app/Activity;", "getTitleBarHeight", "getBottomBarHeight", "JetpackMvvm_release"})
public final class DensityExtKt {
    public static final float getDisplayMetrics() {
        return JetpackMvvmKt.getAppContext().getResources().getDisplayMetrics().density;
    }

    public static final int dp2px(float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)JetpackMvvmKt.getAppContext().getResources().getDisplayMetrics());
    }

    public static final float getDp(float $this$dp) {
        return TypedValue.applyDimension((int)1, (float)$this$dp, (DisplayMetrics)JetpackMvvmKt.getAppContext().getResources().getDisplayMetrics());
    }

    public static final int getDp(int $this$dp) {
        return (int)TypedValue.applyDimension((int)1, (float)$this$dp, (DisplayMetrics)JetpackMvvmKt.getAppContext().getResources().getDisplayMetrics());
    }

    public static final int px2dp(float pxValue) {
        return (int)(pxValue / DensityExtKt.getDisplayMetrics() + 0.5f);
    }

    public static final int sp2px(float spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)JetpackMvvmKt.getAppContext().getResources().getDisplayMetrics());
    }

    public static final float px2sp(float pxVal) {
        return pxVal / JetpackMvvmKt.getAppContext().getResources().getDisplayMetrics().scaledDensity;
    }

    public static final int getScreenWidth() {
        DisplayMetrics metric = new DisplayMetrics();
        Object object = JetpackMvvmKt.getAppContext().getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        ((WindowManager)object).getDefaultDisplay().getMetrics(metric);
        return metric.widthPixels;
    }

    public static final int getScreenHeight() {
        DisplayMetrics metric = new DisplayMetrics();
        Object object = JetpackMvvmKt.getAppContext().getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        ((WindowManager)object).getDefaultDisplay().getMetrics(metric);
        return metric.heightPixels;
    }

    public static final int getScreenWidth2() {
        Point point = new Point();
        Object object = JetpackMvvmKt.getAppContext().getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        ((WindowManager)object).getDefaultDisplay().getSize(point);
        return point.x;
    }

    public static final int getScreenHeight2() {
        Point point = new Point();
        Object object = JetpackMvvmKt.getAppContext().getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        ((WindowManager)object).getDefaultDisplay().getSize(point);
        return point.y;
    }

    public static final int getAllScreenHeight() {
        Object object = JetpackMvvmKt.getAppContext().getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        Display display = ((WindowManager)object).getDefaultDisplay();
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            Object[] objectArray = new Class[]{DisplayMetrics.class};
            Method method = Class.forName("android.view.Display").getMethod("getRealMetrics", (Class<?>[])objectArray);
            objectArray = new Object[]{displayMetrics};
            method.invoke((Object)display, objectArray);
            return displayMetrics.heightPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static final int getStatusBarHeight() {
        int height = 0;
        int resourceId = JetpackMvvmKt.getAppContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = JetpackMvvmKt.getAppContext().getResources().getDimensionPixelSize(resourceId);
        }
        return height;
    }

    public static final int getStatusBarHeight2(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        return rect.top;
    }

    public static final int getTitleBarHeight(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        int contentTop = activity.getWindow().findViewById(0x1020002).getTop();
        return contentTop - DensityExtKt.getStatusBarHeight();
    }

    public static final int getBottomBarHeight() {
        return DensityExtKt.getAllScreenHeight() - DensityExtKt.getScreenHeight();
    }
}

