/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.core.net.interception.logging.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lme/hgj/jetpackmvvm/core/net/interception/logging/util/ZipHelper;", "", "<init>", "()V", "Companion", "JetpackMvvm_release"})
public final class ZipHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ZipHelper() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String decompressToStringForZlib(@NotNull byte[] bytesToDecompress, @NotNull String charsetName) {
        return Companion.decompressToStringForZlib(bytesToDecompress, charsetName);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String decompressForGzip(@NotNull byte[] compressed, @Nullable String charsetName) {
        return Companion.decompressForGzip(compressed, charsetName);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String decompressToStringForZlib(@NotNull byte[] bytesToDecompress) {
        return Companion.decompressToStringForZlib(bytesToDecompress);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final String decompressForGzip(@NotNull byte[] compressed) {
        return Companion.decompressForGzip(compressed);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u0007J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0005J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lme/hgj/jetpackmvvm/core/net/interception/logging/util/ZipHelper$Companion;", "", "<init>", "()V", "decompressToStringForZlib", "", "bytesToDecompress", "", "charsetName", "decompressForZlib", "compressForZlib", "bytesToCompress", "stringToCompress", "compressForGzip", "string", "decompressForGzip", "compressed", "closeQuietly", "", "closeable", "Ljava/io/Closeable;", "JetpackMvvm_release"})
    @SourceDebugExtension(value={"SMAP\nZipHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipHelper.kt\nme/hgj/jetpackmvvm/core/net/interception/logging/util/ZipHelper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1#2:192\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final String decompressToStringForZlib(@NotNull byte[] bytesToDecompress, @NotNull String charsetName) {
            Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
            Intrinsics.checkNotNullParameter((Object)charsetName, (String)"charsetName");
            byte[] bytesDecompressed = this.decompressForZlib(bytesToDecompress);
            String returnValue = null;
            try {
                int n = 0;
                int n2 = bytesDecompressed.length;
                Charset charset = Charset.forName(charsetName);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                Charset charset2 = charset;
                returnValue = new String(bytesDecompressed, n, n2, charset2);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
            return returnValue;
        }

        public static /* synthetic */ String decompressToStringForZlib$default(Companion companion, byte[] byArray, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "UTF-8";
            }
            return companion.decompressToStringForZlib(byArray, string2);
        }

        @NotNull
        public final byte[] decompressForZlib(@NotNull byte[] bytesToDecompress) {
            Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
            byte[] returnValues = new byte[]{};
            Inflater inflater = new Inflater();
            int numberOfBytesToDecompress = bytesToDecompress.length;
            inflater.setInput(bytesToDecompress, 0, numberOfBytesToDecompress);
            int numberOfBytesDecompressedSoFar = 0;
            List bytesDecompressedSoFar = new ArrayList();
            try {
                while (!inflater.needsInput()) {
                    byte[] bytesDecompressedBuffer = new byte[numberOfBytesToDecompress];
                    int numberOfBytesDecompressedThisTime = inflater.inflate(bytesDecompressedBuffer);
                    numberOfBytesDecompressedSoFar += numberOfBytesDecompressedThisTime;
                    for (int b = 0; b < numberOfBytesDecompressedThisTime; ++b) {
                        bytesDecompressedSoFar.add(bytesDecompressedBuffer[b]);
                    }
                }
                returnValues = new byte[bytesDecompressedSoFar.size()];
                int n = returnValues.length;
                for (int b = 0; b < n; ++b) {
                    returnValues[b] = ((Number)bytesDecompressedSoFar.get(b)).byteValue();
                }
            }
            catch (DataFormatException dfe) {
                dfe.printStackTrace();
            }
            inflater.end();
            return returnValues;
        }

        @NotNull
        public final byte[] compressForZlib(@Nullable byte[] bytesToCompress) {
            Deflater deflater = new Deflater();
            deflater.setInput(bytesToCompress);
            deflater.finish();
            byte[] bytesCompressed = new byte[Short.MAX_VALUE];
            int numberOfBytesAfterCompression = deflater.deflate(bytesCompressed);
            byte[] returnValues = new byte[numberOfBytesAfterCompression];
            System.arraycopy(bytesCompressed, 0, returnValues, 0, numberOfBytesAfterCompression);
            return returnValues;
        }

        @Nullable
        public final byte[] compressForZlib(@NotNull String stringToCompress) {
            Intrinsics.checkNotNullParameter((Object)stringToCompress, (String)"stringToCompress");
            byte[] returnValues = null;
            try {
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                byte[] byArray = stringToCompress.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                returnValues = this.compressForZlib(byArray);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
            return returnValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final byte[] compressForGzip(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
            ByteArrayOutputStream os = null;
            GZIPOutputStream gos = null;
            try {
                os = new ByteArrayOutputStream(string2.length());
                gos = new GZIPOutputStream(os);
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                gos.write(byArray);
                byte[] byArray2 = os.toByteArray();
                return byArray2;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.closeQuietly(gos);
                this.closeQuietly(os);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @JvmOverloads
        @Nullable
        public final String decompressForGzip(@NotNull byte[] compressed, @Nullable String charsetName) {
            Intrinsics.checkNotNullParameter((Object)compressed, (String)"compressed");
            int BUFFER_SIZE = compressed.length;
            GZIPInputStream gis = null;
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(compressed);
                gis = new GZIPInputStream((InputStream)is, BUFFER_SIZE);
                StringBuilder string2 = new StringBuilder();
                byte[] data = new byte[BUFFER_SIZE];
                Ref.IntRef bytesRead = new Ref.IntRef();
                while (true) {
                    Charset charset;
                    int n;
                    int it = n = gis.read(data);
                    boolean bl = false;
                    bytesRead.element = it;
                    if (n == -1) break;
                    n = 0;
                    int n2 = bytesRead.element;
                    Intrinsics.checkNotNullExpressionValue((Object)Charset.forName(charsetName), (String)"forName(...)");
                    string2.append(new String(data, n, n2, charset));
                }
                String string3 = string2.toString();
                return string3;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.closeQuietly(gis);
                this.closeQuietly(is);
            }
            return null;
        }

        public static /* synthetic */ String decompressForGzip$default(Companion companion, byte[] byArray, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "UTF-8";
            }
            return companion.decompressForGzip(byArray, string2);
        }

        private final void closeQuietly(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (RuntimeException rethrown) {
                    throw rethrown;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final String decompressToStringForZlib(@NotNull byte[] bytesToDecompress) {
            Intrinsics.checkNotNullParameter((Object)bytesToDecompress, (String)"bytesToDecompress");
            return me.hgj.jetpackmvvm.core.net.interception.logging.util.ZipHelper$Companion.decompressToStringForZlib$default(this, bytesToDecompress, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final String decompressForGzip(@NotNull byte[] compressed) {
            Intrinsics.checkNotNullParameter((Object)compressed, (String)"compressed");
            return me.hgj.jetpackmvvm.core.net.interception.logging.util.ZipHelper$Companion.decompressForGzip$default(this, compressed, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

