/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.network.interceptor.logging;

import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.hgj.jetpackmvvm.network.interceptor.logging.DefaultFormatPrinter;
import me.hgj.jetpackmvvm.network.interceptor.logging.FormatPrinter;
import me.hgj.jetpackmvvm.util.CharacterHandler;
import me.hgj.jetpackmvvm.util.UrlEncoderUtils;
import me.hgj.jetpackmvvm.util.ZipHelper;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/hgj/jetpackmvvm/network/interceptor/logging/LogInterceptor;", "Lokhttp3/Interceptor;", "()V", "printLevel", "Lme/hgj/jetpackmvvm/network/interceptor/logging/LogInterceptor$Level;", "(Lme/hgj/jetpackmvvm/network/interceptor/logging/LogInterceptor$Level;)V", "mPrinter", "Lme/hgj/jetpackmvvm/network/interceptor/logging/FormatPrinter;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "parseContent", "", "responseBody", "Lokhttp3/ResponseBody;", "encoding", "clone", "Lokio/Buffer;", "printResult", "request", "Lokhttp3/Request;", "response", "logResponse", "", "Companion", "Level", "JetpackMvvm_debug"})
public final class LogInterceptor
implements Interceptor {
    private final FormatPrinter mPrinter = new DefaultFormatPrinter();
    private final Level printLevel = Level.ALL;
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            request = chain.request();
            v0 = logRequest = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.REQUEST;
            if (!logRequest) break block12;
            if (request.body() == null) ** GOTO lbl-1000
            v1 = request.body();
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            if (LogInterceptor.Companion.isParseable(v1.contentType())) {
                v2 = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"request");
                this.mPrinter.printJsonRequest(v2, LogInterceptor.Companion.parseParams(request));
            } else lbl-1000:
            // 2 sources

            {
                v3 = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"request");
                this.mPrinter.printFileRequest(v3);
            }
        }
        logResponse = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.RESPONSE;
        t1 = logResponse != false ? System.nanoTime() : 0L;
        originalResponse = null;
        try {
            v4 = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"chain.proceed(request)");
            var8_7 = v4;
        }
        catch (Exception e) {
            Log.d((String)"Http Error: %s", (String)e.getMessage());
            throw (Throwable)e;
        }
        originalResponse = var8_7;
        t2 = logResponse != false ? System.nanoTime() : 0L;
        responseBody = originalResponse.body();
        bodyString = null;
        if (responseBody != null && LogInterceptor.Companion.isParseable(responseBody.contentType())) {
            v5 = request;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"request");
            bodyString = this.printResult(v5, originalResponse, logResponse);
        }
        if (logResponse) {
            segmentList = request.url().encodedPathSegments();
            if (originalResponse.networkResponse() == null) {
                v6 = originalResponse.headers().toString();
                v7 = v6;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"originalResponse.headers().toString()");
            } else {
                v8 = originalResponse.networkResponse();
                if (v8 == null) {
                    Intrinsics.throwNpe();
                }
                v9 = v8.request().headers().toString();
                v7 = v9;
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"originalResponse.network\u2026st().headers().toString()");
            }
            header = v7;
            code = originalResponse.code();
            isSuccessful = originalResponse.isSuccessful();
            message = originalResponse.message();
            v10 = originalResponse.request().url().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"originalResponse.request().url().toString()");
            url = v10;
            if (responseBody != null && LogInterceptor.Companion.isParseable(responseBody.contentType())) {
                v11 = TimeUnit.NANOSECONDS.toMillis(t2 - t1);
                v12 = responseBody.contentType();
                v13 = segmentList;
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"segmentList");
                v14 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"message");
                this.mPrinter.printJsonResponse(v11, isSuccessful, code, header, v12, bodyString, v13, v14, url);
            } else {
                v15 = TimeUnit.NANOSECONDS.toMillis(t2 - t1);
                v16 = segmentList;
                Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"segmentList");
                v17 = message;
                Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"message");
                this.mPrinter.printFileResponse(v15, isSuccessful, code, header, v16, v17, url);
            }
        }
        return originalResponse;
    }

    private final String printResult(Request request2, Response response, boolean logResponse) throws IOException {
        String string;
        try {
            ResponseBody responseBody;
            ResponseBody responseBody2 = responseBody = response.newBuilder().build().body();
            if (responseBody2 == null) {
                Intrinsics.throwNpe();
            }
            BufferedSource source = responseBody2.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            String encoding = response.headers().get("Content-Encoding");
            Buffer buffer2 = buffer.clone();
            Intrinsics.checkExpressionValueIsNotNull((Object)buffer2, (String)"buffer.clone()");
            Buffer clone = buffer2;
            string = this.parseContent(responseBody, encoding, clone);
        }
        catch (IOException e) {
            e.printStackTrace();
            string = "{\"error\": \"" + e.getMessage() + "\"}";
        }
        return string;
    }

    private final String parseContent(ResponseBody responseBody, String encoding, Buffer clone) {
        String string;
        MediaType contentType;
        Charset charset = Charset.forName("UTF-8");
        ResponseBody responseBody2 = responseBody;
        if (responseBody2 == null) {
            Intrinsics.throwNpe();
        }
        if ((contentType = responseBody2.contentType()) != null) {
            charset = contentType.charset(charset);
        }
        if (StringsKt.equals((String)"gzip", (String)encoding, (boolean)true)) {
            byte[] byArray = clone.readByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"clone.readByteArray()");
            string = ZipHelper.Companion.decompressForGzip(byArray, Companion.convertCharset(charset));
        } else if (StringsKt.equals((String)"zlib", (String)encoding, (boolean)true)) {
            byte[] byArray = clone.readByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"clone.readByteArray()");
            string = ZipHelper.Companion.decompressToStringForZlib(byArray, Companion.convertCharset(charset));
        } else {
            string = clone.readString(charset);
        }
        return string;
    }

    public LogInterceptor() {
    }

    public LogInterceptor(@Nullable Level printLevel) {
    }

    @JvmStatic
    public static final boolean isJson(@Nullable MediaType mediaType) {
        return Companion.isJson(mediaType);
    }

    @JvmStatic
    public static final boolean isXml(@Nullable MediaType mediaType) {
        return Companion.isXml(mediaType);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lme/hgj/jetpackmvvm/network/interceptor/logging/LogInterceptor$Level;", "", "(Ljava/lang/String;I)V", "NONE", "REQUEST", "RESPONSE", "ALL", "JetpackMvvm_debug"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level NONE;
        public static final /* enum */ Level REQUEST;
        public static final /* enum */ Level RESPONSE;
        public static final /* enum */ Level ALL;
        private static final /* synthetic */ Level[] $VALUES;

        static {
            Level[] levelArray = new Level[4];
            Level[] levelArray2 = levelArray;
            levelArray[0] = NONE = new Level();
            levelArray[1] = REQUEST = new Level();
            levelArray[2] = RESPONSE = new Level();
            levelArray[3] = ALL = new Level();
            $VALUES = levelArray;
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String string) {
            return Enum.valueOf(Level.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lme/hgj/jetpackmvvm/network/interceptor/logging/LogInterceptor$Companion;", "", "()V", "convertCharset", "", "charset", "Ljava/nio/charset/Charset;", "isForm", "", "mediaType", "Lokhttp3/MediaType;", "isHtml", "isJson", "isParseable", "isPlain", "isText", "isXml", "parseParams", "request", "Lokhttp3/Request;", "JetpackMvvm_debug"})
    public static final class Companion {
        @NotNull
        public final String parseParams(@NotNull Request request2) throws UnsupportedEncodingException {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
            try {
                String json;
                RequestBody requestBody = request2.newBuilder().build().body();
                if (requestBody == null) {
                    return "";
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)requestBody, (String)"request.newBuilder().build().body() ?: return \"\"");
                RequestBody body = requestBody;
                Buffer requestbuffer = new Buffer();
                body.writeTo((BufferedSink)requestbuffer);
                Charset charset = Charset.forName("UTF-8");
                MediaType contentType = body.contentType();
                if (contentType != null) {
                    charset = contentType.charset(charset);
                }
                String string2 = json = requestbuffer.readString(charset);
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                if (UrlEncoderUtils.Companion.hasUrlEncoded(string2)) {
                    json = URLDecoder.decode(json, this.convertCharset(charset));
                }
                String string3 = json;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                string = CharacterHandler.Companion.jsonFormat(string3);
            }
            catch (IOException e) {
                e.printStackTrace();
                string = "{\"error\": \"" + e.getMessage() + "\"}";
            }
            return string;
        }

        public final boolean isParseable(@Nullable MediaType mediaType) {
            MediaType mediaType2 = mediaType;
            return (mediaType2 != null ? mediaType2.type() : null) == null ? false : this.isText(mediaType) || this.isPlain(mediaType) || this.isJson(mediaType) || this.isForm(mediaType) || this.isHtml(mediaType) || this.isXml(mediaType);
        }

        public final boolean isText(@Nullable MediaType mediaType) {
            MediaType mediaType2 = mediaType;
            return (mediaType2 != null ? mediaType2.type() : null) == null ? false : Intrinsics.areEqual((Object)"text", (Object)mediaType.type());
        }

        public final boolean isPlain(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string = mediaType.subtype();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mediaType.subtype()");
                String string2 = string;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"plain", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @JvmStatic
        public final boolean isJson(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string = mediaType.subtype();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mediaType.subtype()");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
                Locale locale2 = locale;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"json", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @JvmStatic
        public final boolean isXml(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string = mediaType.subtype();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mediaType.subtype()");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
                Locale locale2 = locale;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"xml", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isHtml(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string = mediaType.subtype();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mediaType.subtype()");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
                Locale locale2 = locale;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"html", (boolean)false, (int)2, null);
            }
            return bl;
        }

        public final boolean isForm(@Nullable MediaType mediaType) {
            boolean bl;
            MediaType mediaType2 = mediaType;
            if ((mediaType2 != null ? mediaType2.subtype() : null) == null) {
                bl = false;
            } else {
                String string = mediaType.subtype();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mediaType.subtype()");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
                Locale locale2 = locale;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                bl = StringsKt.contains$default((CharSequence)string4, (CharSequence)"x-www-form-urlencoded", (boolean)false, (int)2, null);
            }
            return bl;
        }

        @NotNull
        public final String convertCharset(@Nullable Charset charset) {
            String string;
            String s = String.valueOf(charset);
            int i = StringsKt.indexOf$default((CharSequence)s, (String)"[", (int)0, (boolean)false, (int)6, null);
            if (i == -1) {
                string = s;
            } else {
                String string2 = s;
                int n = i + 1;
                int n2 = s.length() - 1;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

