/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import com.obsez.android.lib.filechooser.permissions.PermissionsUtil;
import java.util.ArrayList;
import java.util.List;

public class PermissionActivity
extends AppCompatActivity {
    private static final String TAG = PermissionActivity.class.getName();
    @Nullable
    private PermissionsUtil.OnPermissionListener _permissionListener;
    public int _requestCode;
    private List<String> _permissions_granted = new ArrayList<String>();
    private List<String> _permissions_denied = new ArrayList<String>();
    public static final String INTENT_EXTRA_PERMISSIONS = "PERMISSIONS";
    public static final String INTENT_EXTRA_REQUEST_CODE = "REQUEST_CODE";

    private String[] toArray(List<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String[] permissions = intent.getStringArrayExtra(INTENT_EXTRA_PERMISSIONS);
        if (permissions.length == 0) {
            this.finish();
        }
        this._requestCode = intent.getIntExtra(INTENT_EXTRA_REQUEST_CODE, -1);
        if (this._requestCode == -1) {
            this.finish();
        }
        this._permissionListener = PermissionsUtil.getPermissionListener(this._requestCode);
        for (String permission2 : permissions) {
            if (permission2 == null || permission2.isEmpty()) {
                throw new RuntimeException("permission can't be null or empty");
            }
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) {
                this._permissions_granted.add(permission2);
                continue;
            }
            this._permissions_denied.add(permission2);
        }
        if (this._permissions_denied.isEmpty()) {
            if (this._permissions_granted.isEmpty()) {
                throw new RuntimeException("there are no permissions");
            }
            if (this._permissionListener != null) {
                this._permissionListener.onPermissionGranted(this.toArray(this._permissions_granted));
            }
            this.finish();
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])this.toArray(this._permissions_denied), (int)this._requestCode);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != this._requestCode) {
            this.finish();
        }
        this._permissions_denied.clear();
        for (int i = permissions.length - 1; i >= 0; --i) {
            if (grantResults[i] == 0) {
                this._permissions_granted.add(permissions[i]);
                continue;
            }
            this._permissions_denied.add(permissions[i]);
        }
        if (this._permissions_denied.isEmpty()) {
            if (this._permissions_granted.isEmpty()) {
                throw new RuntimeException("there are no permissions");
            }
            if (this._permissionListener != null) {
                this._permissionListener.onPermissionGranted(this.toArray(this._permissions_granted));
            }
            this.finish();
        } else {
            ArrayList<String> permissionsShouldRequest = new ArrayList<String>();
            for (String permission2 : this._permissions_denied) {
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)permission2)) continue;
                permissionsShouldRequest.add(permission2);
            }
            if (this._permissionListener != null) {
                this._permissionListener.onPermissionDenied(this.toArray(this._permissions_denied));
                this._permissionListener.onShouldShowRequestPermissionRationale(this.toArray(permissionsShouldRequest));
            }
            this.finish();
        }
    }
}

