/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk.tasks;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hcaptcha.sdk.HCaptchaError;
import com.hcaptcha.sdk.HCaptchaException;
import com.hcaptcha.sdk.HCaptchaLog;
import com.hcaptcha.sdk.tasks.OnFailureListener;
import com.hcaptcha.sdk.tasks.OnOpenListener;
import com.hcaptcha.sdk.tasks.OnSuccessListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class Task<TResult> {
    private boolean complete;
    private boolean successful;
    private TResult result;
    private HCaptchaException hCaptchaException;
    private final List<OnSuccessListener<TResult>> onSuccessListeners;
    private final List<OnFailureListener> onFailureListeners;
    private final List<OnOpenListener> onOpenListeners;
    protected final Handler handler;

    public Task() {
        Task task = this;
        task.handler = new Handler(Looper.getMainLooper());
        task.onSuccessListeners = new ArrayList<OnSuccessListener<TResult>>();
        task.onFailureListeners = new ArrayList<OnFailureListener>();
        task.onOpenListeners = new ArrayList<OnOpenListener>();
        task.reset();
    }

    private void reset() {
        Task task = this;
        task.complete = false;
        task.successful = false;
        task.result = null;
        task.hCaptchaException = null;
    }

    private void tryCb() {
        Iterator<Object> iterator;
        boolean bl = false;
        if (this.getResult() != null) {
            iterator = this.onSuccessListeners.iterator();
            while (iterator.hasNext()) {
                ((OnSuccessListener)iterator.next()).onSuccess(this.getResult());
                bl = true;
            }
        }
        if (this.getException() != null) {
            iterator = this.onFailureListeners.iterator();
            while (iterator.hasNext()) {
                ((OnFailureListener)iterator.next()).onFailure(this.getException());
                bl = true;
            }
        }
        if (bl) {
            this.reset();
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    @Nullable
    public TResult getResult() {
        return this.result;
    }

    @Nullable
    public HCaptchaException getException() {
        return this.hCaptchaException;
    }

    public void setResult(TResult TResult) {
        this.result = TResult;
        this.successful = true;
        this.complete = true;
        this.tryCb();
    }

    public void setException(@NonNull HCaptchaException hCaptchaException) {
        this.hCaptchaException = hCaptchaException;
        this.successful = false;
        this.complete = true;
        this.tryCb();
    }

    public void captchaOpened() {
        Iterator<OnOpenListener> iterator = ((Task)((Object)iterator)).onOpenListeners.iterator();
        while (iterator.hasNext()) {
            ((OnOpenListener)iterator.next()).onOpen();
        }
    }

    public void scheduleCaptchaExpired(long l) {
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = iterator.Task.this.onFailureListeners.iterator();
                while (iterator.hasNext()) {
                    ((OnFailureListener)iterator.next()).onFailure(new HCaptchaException(HCaptchaError.TOKEN_TIMEOUT));
                }
            }
        }, TimeUnit.SECONDS.toMillis(l));
    }

    public Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<TResult> onSuccessListener) {
        Task task = this;
        task.onSuccessListeners.add(onSuccessListener);
        task.tryCb();
        return task;
    }

    public Task<TResult> removeOnSuccessListener(@NonNull OnSuccessListener<TResult> onSuccessListener) {
        if (!this.onSuccessListeners.remove(onSuccessListener)) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = onSuccessListener;
            HCaptchaLog.d("removeOnSuccessListener: %1 not found and cannot be removed", objectArray2);
        }
        return this;
    }

    public Task<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        Task task = this;
        task.onFailureListeners.add(onFailureListener);
        task.tryCb();
        return task;
    }

    public Task<TResult> removeOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        if (!this.onFailureListeners.remove(onFailureListener)) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = onFailureListener;
            HCaptchaLog.d("removeOnFailureListener: %1 not found and cannot be removed", objectArray2);
        }
        return this;
    }

    public Task<TResult> addOnOpenListener(@NonNull OnOpenListener onOpenListener) {
        Task task = this;
        task.onOpenListeners.add(onOpenListener);
        task.tryCb();
        return task;
    }

    public Task<TResult> removeOnOpenListener(@NonNull OnOpenListener onOpenListener) {
        if (!this.onOpenListeners.remove(onOpenListener)) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = onOpenListener;
            HCaptchaLog.d("removeOnOpenListener: %1 not found and cannot be removed", objectArray2);
        }
        return this;
    }

    public Task<TResult> removeAllListeners() {
        Task task = this;
        task.onSuccessListeners.clear();
        task.onFailureListeners.clear();
        task.onOpenListeners.clear();
        return task;
    }
}

