/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.RequiresApi;
import com.hcaptcha.sdk.HCaptchaConfig;
import com.hcaptcha.sdk.HCaptchaDebugInfo;
import com.hcaptcha.sdk.HCaptchaError;
import com.hcaptcha.sdk.HCaptchaException;
import com.hcaptcha.sdk.HCaptchaInternalConfig;
import com.hcaptcha.sdk.HCaptchaJSInterface;
import com.hcaptcha.sdk.HCaptchaLog;
import com.hcaptcha.sdk.HCaptchaWebView;
import com.hcaptcha.sdk.IHCaptchaHtmlProvider;
import com.hcaptcha.sdk.IHCaptchaVerifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import lombok.Generated;
import lombok.NonNull;

final class HCaptchaWebViewHelper {
    @NonNull
    private final Context context;
    @NonNull
    private final HCaptchaConfig config;
    @NonNull
    private final IHCaptchaVerifier captchaVerifier;
    @NonNull
    private final HCaptchaWebView webView;
    @NonNull
    private final IHCaptchaHtmlProvider htmlProvider;

    public HCaptchaWebViewHelper(@NonNull Handler handler, @NonNull Context context, @NonNull HCaptchaConfig hCaptchaConfig, @NonNull HCaptchaInternalConfig hCaptchaInternalConfig, @NonNull IHCaptchaVerifier iHCaptchaVerifier, @NonNull HCaptchaWebView hCaptchaWebView) {
        if (handler != null) {
            if (context != null) {
                if (hCaptchaConfig != null) {
                    if (hCaptchaInternalConfig != null) {
                        if (iHCaptchaVerifier != null) {
                            if (hCaptchaWebView != null) {
                                this.context = context;
                                this.config = hCaptchaConfig;
                                this.captchaVerifier = iHCaptchaVerifier;
                                this.webView = hCaptchaWebView;
                                this.htmlProvider = hCaptchaInternalConfig.getHtmlProvider();
                                this.setupWebView(handler);
                                return;
                            }
                            throw new NullPointerException("webView is marked non-null but is null");
                        }
                        throw new NullPointerException("captchaVerifier is marked non-null but is null");
                    }
                    throw new NullPointerException("internalConfig is marked non-null but is null");
                }
                throw new NullPointerException("config is marked non-null but is null");
            }
            throw new NullPointerException("context is marked non-null but is null");
        }
        throw new NullPointerException("handler is marked non-null but is null");
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void setupWebView(@NonNull Handler objectArray) {
        if (objectArray != null) {
            HCaptchaDebugInfo hCaptchaDebugInfo;
            HCaptchaJSInterface hCaptchaJSInterface;
            HCaptchaLog.d("WebViewHelper.setupWebView");
            HCaptchaJSInterface hCaptchaJSInterface2 = hCaptchaJSInterface;
            HCaptchaWebViewHelper hCaptchaWebViewHelper = this;
            Serializable serializable = hCaptchaWebViewHelper.config;
            hCaptchaJSInterface = new HCaptchaJSInterface((Handler)objectArray, (HCaptchaConfig)serializable, hCaptchaWebViewHelper.captchaVerifier);
            serializable = hCaptchaDebugInfo;
            hCaptchaDebugInfo = new HCaptchaDebugInfo(this.context);
            WebSettings webSettings = this.webView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setCacheMode(-1);
            webSettings.setGeolocationEnabled(false);
            webSettings.setAllowFileAccess(false);
            webSettings.setAllowContentAccess(false);
            if (Build.VERSION.SDK_INT >= 21) {
                this.webView.setWebViewClient(new HCaptchaWebClient((Handler)objectArray));
            }
            if (HCaptchaLog.sDiagnosticsLogEnabled) {
                this.webView.setWebChromeClient(new HCaptchaWebChromeClient(null));
            }
            HCaptchaWebViewHelper hCaptchaWebViewHelper2 = this;
            hCaptchaWebViewHelper2.webView.setBackgroundColor(0);
            if (hCaptchaWebViewHelper2.config.getDisableHardwareAcceleration().booleanValue()) {
                this.webView.setLayerType(1, null);
            }
            HCaptchaWebViewHelper hCaptchaWebViewHelper3 = this;
            hCaptchaWebViewHelper3.webView.addJavascriptInterface(hCaptchaJSInterface2, "JSInterface");
            hCaptchaWebViewHelper3.webView.addJavascriptInterface(serializable, "JSDI");
            hCaptchaWebViewHelper3.webView.loadDataWithBaseURL(this.config.getHost(), this.htmlProvider.getHtml(), "text/html", "UTF-8", null);
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.webView.isHardwareAccelerated();
            HCaptchaLog.d("WebViewHelper.loadData. Hardware acceleration enabled: %b", objectArray);
            return;
        }
        throw new NullPointerException("handler is marked non-null but is null");
    }

    public void destroy() {
        HCaptchaWebViewHelper hCaptchaWebViewHelper = this;
        HCaptchaLog.d("WebViewHelper.destroy");
        hCaptchaWebViewHelper.webView.removeJavascriptInterface("JSInterface");
        hCaptchaWebViewHelper.webView.removeJavascriptInterface("JSDI");
        ViewParent viewParent = hCaptchaWebViewHelper.webView.getParent();
        if (viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView((View)this.webView);
        } else {
            HCaptchaLog.w("webView.getParent() is null or not a ViewGroup instance");
        }
        this.webView.destroy();
    }

    public void resetAndExecute() {
        this.webView.loadUrl("javascript:resetAndExecute();");
    }

    public void reset() {
        if (this.webView.isDestroyed()) {
            HCaptchaLog.w("WebView is destroyed already");
        } else {
            this.webView.loadUrl("javascript:reset();");
        }
    }

    public boolean shouldRetry(HCaptchaException hCaptchaException) {
        return this.config.getRetryPredicate().shouldRetry(this.config, hCaptchaException);
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HCaptchaConfig getConfig() {
        return this.config;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HCaptchaWebView getWebView() {
        return this.webView;
    }

    @RequiresApi(value=21)
    public class HCaptchaWebClient
    extends WebViewClient {
        @NonNull
        private final Handler handler;

        public HCaptchaWebClient(Handler handler) {
            if (handler != null) {
                this.handler = handler;
                return;
            }
            throw new NullPointerException("handler is marked non-null but is null");
        }

        private String stripUrl(String string) {
            return string.split("[?#]")[0] + "...";
        }

        public WebResourceResponse shouldInterceptRequest(WebView webView, WebResourceRequest webResourceRequest) {
            Uri uri = webResourceRequest.getUrl();
            if (uri != null && uri.getScheme() != null && uri.getScheme().equals("http")) {
                this.handler.post(() -> {
                    HCaptchaWebClient hCaptchaWebClient = this;
                    hCaptchaWebClient.HCaptchaWebViewHelper.this.webView.removeJavascriptInterface("JSInterface");
                    hCaptchaWebClient.HCaptchaWebViewHelper.this.webView.removeJavascriptInterface("JSDI");
                    hCaptchaWebClient.HCaptchaWebViewHelper.this.captchaVerifier.onFailure(new HCaptchaException(HCaptchaError.INSECURE_HTTP_REQUEST_ERROR, "Insecure resource " + uri + " requested"));
                });
            }
            return super.shouldInterceptRequest(webView, webResourceRequest);
        }

        public void onPageStarted(WebView object, String string, Bitmap bitmap) {
            StringBuilder stringBuilder;
            object = stringBuilder;
            object("[webview] onPageStarted ");
            HCaptchaLog.d(stringBuilder.append(this.stripUrl(string)).toString());
        }

        public void onLoadResource(WebView object, String string) {
            StringBuilder stringBuilder;
            object = stringBuilder;
            object("[webview] onLoadResource ");
            HCaptchaLog.d(stringBuilder.append(this.stripUrl(string)).toString());
        }

        public void onPageFinished(WebView object, String string) {
            StringBuilder stringBuilder;
            object = stringBuilder;
            object("[webview] onPageFinished ");
            HCaptchaLog.d(stringBuilder.append(this.stripUrl(string)).toString());
        }

        public void onReceivedError(WebView webView, int n, String string, String string2) {
            super.onReceivedError(webView, n, string, string2);
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray[1] = n;
            HCaptchaLog.d("[webview] onReceivedError \"%s\" (%d)", objectArray2);
        }
    }

    public static class HCaptchaWebChromeClient
    extends WebChromeClient {
        private HCaptchaWebChromeClient() {
        }

        public /* synthetic */ HCaptchaWebChromeClient(1 var1_1) {
            this();
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            HCaptchaLog.d("[webview] onConsoleMessage " + consoleMessage.message());
            return true;
        }

        public void onProgressChanged(WebView webView, int n) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n;
            HCaptchaLog.d("[webview] onProgressChanged %d%%", objectArray2);
        }
    }
}

