/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk;

import androidx.annotation.NonNull;
import java.io.Serializable;

public enum HCaptchaError implements Serializable
{
    NETWORK_ERROR(7, "No internet connection"),
    INVALID_DATA(8, "Invalid data is not accepted by endpoints"),
    CHALLENGE_ERROR(9, "Challenge encountered error on setup"),
    INTERNAL_ERROR(10, "hCaptcha client encountered an internal error"),
    SESSION_TIMEOUT(15, "Session Timeout"),
    TOKEN_TIMEOUT(16, "Token Timeout"),
    CHALLENGE_CLOSED(30, "Challenge Closed"),
    RATE_LIMITED(31, "Rate Limited"),
    INVALID_CUSTOM_THEME(32, "Invalid custom theme"),
    INSECURE_HTTP_REQUEST_ERROR(33, "Insecure resource requested"),
    ERROR(29, "Unknown error");

    private final int errorId;
    private final String message;

    private HCaptchaError(int n2, String string2) {
        this.errorId = n2;
        this.message = string2;
    }

    @NonNull
    public static HCaptchaError fromId(int n) {
        for (HCaptchaError hCaptchaError : HCaptchaError.values()) {
            if (hCaptchaError.errorId != n) continue;
            return hCaptchaError;
        }
        throw new RuntimeException("Unsupported error id: " + n);
    }

    public int getErrorId() {
        return this.errorId;
    }

    public String getMessage() {
        return this.message;
    }

    @NonNull
    public String toString() {
        return this.message;
    }
}

