/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.utils;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import info.appdev.charting.data.BaseEntry;
import info.appdev.charting.data.CandleEntry;
import info.appdev.charting.data.Entry;
import info.appdev.charting.interfaces.datasets.IBubbleDataSet;
import info.appdev.charting.interfaces.datasets.ICandleDataSet;
import info.appdev.charting.interfaces.datasets.ILineDataSet;
import info.appdev.charting.interfaces.datasets.IScatterDataSet;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J.\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)J&\u0010.\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020/2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)J.\u00103\u001a\u00020\u001e2\u0006\u0010$\u001a\u0002042\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00162\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)J.\u0010:\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020;2\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)J\u000e\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020>J\u0016\u0010?\u001a\u00020\u00142\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0AJ\u0010\u0010B\u001a\u00020\u00142\b\u0010C\u001a\u0004\u0018\u00010\u001eJ\u0010\u0010D\u001a\u00020\u00142\b\u0010E\u001a\u0004\u0018\u00010FJ\u0016\u0010G\u001a\u00020\u00142\u0006\u0010E\u001a\u00020F2\u0006\u0010'\u001a\u00020\u0016J\u0016\u0010H\u001a\u00020\u00142\u0006\u0010E\u001a\u00020F2\u0006\u0010'\u001a\u00020\u0016J\u0010\u0010I\u001a\u00020\u00142\b\u0010E\u001a\u0004\u0018\u00010FJ\u0016\u0010I\u001a\u00020\u00142\u0006\u0010E\u001a\u00020F2\u0006\u0010'\u001a\u00020\u0016J\u0016\u0010J\u001a\u00020\u00142\u000e\u0010K\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010F0AJ\u0010\u0010O\u001a\u00020\u00142\b\u0010P\u001a\u0004\u0018\u00010\u001eJ\u0016\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u0016J\u001e\u0010T\u001a\u00020\u00142\u0006\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020UJ\u0016\u0010Y\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010+\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010 \"\u0004\b-\u0010\"R\u001a\u00100\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010 \"\u0004\b2\u0010\"R\u001a\u00107\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010 \"\u0004\b9\u0010\"R\u001a\u0010L\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\r\"\u0004\bN\u0010\u000fR\u001a\u0010Q\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010 \"\u0004\bS\u0010\"R\u000e\u0010Z\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010[\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\rR\u000e\u0010]\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010^\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b_\u0010\r\u00a8\u0006`"}, d2={"Linfo/appdev/charting/utils/Transformer;", "", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/utils/ViewPortHandler;)V", "getViewPortHandler", "()Linfo/appdev/charting/utils/ViewPortHandler;", "setViewPortHandler", "value", "Landroid/graphics/Matrix;", "valueMatrix", "getValueMatrix", "()Landroid/graphics/Matrix;", "setValueMatrix", "(Landroid/graphics/Matrix;)V", "offsetMatrix", "getOffsetMatrix", "setOffsetMatrix", "prepareMatrixValuePx", "", "xChartMin", "", "deltaX", "deltaY", "yChartMin", "prepareMatrixOffset", "inverted", "", "valuePointsForGenerateTransformedValuesScatter", "", "getValuePointsForGenerateTransformedValuesScatter", "()[F", "setValuePointsForGenerateTransformedValuesScatter", "([F)V", "generateTransformedValuesScatter", "data", "Linfo/appdev/charting/interfaces/datasets/IScatterDataSet;", "phaseX", "phaseY", "from", "", "to", "valuePointsForGenerateTransformedValuesBubble", "getValuePointsForGenerateTransformedValuesBubble", "setValuePointsForGenerateTransformedValuesBubble", "generateTransformedValuesBubble", "Linfo/appdev/charting/interfaces/datasets/IBubbleDataSet;", "valuePointsForGenerateTransformedValuesLine", "getValuePointsForGenerateTransformedValuesLine", "setValuePointsForGenerateTransformedValuesLine", "generateTransformedValuesLine", "Linfo/appdev/charting/interfaces/datasets/ILineDataSet;", "min", "max", "valuePointsForGenerateTransformedValuesCandle", "getValuePointsForGenerateTransformedValuesCandle", "setValuePointsForGenerateTransformedValuesCandle", "generateTransformedValuesCandle", "Linfo/appdev/charting/interfaces/datasets/ICandleDataSet;", "pathValueToPixel", "path", "Landroid/graphics/Path;", "pathValuesToPixel", "paths", "", "pointValuesToPixel", "pts", "rectValueToPixel", "r", "Landroid/graphics/RectF;", "rectToPixelPhase", "rectToPixelPhaseHorizontal", "rectValueToPixelHorizontal", "rectValuesToPixel", "rects", "mPixelToValueMatrixBuffer", "getMPixelToValueMatrixBuffer", "setMPixelToValueMatrixBuffer", "pixelsToValue", "pixels", "ptsBuffer", "getPtsBuffer", "setPtsBuffer", "getValuesByTouchPoint", "Linfo/appdev/charting/utils/PointD;", "x", "y", "outputPoint", "getPixelForValues", "mMBuffer1", "valueToPixelMatrix", "getValueToPixelMatrix", "mMBuffer2", "pixelToValueMatrix", "getPixelToValueMatrix", "chartLib_release"})
public class Transformer {
    @NotNull
    private ViewPortHandler viewPortHandler;
    @NotNull
    private Matrix valueMatrix;
    @NotNull
    private Matrix offsetMatrix;
    @NotNull
    private float[] valuePointsForGenerateTransformedValuesScatter;
    @NotNull
    private float[] valuePointsForGenerateTransformedValuesBubble;
    @NotNull
    private float[] valuePointsForGenerateTransformedValuesLine;
    @NotNull
    private float[] valuePointsForGenerateTransformedValuesCandle;
    @NotNull
    private Matrix mPixelToValueMatrixBuffer;
    @NotNull
    private float[] ptsBuffer;
    @NotNull
    private final Matrix mMBuffer1;
    @NotNull
    private final Matrix mMBuffer2;

    public Transformer(@NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        this.viewPortHandler = viewPortHandler;
        this.valueMatrix = new Matrix();
        this.offsetMatrix = new Matrix();
        this.valuePointsForGenerateTransformedValuesScatter = new float[1];
        this.valuePointsForGenerateTransformedValuesBubble = new float[1];
        this.valuePointsForGenerateTransformedValuesLine = new float[1];
        this.valuePointsForGenerateTransformedValuesCandle = new float[1];
        this.mPixelToValueMatrixBuffer = new Matrix();
        this.ptsBuffer = new float[2];
        this.mMBuffer1 = new Matrix();
        this.mMBuffer2 = new Matrix();
    }

    @NotNull
    protected final ViewPortHandler getViewPortHandler() {
        return this.viewPortHandler;
    }

    protected final void setViewPortHandler(@NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"<set-?>");
        this.viewPortHandler = viewPortHandler;
    }

    @NotNull
    public final Matrix getValueMatrix() {
        return this.valueMatrix;
    }

    protected final void setValueMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"<set-?>");
        this.valueMatrix = matrix;
    }

    @NotNull
    public final Matrix getOffsetMatrix() {
        return this.offsetMatrix;
    }

    protected final void setOffsetMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"<set-?>");
        this.offsetMatrix = matrix;
    }

    public final void prepareMatrixValuePx(float xChartMin, float deltaX, float deltaY, float yChartMin) {
        float scaleX = this.viewPortHandler.contentWidth() / deltaX;
        float scaleY = this.viewPortHandler.contentHeight() / deltaY;
        if (Float.isInfinite(scaleX)) {
            scaleX = 0.0f;
        }
        if (Float.isInfinite(scaleY)) {
            scaleY = 0.0f;
        }
        this.valueMatrix.reset();
        this.valueMatrix.postTranslate(-xChartMin, -yChartMin);
        this.valueMatrix.postScale(scaleX, -scaleY);
    }

    public void prepareMatrixOffset(boolean inverted) {
        this.offsetMatrix.reset();
        if (!inverted) {
            v0 = this.offsetMatrix.postTranslate(this.viewPortHandler.offsetLeft(), this.viewPortHandler.getChartHeight() - this.viewPortHandler.offsetBottom());
        } else {
            this.offsetMatrix.setTranslate(this.viewPortHandler.offsetLeft(), -this.viewPortHandler.offsetTop());
            v0 = this.offsetMatrix.postScale(1.0f, -1.0f);
        }
    }

    @NotNull
    protected final float[] getValuePointsForGenerateTransformedValuesScatter() {
        return this.valuePointsForGenerateTransformedValuesScatter;
    }

    protected final void setValuePointsForGenerateTransformedValuesScatter(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.valuePointsForGenerateTransformedValuesScatter = fArray;
    }

    @NotNull
    public final float[] generateTransformedValuesScatter(@NotNull IScatterDataSet data, float phaseX, float phaseY, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int count = (int)((float)(to - from) * phaseX + 1.0f) * 2;
        if (this.valuePointsForGenerateTransformedValuesScatter.length != count) {
            this.valuePointsForGenerateTransformedValuesScatter = new float[count];
        }
        float[] valuePoints = this.valuePointsForGenerateTransformedValuesScatter;
        for (int j = 0; j < count; j += 2) {
            Object e = data.getEntryForIndex(j / 2 + from);
            if (e != null) {
                valuePoints[j] = ((Entry)e).getX();
                valuePoints[j + 1] = ((BaseEntry)e).getY() * phaseY;
                continue;
            }
            valuePoints[j] = 0.0f;
            valuePoints[j + 1] = 0.0f;
        }
        this.getValueToPixelMatrix().mapPoints(valuePoints);
        return valuePoints;
    }

    @NotNull
    protected final float[] getValuePointsForGenerateTransformedValuesBubble() {
        return this.valuePointsForGenerateTransformedValuesBubble;
    }

    protected final void setValuePointsForGenerateTransformedValuesBubble(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.valuePointsForGenerateTransformedValuesBubble = fArray;
    }

    @NotNull
    public final float[] generateTransformedValuesBubble(@NotNull IBubbleDataSet data, float phaseY, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int count = (to - from + 1) * 2;
        if (this.valuePointsForGenerateTransformedValuesBubble.length != count) {
            this.valuePointsForGenerateTransformedValuesBubble = new float[count];
        }
        float[] valuePoints = this.valuePointsForGenerateTransformedValuesBubble;
        for (int j = 0; j < count; j += 2) {
            Object e = data.getEntryForIndex(j / 2 + from);
            if (e != null) {
                valuePoints[j] = ((Entry)e).getX();
                valuePoints[j + 1] = ((BaseEntry)e).getY() * phaseY;
                continue;
            }
            valuePoints[j] = 0.0f;
            valuePoints[j + 1] = 0.0f;
        }
        this.getValueToPixelMatrix().mapPoints(valuePoints);
        return valuePoints;
    }

    @NotNull
    protected final float[] getValuePointsForGenerateTransformedValuesLine() {
        return this.valuePointsForGenerateTransformedValuesLine;
    }

    protected final void setValuePointsForGenerateTransformedValuesLine(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.valuePointsForGenerateTransformedValuesLine = fArray;
    }

    @NotNull
    public final float[] generateTransformedValuesLine(@NotNull ILineDataSet data, float phaseX, float phaseY, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int count = ((int)((float)(max - min) * phaseX) + 1) * 2;
        if (count < 0) {
            count = 0;
        }
        if (this.valuePointsForGenerateTransformedValuesLine.length != count) {
            this.valuePointsForGenerateTransformedValuesLine = new float[count];
        }
        float[] valuePoints = this.valuePointsForGenerateTransformedValuesLine;
        for (int j = 0; j < count; j += 2) {
            Object e = data.getEntryForIndex(j / 2 + min);
            if (e != null) {
                valuePoints[j] = ((Entry)e).getX();
                valuePoints[j + 1] = ((BaseEntry)e).getY() * phaseY;
                continue;
            }
            valuePoints[j] = 0.0f;
            valuePoints[j + 1] = 0.0f;
        }
        this.getValueToPixelMatrix().mapPoints(valuePoints);
        return valuePoints;
    }

    @NotNull
    protected final float[] getValuePointsForGenerateTransformedValuesCandle() {
        return this.valuePointsForGenerateTransformedValuesCandle;
    }

    protected final void setValuePointsForGenerateTransformedValuesCandle(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.valuePointsForGenerateTransformedValuesCandle = fArray;
    }

    @NotNull
    public final float[] generateTransformedValuesCandle(@NotNull ICandleDataSet data, float phaseX, float phaseY, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int count = (int)((float)(to - from) * phaseX + 1.0f) * 2;
        if (this.valuePointsForGenerateTransformedValuesCandle.length != count) {
            this.valuePointsForGenerateTransformedValuesCandle = new float[count];
        }
        float[] valuePoints = this.valuePointsForGenerateTransformedValuesCandle;
        for (int j = 0; j < count; j += 2) {
            CandleEntry e = (CandleEntry)data.getEntryForIndex(j / 2 + from);
            if (e != null) {
                valuePoints[j] = e.getX();
                valuePoints[j + 1] = e.getHigh() * phaseY;
                continue;
            }
            valuePoints[j] = 0.0f;
            valuePoints[j + 1] = 0.0f;
        }
        this.getValueToPixelMatrix().mapPoints(valuePoints);
        return valuePoints;
    }

    public final void pathValueToPixel(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        path.transform(this.valueMatrix);
        path.transform(this.viewPortHandler.getMatrixTouch());
        path.transform(this.offsetMatrix);
    }

    public final void pathValuesToPixel(@NotNull List<Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        int n = ((Collection)paths).size();
        for (int i = 0; i < n; ++i) {
            Path path = paths.get(i);
            Intrinsics.checkNotNull((Object)path);
            this.pathValueToPixel(path);
        }
    }

    public final void pointValuesToPixel(@Nullable float[] pts) {
        this.valueMatrix.mapPoints(pts);
        this.viewPortHandler.getMatrixTouch().mapPoints(pts);
        this.offsetMatrix.mapPoints(pts);
    }

    public final void rectValueToPixel(@Nullable RectF r) {
        this.valueMatrix.mapRect(r);
        this.viewPortHandler.getMatrixTouch().mapRect(r);
        this.offsetMatrix.mapRect(r);
    }

    public final void rectToPixelPhase(@NotNull RectF r, float phaseY) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        r.top *= phaseY;
        r.bottom *= phaseY;
        this.valueMatrix.mapRect(r);
        this.viewPortHandler.getMatrixTouch().mapRect(r);
        this.offsetMatrix.mapRect(r);
    }

    public final void rectToPixelPhaseHorizontal(@NotNull RectF r, float phaseY) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        r.left *= phaseY;
        r.right *= phaseY;
        this.valueMatrix.mapRect(r);
        this.viewPortHandler.getMatrixTouch().mapRect(r);
        this.offsetMatrix.mapRect(r);
    }

    public final void rectValueToPixelHorizontal(@Nullable RectF r) {
        this.valueMatrix.mapRect(r);
        this.viewPortHandler.getMatrixTouch().mapRect(r);
        this.offsetMatrix.mapRect(r);
    }

    public final void rectValueToPixelHorizontal(@NotNull RectF r, float phaseY) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        r.left *= phaseY;
        r.right *= phaseY;
        this.valueMatrix.mapRect(r);
        this.viewPortHandler.getMatrixTouch().mapRect(r);
        this.offsetMatrix.mapRect(r);
    }

    public final void rectValuesToPixel(@NotNull List<RectF> rects) {
        Intrinsics.checkNotNullParameter(rects, (String)"rects");
        Matrix m = this.getValueToPixelMatrix();
        int n = ((Collection)rects).size();
        for (int i = 0; i < n; ++i) {
            m.mapRect(rects.get(i));
        }
    }

    @NotNull
    protected final Matrix getMPixelToValueMatrixBuffer() {
        return this.mPixelToValueMatrixBuffer;
    }

    protected final void setMPixelToValueMatrixBuffer(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"<set-?>");
        this.mPixelToValueMatrixBuffer = matrix;
    }

    public final void pixelsToValue(@Nullable float[] pixels) {
        Matrix tmp = this.mPixelToValueMatrixBuffer;
        tmp.reset();
        this.offsetMatrix.invert(tmp);
        tmp.mapPoints(pixels);
        this.viewPortHandler.getMatrixTouch().invert(tmp);
        tmp.mapPoints(pixels);
        this.valueMatrix.invert(tmp);
        tmp.mapPoints(pixels);
    }

    @NotNull
    public final float[] getPtsBuffer() {
        return this.ptsBuffer;
    }

    public final void setPtsBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.ptsBuffer = fArray;
    }

    @NotNull
    public final PointD getValuesByTouchPoint(float x, float y) {
        PointD result = PointD.Companion.getInstance(0.0, 0.0);
        this.getValuesByTouchPoint(x, y, result);
        return result;
    }

    public final void getValuesByTouchPoint(float x, float y, @NotNull PointD outputPoint) {
        Intrinsics.checkNotNullParameter((Object)outputPoint, (String)"outputPoint");
        this.ptsBuffer[0] = x;
        this.ptsBuffer[1] = y;
        this.pixelsToValue(this.ptsBuffer);
        outputPoint.setX(this.ptsBuffer[0]);
        outputPoint.setY(this.ptsBuffer[1]);
    }

    @NotNull
    public final PointD getPixelForValues(float x, float y) {
        this.ptsBuffer[0] = x;
        this.ptsBuffer[1] = y;
        this.pointValuesToPixel(this.ptsBuffer);
        double xPx = this.ptsBuffer[0];
        double yPx = this.ptsBuffer[1];
        return PointD.Companion.getInstance(xPx, yPx);
    }

    @NotNull
    public final Matrix getValueToPixelMatrix() {
        this.mMBuffer1.set(this.valueMatrix);
        this.mMBuffer1.postConcat(this.viewPortHandler.getMatrixTouch());
        this.mMBuffer1.postConcat(this.offsetMatrix);
        return this.mMBuffer1;
    }

    @NotNull
    public final Matrix getPixelToValueMatrix() {
        this.getValueToPixelMatrix().invert(this.mMBuffer2);
        return this.mMBuffer2;
    }
}

