/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import info.appdev.charting.components.LimitLine;
import info.appdev.charting.components.XAxis;
import info.appdev.charting.formatter.IAxisValueFormatter;
import info.appdev.charting.renderer.AxisRenderer;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.FSize;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PaintUtilsKt;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.Utils;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0004J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0017\u001a\u00020\u000fH\u0014J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J:\u0010 \u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0012H\u0004J\u0010\u00102\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010E\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010F\u001a\u00020'H\u0014J\u001e\u0010G\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020-J\u0010\u0010K\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010L\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020-2\u0006\u0010M\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010&\u001a\u00020'X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00103\u001a\u000204X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0016\u00109\u001a\u0004\u0018\u0001048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00106R\u001a\u0010;\u001a\u00020-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010/\"\u0004\b=\u00101R\u001a\u0010>\u001a\u000204X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00106\"\u0004\b@\u00108R\u001a\u0010A\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010/\"\u0004\bC\u00101R\u000e\u0010D\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Linfo/appdev/charting/renderer/XAxisRenderer;", "Linfo/appdev/charting/renderer/AxisRenderer;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "xAxis", "Linfo/appdev/charting/components/XAxis;", "transformer", "Linfo/appdev/charting/utils/Transformer;", "<init>", "(Linfo/appdev/charting/utils/ViewPortHandler;Linfo/appdev/charting/components/XAxis;Linfo/appdev/charting/utils/Transformer;)V", "getXAxis", "()Linfo/appdev/charting/components/XAxis;", "setXAxis", "(Linfo/appdev/charting/components/XAxis;)V", "setupGridPaint", "", "computeAxis", "min", "", "max", "inverted", "", "computeAxisValues", "computeSize", "renderAxisLabels", "canvas", "Landroid/graphics/Canvas;", "renderAxisLine", "drawLabels", "pos", "anchor", "Linfo/appdev/charting/utils/PointF;", "drawLabel", "formattedLabel", "", "x", "y", "angleDegrees", "renderGridLinesPath", "Landroid/graphics/Path;", "getRenderGridLinesPath", "()Landroid/graphics/Path;", "setRenderGridLinesPath", "(Landroid/graphics/Path;)V", "renderGridLinesBuffer", "", "getRenderGridLinesBuffer", "()[F", "setRenderGridLinesBuffer", "([F)V", "renderGridLines", "mGridClippingRect", "Landroid/graphics/RectF;", "getMGridClippingRect", "()Landroid/graphics/RectF;", "setMGridClippingRect", "(Landroid/graphics/RectF;)V", "gridClippingRect", "getGridClippingRect", "mRenderLimitLinesBuffer", "getMRenderLimitLinesBuffer", "setMRenderLimitLinesBuffer", "mLimitLineClippingRect", "getMLimitLineClippingRect", "setMLimitLineClippingRect", "limitLineSegmentsBuffer", "getLimitLineSegmentsBuffer", "setLimitLineSegmentsBuffer", "mLimitLinePath", "drawGridLine", "gridLinePath", "renderLimitLineLine", "limitLine", "Linfo/appdev/charting/components/LimitLine;", "position", "renderLimitLines", "renderLimitLineLabel", "yOffset", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nXAxisRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XAxisRenderer.kt\ninfo/appdev/charting/renderer/XAxisRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Canvas.kt\nandroidx/core/graphics/CanvasKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,423:1\n1#2:424\n135#3,8:425\n27#3,7:434\n1915#4:433\n1916#4:441\n*S KotlinDebug\n*F\n+ 1 XAxisRenderer.kt\ninfo/appdev/charting/renderer/XAxisRenderer\n*L\n242#1:425,8\n359#1:434,7\n357#1:433\n357#1:441\n*E\n"})
public class XAxisRenderer
extends AxisRenderer {
    @NotNull
    private XAxis xAxis;
    @NotNull
    private Path renderGridLinesPath;
    @NotNull
    private float[] renderGridLinesBuffer;
    @NotNull
    private RectF mGridClippingRect;
    @NotNull
    private float[] mRenderLimitLinesBuffer;
    @NotNull
    private RectF mLimitLineClippingRect;
    @NotNull
    private float[] limitLineSegmentsBuffer;
    @NotNull
    private final Path mLimitLinePath;

    public XAxisRenderer(@NotNull ViewPortHandler viewPortHandler, @NotNull XAxis xAxis, @Nullable Transformer transformer) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"xAxis");
        super(viewPortHandler, transformer, xAxis);
        this.xAxis = xAxis;
        this.renderGridLinesPath = new Path();
        this.renderGridLinesBuffer = new float[2];
        this.mGridClippingRect = new RectF();
        this.mRenderLimitLinesBuffer = new float[2];
        this.mLimitLineClippingRect = new RectF();
        this.limitLineSegmentsBuffer = new float[4];
        this.mLimitLinePath = new Path();
        this.getPaintAxisLabels().setColor(-16777216);
        this.getPaintAxisLabels().setTextAlign(Paint.Align.CENTER);
        this.getPaintAxisLabels().setTextSize(NumberUtilsKt.convertDpToPixel(10.0f));
    }

    @NotNull
    protected final XAxis getXAxis() {
        return this.xAxis;
    }

    protected final void setXAxis(@NotNull XAxis xAxis) {
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"<set-?>");
        this.xAxis = xAxis;
    }

    protected final void setupGridPaint() {
        this.getPaintGrid().setColor(this.xAxis.getGridColor());
        this.getPaintGrid().setStrokeWidth(this.xAxis.getGridLineWidth());
        this.getPaintGrid().setPathEffect((PathEffect)this.xAxis.getGridDashPathEffect());
    }

    @Override
    public void computeAxis(float min, float max, boolean inverted) {
        float minLocal = min;
        float maxLocal = max;
        if (this.getViewPortHandler().contentWidth() > 10.0f && !this.getViewPortHandler().isFullyZoomedOutX()) {
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            PointD p1 = transformer.getValuesByTouchPoint(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentTop());
            Transformer transformer2 = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer2);
            PointD p2 = transformer2.getValuesByTouchPoint(this.getViewPortHandler().contentRight(), this.getViewPortHandler().contentTop());
            if (inverted) {
                minLocal = (float)p2.getX();
                maxLocal = (float)p1.getX();
            } else {
                minLocal = (float)p1.getX();
                maxLocal = (float)p2.getX();
            }
            PointD.Companion.recycleInstance(p1);
            PointD.Companion.recycleInstance(p2);
        }
        this.computeAxisValues(minLocal, maxLocal);
    }

    @Override
    protected void computeAxisValues(float min, float max) {
        super.computeAxisValues(min, max);
        this.computeSize();
    }

    protected void computeSize() {
        String longest = this.xAxis.getLongestLabel();
        this.getPaintAxisLabels().setTypeface(this.xAxis.getTypeface());
        this.getPaintAxisLabels().setTextSize(this.xAxis.getTextSize());
        FSize labelSize = PaintUtilsKt.calcTextSize(this.getPaintAxisLabels(), longest);
        float labelWidth = labelSize.getWidth();
        float labelHeight = PaintUtilsKt.calcTextHeight(this.getPaintAxisLabels(), "Q");
        FSize labelRotatedSize = Utils.INSTANCE.getSizeOfRotatedRectangleByDegrees(labelWidth, labelHeight, this.xAxis.getLabelRotationAngle());
        this.xAxis.setMLabelWidth(MathKt.roundToInt((float)labelRotatedSize.getWidth()));
        this.xAxis.setMLabelHeight(MathKt.roundToInt((float)labelRotatedSize.getHeight()));
        FSize.Companion.recycleInstance(labelRotatedSize);
        FSize.Companion.recycleInstance(labelSize);
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.xAxis.isEnabled() || !this.xAxis.isDrawLabelsEnabled()) {
            return;
        }
        float yOffset = this.xAxis.getYOffset();
        this.getPaintAxisLabels().setColor(this.xAxis.getTextColor());
        PointF pointF = PointF.Companion.getInstance(0.0f, 0.0f);
        XAxis.XAxisPosition xAxisPosition = this.xAxis.getPosition();
        switch (xAxisPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[xAxisPosition.ordinal()]) {
            case 1: {
                pointF.setX(0.5f);
                pointF.setY(1.0f);
                this.drawLabels(canvas, this.getViewPortHandler().contentTop() - yOffset, pointF);
                break;
            }
            case 2: {
                pointF.setX(0.5f);
                pointF.setY(1.0f);
                this.drawLabels(canvas, this.getViewPortHandler().contentTop() + yOffset + (float)this.xAxis.getMLabelHeight(), pointF);
                break;
            }
            case 3: {
                pointF.setX(0.5f);
                pointF.setY(0.0f);
                this.drawLabels(canvas, this.getViewPortHandler().contentBottom() + yOffset, pointF);
                break;
            }
            case 4: {
                pointF.setX(0.5f);
                pointF.setY(0.0f);
                this.drawLabels(canvas, this.getViewPortHandler().contentBottom() - yOffset - (float)this.xAxis.getMLabelHeight(), pointF);
                break;
            }
            default: {
                pointF.setX(0.5f);
                pointF.setY(1.0f);
                this.drawLabels(canvas, this.getViewPortHandler().contentTop() - yOffset, pointF);
                pointF.setX(0.5f);
                pointF.setY(0.0f);
                this.drawLabels(canvas, this.getViewPortHandler().contentBottom() + yOffset, pointF);
            }
        }
        PointF.Companion.recycleInstance(pointF);
    }

    @Override
    public void renderAxisLine(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.xAxis.isDrawAxisLine() || !this.xAxis.isEnabled()) {
            return;
        }
        this.getPaintAxisLine().setColor(this.xAxis.getAxisLineColor());
        this.getPaintAxisLine().setStrokeWidth(this.xAxis.getAxisLineWidth());
        this.getPaintAxisLine().setPathEffect((PathEffect)this.xAxis.getAxisLineDashPathEffect());
        if (this.xAxis.getPosition() == XAxis.XAxisPosition.TOP || this.xAxis.getPosition() == XAxis.XAxisPosition.TOP_INSIDE || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentTop(), this.getViewPortHandler().contentRight(), this.getViewPortHandler().contentTop(), this.getPaintAxisLine());
        }
        if (this.xAxis.getPosition() == XAxis.XAxisPosition.BOTTOM || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTTOM_INSIDE || this.xAxis.getPosition() == XAxis.XAxisPosition.BOTH_SIDED) {
            canvas.drawLine(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentBottom(), this.getViewPortHandler().contentRight(), this.getViewPortHandler().contentBottom(), this.getPaintAxisLine());
        }
    }

    protected void drawLabels(@NotNull Canvas canvas, float pos, @NotNull PointF anchor) {
        int i;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        float labelRotationAngleDegrees = this.xAxis.getLabelRotationAngle();
        boolean centeringEnabled = this.xAxis.isCenterAxisLabelsEnabled();
        float[] positions = null;
        if (this.xAxis.isShowSpecificPositions()) {
            positions = new float[this.xAxis.getSpecificPositions().length * 2];
            for (i = 0; i < positions.length; i += 2) {
                positions[i] = this.xAxis.getSpecificPositions()[i / 2];
            }
        } else {
            positions = new float[this.xAxis.getEntryCount() * 2];
            for (i = 0; i < positions.length; i += 2) {
                positions[i] = centeringEnabled ? this.xAxis.getCenteredEntries()[i / 2] : this.xAxis.getEntries()[i / 2];
            }
        }
        Transformer transformer = this.getTransformer();
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(positions);
        for (i = 0; i < positions.length; i += 2) {
            String label;
            float x = positions[i];
            if (!this.getViewPortHandler().isInBoundsX(x)) continue;
            if (this.xAxis.isShowSpecificPositions()) {
                IAxisValueFormatter iAxisValueFormatter = this.xAxis.getValueFormatter();
                v2 = iAxisValueFormatter != null ? iAxisValueFormatter.getFormattedValue(this.xAxis.getSpecificPositions()[i / 2], this.xAxis) : null;
            } else {
                IAxisValueFormatter iAxisValueFormatter = this.xAxis.getValueFormatter();
                v2 = label = iAxisValueFormatter != null ? iAxisValueFormatter.getFormattedValue(this.xAxis.getEntries()[i / 2], this.xAxis) : null;
            }
            if (this.xAxis.isAvoidFirstLastClipping()) {
                if (i / 2 == this.xAxis.getEntryCount() - 1 && this.xAxis.getEntryCount() > 1) {
                    width = PaintUtilsKt.calcTextWidth(this.getPaintAxisLabels(), label);
                    if (width > this.getViewPortHandler().offsetRight() * (float)2 && x + width > this.getViewPortHandler().getChartWidth()) {
                        x -= width / (float)2;
                    }
                } else if (i == 0) {
                    width = PaintUtilsKt.calcTextWidth(this.getPaintAxisLabels(), label);
                    x += width / (float)2;
                }
            }
            this.drawLabel(canvas, label, x, pos, anchor, labelRotationAngleDegrees);
        }
    }

    protected final void drawLabel(@NotNull Canvas canvas, @Nullable String formattedLabel, float x, float y, @NotNull PointF anchor, float angleDegrees) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            String string = formattedLabel;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            CanvasUtilsKt.drawXAxisValue(canvas, it, x, y, this.getPaintAxisLabels(), anchor, angleDegrees);
        }
    }

    @NotNull
    protected Path getRenderGridLinesPath() {
        return this.renderGridLinesPath;
    }

    protected void setRenderGridLinesPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.renderGridLinesPath = path;
    }

    @NotNull
    protected float[] getRenderGridLinesBuffer() {
        return this.renderGridLinesBuffer;
    }

    protected void setRenderGridLinesBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.renderGridLinesBuffer = fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void renderGridLines(@NotNull Canvas canvas) {
        void $this$withClip$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.xAxis.isDrawGridLines() || !this.xAxis.isEnabled()) {
            return;
        }
        Canvas canvas2 = canvas;
        RectF rectF = this.getGridClippingRect();
        Intrinsics.checkNotNull((Object)rectF);
        RectF clipRect$iv = rectF;
        boolean $i$f$withClip = false;
        int checkpoint$iv = $this$withClip$iv.save();
        $this$withClip$iv.clipRect(clipRect$iv);
        try {
            void $this$renderGridLines_u24lambda_u240 = $this$withClip$iv;
            boolean bl = false;
            if (this.getAxis().isShowSpecificPositions()) {
                if (this.getRenderGridLinesBuffer().length != this.getAxis().getSpecificPositions().length * 2) {
                    this.setRenderGridLinesBuffer(new float[this.xAxis.getSpecificPositions().length * 2]);
                }
            } else if (this.getRenderGridLinesBuffer().length != this.getAxis().getEntryCount() * 2) {
                this.setRenderGridLinesBuffer(new float[this.xAxis.getEntryCount() * 2]);
            }
            float[] positions = this.getRenderGridLinesBuffer();
            void $this$renderGridLines_u24lambda_u240_u240 = $this$renderGridLines_u24lambda_u240;
            boolean bl2 = false;
            for (int i = 0; i < positions.length; i += 2) {
                if (this.getAxis().isShowSpecificPositions()) {
                    positions[i] = this.xAxis.getSpecificPositions()[i / 2];
                    positions[i + 1] = this.xAxis.getSpecificPositions()[i / 2];
                    continue;
                }
                positions[i] = this.xAxis.getEntries()[i / 2];
                positions[i + 1] = this.xAxis.getEntries()[i / 2];
            }
            Transformer transformer = this.getTransformer();
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(positions);
            this.setupGridPaint();
            Path gridLinePath = this.getRenderGridLinesPath();
            gridLinePath.reset();
            for (int i = 0; i < positions.length; i += 2) {
                this.drawGridLine(canvas, positions[i], positions[i + 1], gridLinePath);
            }
        }
        finally {
            $this$withClip$iv.restoreToCount(checkpoint$iv);
        }
    }

    @NotNull
    protected final RectF getMGridClippingRect() {
        return this.mGridClippingRect;
    }

    protected final void setMGridClippingRect(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.mGridClippingRect = rectF;
    }

    @Nullable
    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.getViewPortHandler().getContentRect());
        this.mGridClippingRect.inset(-this.getAxis().getGridLineWidth(), 0.0f);
        return this.mGridClippingRect;
    }

    @NotNull
    protected final float[] getMRenderLimitLinesBuffer() {
        return this.mRenderLimitLinesBuffer;
    }

    protected final void setMRenderLimitLinesBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.mRenderLimitLinesBuffer = fArray;
    }

    @NotNull
    protected final RectF getMLimitLineClippingRect() {
        return this.mLimitLineClippingRect;
    }

    protected final void setMLimitLineClippingRect(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.mLimitLineClippingRect = rectF;
    }

    @NotNull
    public final float[] getLimitLineSegmentsBuffer() {
        return this.limitLineSegmentsBuffer;
    }

    public final void setLimitLineSegmentsBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.limitLineSegmentsBuffer = fArray;
    }

    protected void drawGridLine(@NotNull Canvas canvas, float x, float y, @NotNull Path gridLinePath) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)gridLinePath, (String)"gridLinePath");
        gridLinePath.moveTo(x, this.getViewPortHandler().contentBottom());
        gridLinePath.lineTo(x, this.getViewPortHandler().contentTop());
        canvas.drawPath(gridLinePath, this.getPaintGrid());
        gridLinePath.reset();
    }

    public final void renderLimitLineLine(@NotNull Canvas canvas, @NotNull LimitLine limitLine, @NotNull float[] position) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)limitLine, (String)"limitLine");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.limitLineSegmentsBuffer[0] = position[0];
        this.limitLineSegmentsBuffer[1] = this.getViewPortHandler().contentTop();
        this.limitLineSegmentsBuffer[2] = position[0];
        this.limitLineSegmentsBuffer[3] = this.getViewPortHandler().contentBottom();
        this.mLimitLinePath.reset();
        this.mLimitLinePath.moveTo(this.limitLineSegmentsBuffer[0], this.limitLineSegmentsBuffer[1]);
        this.mLimitLinePath.lineTo(this.limitLineSegmentsBuffer[2], this.limitLineSegmentsBuffer[3]);
        this.getLimitLinePaint().setStyle(Paint.Style.STROKE);
        this.getLimitLinePaint().setColor(limitLine.getLineColor());
        this.getLimitLinePaint().setStrokeWidth(limitLine.getLineWidth());
        this.getLimitLinePaint().setPathEffect((PathEffect)limitLine.getDashPathEffect());
        canvas.drawPath(this.mLimitLinePath, this.getLimitLinePaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        List<LimitLine> limitLines = this.xAxis.getLimitLines();
        if (limitLines.isEmpty()) {
            return;
        }
        float[] position = this.mRenderLimitLinesBuffer;
        position[0] = 0.0f;
        position[1] = 0.0f;
        Iterable $this$forEach$iv = limitLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LimitLine limitLine = (LimitLine)element$iv;
            boolean bl = false;
            if (!limitLine.isEnabled()) continue;
            Canvas $this$withSave$iv = canvas;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$renderLimitLines_u24lambda_u240_u240 = $this$withSave$iv;
                boolean bl2 = false;
                this.mLimitLineClippingRect.set(this.getViewPortHandler().getContentRect());
                this.mLimitLineClippingRect.inset(-limitLine.getLineWidth(), 0.0f);
                canvas.clipRect(this.mLimitLineClippingRect);
                position[0] = limitLine.getLimit();
                position[1] = 0.0f;
                Transformer transformer = this.getTransformer();
                if (transformer != null) {
                    transformer.pointValuesToPixel(position);
                }
                this.renderLimitLineLine(canvas, limitLine, position);
                this.renderLimitLineLabel(canvas, limitLine, position, 2.0f + limitLine.getYOffset());
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        }
    }

    public final void renderLimitLineLabel(@NotNull Canvas canvas, @NotNull LimitLine limitLine, @NotNull float[] position, float yOffset) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            Intrinsics.checkNotNullParameter((Object)limitLine, (String)"limitLine");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            String string = limitLine.getLabel();
            if (string == null) break block6;
            String label = string;
            boolean bl = false;
            if (((CharSequence)label).length() > 0 && limitLine.isEnabled()) {
                LimitLine.LimitLabelPosition labelPosition;
                this.getLimitLinePaint().setStyle(limitLine.getTextStyle());
                this.getLimitLinePaint().setPathEffect(null);
                this.getLimitLinePaint().setColor(limitLine.getTextColor());
                this.getLimitLinePaint().setStrokeWidth(0.5f);
                this.getLimitLinePaint().setTextSize(limitLine.getTextSize());
                float xOffset = limitLine.getLineWidth() + limitLine.getXOffset();
                LimitLine.LimitLabelPosition limitLabelPosition = labelPosition = limitLine.getLabelPosition();
                switch (limitLabelPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$1[limitLabelPosition.ordinal()]) {
                    case 1: {
                        float labelLineHeight = PaintUtilsKt.calcTextHeight(this.getLimitLinePaint(), label);
                        this.getLimitLinePaint().setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(label, position[0] + xOffset, this.getViewPortHandler().contentTop() + yOffset + labelLineHeight, this.getLimitLinePaint());
                        break;
                    }
                    case 2: {
                        this.getLimitLinePaint().setTextAlign(Paint.Align.LEFT);
                        canvas.drawText(label, position[0] + xOffset, this.getViewPortHandler().contentBottom() - yOffset, this.getLimitLinePaint());
                        break;
                    }
                    case 3: {
                        this.getLimitLinePaint().setTextAlign(Paint.Align.RIGHT);
                        float labelLineHeight = PaintUtilsKt.calcTextHeight(this.getLimitLinePaint(), label);
                        canvas.drawText(label, position[0] - xOffset, this.getViewPortHandler().contentTop() + yOffset + labelLineHeight, this.getLimitLinePaint());
                        break;
                    }
                    default: {
                        this.getLimitLinePaint().setTextAlign(Paint.Align.RIGHT);
                        canvas.drawText(label, position[0] - xOffset, this.getViewPortHandler().contentBottom() - yOffset, this.getLimitLinePaint());
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[XAxis.XAxisPosition.values().length];
            try {
                nArray[XAxis.XAxisPosition.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.TOP_INSIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XAxis.XAxisPosition.BOTTOM_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LimitLine.LimitLabelPosition.values().length];
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.LEFT_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

