/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.buffer.AbstractBuffer;
import info.appdev.charting.buffer.BarBuffer;
import info.appdev.charting.data.BarData;
import info.appdev.charting.data.BarEntry;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.highlight.Range;
import info.appdev.charting.interfaces.dataprovider.BarDataProvider;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import info.appdev.charting.renderer.BarLineScatterCandleBubbleRenderer;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.Fill;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PaintUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J \u00101\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J0\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J#\u0010>\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@H\u0016\u00a2\u0006\u0002\u0010BJ\u0018\u0010C\u001a\u00020,2\u0006\u0010D\u001a\u00020A2\u0006\u0010E\u001a\u00020\u0014H\u0014J\u0010\u0010F\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u000e\u0010)\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Linfo/appdev/charting/renderer/BarChartRenderer;", "Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer;", "dataProvider", "Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "mDrawRoundedBars", "", "mRoundedBarRadius", "", "(Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;ZF)V", "getDataProvider", "()Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;", "setDataProvider", "(Linfo/appdev/charting/interfaces/dataprovider/BarDataProvider;)V", "barRect", "Landroid/graphics/RectF;", "getBarRect", "()Landroid/graphics/RectF;", "setBarRect", "(Landroid/graphics/RectF;)V", "barBuffers", "", "Linfo/appdev/charting/buffer/BarBuffer;", "getBarBuffers", "()Ljava/util/List;", "setBarBuffers", "(Ljava/util/List;)V", "shadowPaint", "Landroid/graphics/Paint;", "getShadowPaint", "()Landroid/graphics/Paint;", "setShadowPaint", "(Landroid/graphics/Paint;)V", "barBorderPaint", "getBarBorderPaint", "setBarBorderPaint", "drawRoundedBars", "roundedBarRadius", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "barShadowRectBuffer", "drawDataSet", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IBarDataSet;", "index", "", "prepareBarHighlight", "x", "y1", "y2", "barWidthHalf", "trans", "Linfo/appdev/charting/utils/Transformer;", "drawValues", "drawHighlighted", "indices", "", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "setHighlightDrawPos", "high", "bar", "drawExtras", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarChartRenderer.kt\ninfo/appdev/charting/renderer/BarChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,556:1\n1915#2,2:557\n1#3:559\n*S KotlinDebug\n*F\n+ 1 BarChartRenderer.kt\ninfo/appdev/charting/renderer/BarChartRenderer\n*L\n60#1:557,2\n*E\n"})
public class BarChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    @NotNull
    private BarDataProvider dataProvider;
    @NotNull
    private RectF barRect;
    @NotNull
    private List<BarBuffer> barBuffers;
    @NotNull
    private Paint shadowPaint;
    @NotNull
    private Paint barBorderPaint;
    private boolean drawRoundedBars;
    private float roundedBarRadius;
    @NotNull
    private final RectF barShadowRectBuffer;

    public BarChartRenderer(@NotNull BarDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.barRect = new RectF();
        this.barBuffers = new ArrayList();
        this.barShadowRectBuffer = new RectF();
        this.setPaintHighlight(new Paint(1));
        this.getPaintHighlight().setStyle(Paint.Style.FILL);
        this.getPaintHighlight().setColor(Color.rgb((int)0, (int)0, (int)0));
        this.getPaintHighlight().setAlpha(120);
        this.shadowPaint = new Paint(1);
        this.shadowPaint.setStyle(Paint.Style.FILL);
        this.barBorderPaint = new Paint(1);
        this.barBorderPaint.setStyle(Paint.Style.STROKE);
    }

    @NotNull
    public final BarDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public final void setDataProvider(@NotNull BarDataProvider barDataProvider) {
        Intrinsics.checkNotNullParameter((Object)barDataProvider, (String)"<set-?>");
        this.dataProvider = barDataProvider;
    }

    @NotNull
    protected final RectF getBarRect() {
        return this.barRect;
    }

    protected final void setBarRect(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.barRect = rectF;
    }

    @NotNull
    protected final List<BarBuffer> getBarBuffers() {
        return this.barBuffers;
    }

    protected final void setBarBuffers(@NotNull List<BarBuffer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.barBuffers = list;
    }

    @NotNull
    protected final Paint getShadowPaint() {
        return this.shadowPaint;
    }

    protected final void setShadowPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.shadowPaint = paint;
    }

    @NotNull
    protected final Paint getBarBorderPaint() {
        return this.barBorderPaint;
    }

    protected final void setBarBorderPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.barBorderPaint = paint;
    }

    public BarChartRenderer(@NotNull BarDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler, boolean mDrawRoundedBars, float mRoundedBarRadius) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        this(dataProvider, animator, viewPortHandler);
        this.drawRoundedBars = mDrawRoundedBars;
        this.roundedBarRadius = mRoundedBarRadius;
    }

    @Override
    public void initBuffers() {
        block1: {
            BarData barData = this.dataProvider.getBarData();
            this.barBuffers = new ArrayList();
            Object object = barData;
            if (object == null || (object = ((ChartData)object).getDataSets()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IBarDataSet it = (IBarDataSet)element$iv;
                boolean bl = false;
                this.barBuffers.add(new BarBuffer(it.getEntryCount() * 4 * (it.isStacked() ? it.getStackSize() : 1), barData.getDataSetCount(), it.isStacked()));
            }
        }
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (this.barBuffers.isEmpty()) {
                this.initBuffers();
            }
            BarData barData = this.dataProvider.getBarData();
            if (barData == null) break block2;
            BarData barData2 = barData;
            boolean bl = false;
            int n = barData2.getDataSetCount();
            for (int i = 0; i < n; ++i) {
                IBarDataSet it;
                IBarDataSet dataSet = (IBarDataSet)barData2.getDataSetByIndex(i);
                if (dataSet == null) continue;
                boolean bl2 = false;
                if (!it.isVisible()) continue;
                this.drawDataSet(canvas, it, i);
            }
        }
    }

    protected void drawDataSet(@NotNull Canvas canvas, @NotNull IBarDataSet dataSet, int index) {
        Object object;
        Object barData;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        this.barBorderPaint.setColor(dataSet.getBarBorderColor());
        this.barBorderPaint.setStrokeWidth(NumberUtilsKt.convertDpToPixel(dataSet.getBarBorderWidth()));
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        if (this.dataProvider.isDrawBarShadow()) {
            this.shadowPaint.setColor(dataSet.getBarShadowColor());
            BarData barData2 = this.dataProvider.getBarData();
            if (barData2 != null) {
                barData = barData2;
                boolean bl = false;
                float barWidth = ((BarData)barData).getBarWidth();
                float barWidthHalf = barWidth / 2.0f;
                float x = 0.0f;
                int i = 0;
                int count = (int)Math.min((double)((int)Math.ceil((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
                while (i < count) {
                    BarEntry barEntry = (BarEntry)dataSet.getEntryForIndex(i);
                    if (barEntry != null) {
                        boolean bl2 = false;
                        x = barEntry.getX();
                        this.barShadowRectBuffer.left = x - barWidthHalf;
                        this.barShadowRectBuffer.right = x + barWidthHalf;
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.rectValueToPixel(this.barShadowRectBuffer);
                    }
                    if (!this.getViewPortHandler().isInBoundsLeft(this.barShadowRectBuffer.right)) {
                        ++i;
                        continue;
                    }
                    if (this.getViewPortHandler().isInBoundsRight(this.barShadowRectBuffer.left)) {
                        this.barShadowRectBuffer.top = this.getViewPortHandler().contentTop();
                        this.barShadowRectBuffer.bottom = this.getViewPortHandler().contentBottom();
                        if (this.drawRoundedBars) {
                            canvas.drawRoundRect(this.barShadowRectBuffer, this.roundedBarRadius, this.roundedBarRadius, this.shadowPaint);
                        } else {
                            canvas.drawRect(this.barShadowRectBuffer, this.shadowPaint);
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        BarBuffer barBuffer = this.barBuffers.get(index);
        if (barBuffer != null) {
            barData = barBuffer;
            BarBuffer $this$drawDataSet_u24lambda_u241 = barData;
            boolean bl = false;
            $this$drawDataSet_u24lambda_u241.setPhases(phaseX, phaseY);
            $this$drawDataSet_u24lambda_u241.setDataSet(index);
            $this$drawDataSet_u24lambda_u241.setInverted(this.dataProvider.isInverted(dataSet.getAxisDependency()));
            BarData barData3 = this.dataProvider.getBarData();
            if (barData3 != null) {
                BarData it = barData3;
                boolean bl3 = false;
                $this$drawDataSet_u24lambda_u241.setBarWidth(it.getBarWidth());
            }
            $this$drawDataSet_u24lambda_u241.feed(dataSet);
            object = barData;
        } else {
            object = null;
        }
        AbstractBuffer buffer = object;
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        AbstractBuffer abstractBuffer = buffer;
        Intrinsics.checkNotNull(abstractBuffer);
        transformer.pointValuesToPixel(abstractBuffer.getBuffer());
        boolean isCustomFill = !((Collection)dataSet.getFills()).isEmpty();
        boolean isSingleColor = dataSet.getColors().size() == 1;
        boolean isInverted = this.dataProvider.isInverted(dataSet.getAxisDependency());
        if (isSingleColor) {
            this.getPaintRender().setColor(dataSet.getColor());
        }
        int j = 0;
        int pos = 0;
        while (j < buffer.size()) {
            if (!this.getViewPortHandler().isInBoundsLeft(buffer.getBuffer()[j + 2])) {
                j += 4;
                ++pos;
                continue;
            }
            if (!this.getViewPortHandler().isInBoundsRight(buffer.getBuffer()[j])) break;
            if (!isSingleColor) {
                this.getPaintRender().setColor(dataSet.getColorByIndex(pos));
            }
            if (isCustomFill) {
                Fill fill = dataSet.getFill(pos);
                if (fill != null) {
                    fill.fillRect(canvas, this.getPaintRender(), buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3], isInverted ? Fill.Direction.DOWN : Fill.Direction.UP, this.roundedBarRadius);
                }
            } else if (this.drawRoundedBars) {
                canvas.drawRoundRect(new RectF(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3]), this.roundedBarRadius, this.roundedBarRadius, this.getPaintRender());
            } else {
                canvas.drawRect(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3], this.getPaintRender());
            }
            if (drawBorder) {
                if (this.drawRoundedBars) {
                    canvas.drawRoundRect(new RectF(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3]), this.roundedBarRadius, this.roundedBarRadius, this.barBorderPaint);
                } else {
                    canvas.drawRect(buffer.getBuffer()[j], buffer.getBuffer()[j + 1], buffer.getBuffer()[j + 2], buffer.getBuffer()[j + 3], this.barBorderPaint);
                }
            }
            j += 4;
            ++pos;
        }
    }

    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, @NotNull Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        float left = x - barWidthHalf;
        float right = x + barWidthHalf;
        this.barRect.set(left, y1, right, y2);
        trans.rectToPixelPhase(this.barRect, this.getAnimator().getPhaseY());
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block22: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block22;
            BarData barData = this.dataProvider.getBarData();
            List dataSets = barData != null ? barData.getDataSets() : null;
            float valueOffsetPlus = NumberUtilsKt.convertDpToPixel(4.5f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.dataProvider.isDrawValueAboveBar();
            BarData barData2 = this.dataProvider.getBarData();
            if (barData2 == null) break block22;
            BarData barData3 = barData2;
            boolean bl = false;
            int n = barData3.getDataSetCount();
            for (int i = 0; i < n; ++i) {
                PointF iconsOffset;
                block21: {
                    List list = dataSets;
                    Intrinsics.checkNotNull(list);
                    IBarDataSet dataSet = (IBarDataSet)list.get(i);
                    if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
                    this.applyValueTextStyle(dataSet);
                    boolean isInverted = this.dataProvider.isInverted(dataSet.getAxisDependency());
                    float valueTextHeight = PaintUtilsKt.calcTextHeight(this.getPaintValues(), "8");
                    posOffset = drawValueAboveBar ? -valueOffsetPlus : valueTextHeight + valueOffsetPlus;
                    float f = negOffset = drawValueAboveBar ? valueTextHeight + valueOffsetPlus : -valueOffsetPlus;
                    if (isInverted) {
                        posOffset = -posOffset - valueTextHeight;
                        negOffset = -negOffset - valueTextHeight;
                    }
                    BarBuffer buffer = this.barBuffers.get(i);
                    float phaseY = this.getAnimator().getPhaseY();
                    iconsOffset = PointF.Companion.getInstance(dataSet.getIconsOffset());
                    iconsOffset.setX(NumberUtilsKt.convertDpToPixel(iconsOffset.getX()));
                    iconsOffset.setY(NumberUtilsKt.convertDpToPixel(iconsOffset.getY()));
                    if (!dataSet.isStacked()) {
                        int j = 0;
                        while (true) {
                            float f2 = j;
                            BarBuffer barBuffer = buffer;
                            Intrinsics.checkNotNull((Object)barBuffer);
                            if (!(f2 < (float)barBuffer.getBuffer().length * this.getAnimator().getPhaseX())) break block21;
                            float x = (buffer.getBuffer()[j] + buffer.getBuffer()[j + 2]) / 2.0f;
                            if (!this.getViewPortHandler().isInBoundsRight(x)) break block21;
                            if (!this.getViewPortHandler().isInBoundsY(buffer.getBuffer()[j + 1]) || !this.getViewPortHandler().isInBoundsLeft(x)) {
                                j += 4;
                                continue;
                            }
                            BarEntry barEntry = (BarEntry)dataSet.getEntryForIndex(j / 4);
                            if (barEntry != null) {
                                boolean bl2 = false;
                                float value = barEntry.getY();
                                if (dataSet.isDrawValues()) {
                                    this.drawValue(canvas, dataSet.getValueFormatter(), value, barEntry, i, x, value >= 0.0f ? buffer.getBuffer()[j + 1] + posOffset : buffer.getBuffer()[j + 3] + negOffset, dataSet.getValueTextColor(j / 4));
                                }
                                if (barEntry.getIcon() != null && dataSet.isDrawIcons()) {
                                    Drawable icon = barEntry.getIcon();
                                    float px = 0.0f;
                                    px = x;
                                    float py = 0.0f;
                                    py = value >= 0.0f ? buffer.getBuffer()[j + 1] + posOffset : buffer.getBuffer()[j + 3] + negOffset;
                                    px += iconsOffset.getX();
                                    py += iconsOffset.getY();
                                    if (icon != null) {
                                        Drawable it;
                                        boolean bl3 = false;
                                        CanvasUtilsKt.drawImage(canvas, it, (int)px, (int)py);
                                    }
                                }
                            }
                            j += 4;
                        }
                    }
                    Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                    int bufferIndex = 0;
                    int index = 0;
                    while ((float)index < (float)dataSet.getEntryCount() * this.getAnimator().getPhaseX()) {
                        block23: {
                            float[] vals;
                            block25: {
                                int color;
                                float x;
                                BarEntry barEntry;
                                block24: {
                                    Drawable it;
                                    barEntry = (BarEntry)dataSet.getEntryForIndex(index);
                                    if (barEntry == null) break block23;
                                    boolean bl4 = false;
                                    vals = barEntry.getYVals();
                                    BarBuffer barBuffer = buffer;
                                    Intrinsics.checkNotNull((Object)barBuffer);
                                    x = (barBuffer.getBuffer()[bufferIndex] + buffer.getBuffer()[bufferIndex + 2]) / 2.0f;
                                    color = dataSet.getValueTextColor(index);
                                    if (vals != null) break block24;
                                    if (!this.getViewPortHandler().isInBoundsRight(x)) break;
                                    if (!this.getViewPortHandler().isInBoundsY(buffer.getBuffer()[bufferIndex + 1]) || !this.getViewPortHandler().isInBoundsLeft(x)) continue;
                                    if (dataSet.isDrawValues()) {
                                        this.drawValue(canvas, dataSet.getValueFormatter(), barEntry.getY(), barEntry, i, x, buffer.getBuffer()[bufferIndex + 1] + (barEntry.getY() >= 0.0f ? posOffset : negOffset), color);
                                    }
                                    if (barEntry.getIcon() == null || !dataSet.isDrawIcons()) break block25;
                                    Drawable icon = barEntry.getIcon();
                                    float px = 0.0f;
                                    px = x;
                                    float py = 0.0f;
                                    py = buffer.getBuffer()[bufferIndex + 1] + (barEntry.getY() >= 0.0f ? posOffset : negOffset);
                                    px += iconsOffset.getX();
                                    py += iconsOffset.getY();
                                    if (icon == null) break block25;
                                    boolean bl5 = false;
                                    CanvasUtilsKt.drawImage(canvas, it, (int)px, (int)py);
                                    break block25;
                                }
                                float[] transformed = new float[vals.length * 2];
                                float posY = 0.0f;
                                float negY = 0.0f;
                                negY = -barEntry.getNegativeSum();
                                BarChartRenderer $this$drawValues_u24lambda_u240_u241_u241 = this;
                                boolean bl6 = false;
                                int k = 0;
                                int idx = 0;
                                while (k < transformed.length) {
                                    float value = vals[idx];
                                    float y = 0.0f;
                                    if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                                        y = value;
                                    } else if (value >= 0.0f) {
                                        y = posY += value;
                                    } else {
                                        y = negY;
                                        negY -= value;
                                    }
                                    transformed[k + 1] = y * phaseY;
                                    k += 2;
                                    ++idx;
                                }
                                Transformer transformer = trans;
                                Intrinsics.checkNotNull((Object)transformer);
                                transformer.pointValuesToPixel(transformed);
                                int k2 = 0;
                                while (k2 < transformed.length) {
                                    float val = vals[k2 / 2];
                                    boolean drawBelow = val == 0.0f && negY == 0.0f && posY > 0.0f || val < 0.0f;
                                    float y = transformed[k2 + 1] + (drawBelow ? negOffset : posOffset);
                                    if (!this.getViewPortHandler().isInBoundsRight(x)) break;
                                    if (!this.getViewPortHandler().isInBoundsY(y) || !this.getViewPortHandler().isInBoundsLeft(x)) {
                                        k2 += 2;
                                        continue;
                                    }
                                    if (dataSet.isDrawValues()) {
                                        this.drawValue(canvas, dataSet.getValueFormatter(), vals[k2 / 2], barEntry, i, x, y, color);
                                    }
                                    if (barEntry.getIcon() != null && dataSet.isDrawIcons()) {
                                        Drawable icon = barEntry.getIcon();
                                        if (icon != null) {
                                            Drawable it;
                                            boolean bl7 = false;
                                            CanvasUtilsKt.drawImage(canvas, it, (int)(x + iconsOffset.getX()), (int)(y + iconsOffset.getY()));
                                        }
                                    }
                                    k2 += 2;
                                }
                            }
                            bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                        }
                        ++index;
                    }
                }
                PointF.Companion.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        BarData barData = this.dataProvider.getBarData();
        for (Highlight high : indices) {
            IBarDataSet set;
            BarData barData2 = barData;
            IBarDataSet iBarDataSet = set = barData2 != null ? (IBarDataSet)barData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlight()) continue;
            Object t = set.getEntryForXValue(high.getX(), high.getY());
            Intrinsics.checkNotNull(t);
            BarEntry barEntry = (BarEntry)t;
            if (!this.isInBoundsX((Entry)barEntry, set)) continue;
            Transformer trans = this.dataProvider.getTransformer(set.getAxisDependency());
            this.getPaintHighlight().setColor(set.getHighLightColor());
            this.getPaintHighlight().setAlpha(set.getHighLightAlpha());
            boolean isStack = high.getStackIndex() >= 0 && barEntry.isStacked();
            float y1 = 0.0f;
            float y2 = 0.0f;
            if (isStack) {
                if (this.dataProvider.isHighlightFullBar()) {
                    y1 = barEntry.getPositiveSum();
                    y2 = -barEntry.getNegativeSum();
                } else {
                    Range range = barEntry.getRanges()[high.getStackIndex()];
                    y1 = range.getFrom();
                    y2 = range.getTo();
                }
            } else {
                y1 = barEntry.getY();
                y2 = 0.0f;
            }
            float f = barEntry.getX();
            float f2 = barData.getBarWidth() / 2.0f;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            this.prepareBarHighlight(f, y1, y2, f2, transformer);
            this.setHighlightDrawPos(high, this.barRect);
            if (this.drawRoundedBars) {
                canvas.drawRoundRect(new RectF(this.barRect), this.roundedBarRadius, this.roundedBarRadius, this.getPaintHighlight());
                continue;
            }
            canvas.drawRect(this.barRect, this.getPaintHighlight());
        }
    }

    protected void setHighlightDrawPos(@NotNull Highlight high, @NotNull RectF bar) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        high.setDraw(bar.centerX(), bar.top);
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }
}

