/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.charts.PieChart;
import info.appdev.charting.data.PieData;
import info.appdev.charting.data.PieDataSet;
import info.appdev.charting.data.PieEntry;
import info.appdev.charting.formatter.IValueFormatter;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.datasets.IPieDataSet;
import info.appdev.charting.renderer.DataRenderer;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PaintUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Utils;
import info.appdev.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u000205H\u0016J@\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020J2\u0006\u0010:\u001a\u00020;2\u0006\u0010K\u001a\u00020;2\u0006\u0010L\u001a\u00020;2\u0006\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020;2\u0006\u0010O\u001a\u00020;H\u0004J\u0010\u0010P\u001a\u00020;2\u0006\u0010Q\u001a\u00020RH\u0004J\u0010\u0010S\u001a\u00020B2\u0006\u0010Q\u001a\u00020RH\u0004J\u0010\u0010T\u001a\u00020B2\u0006\u0010D\u001a\u000205H\u0016J(\u0010U\u001a\u00020B2\u0006\u0010D\u001a\u0002052\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020;2\u0006\u0010Y\u001a\u00020;H\u0004J\u0010\u0010Z\u001a\u00020B2\u0006\u0010D\u001a\u000205H\u0016J\b\u0010\\\u001a\u00020BH\u0004J\u0010\u0010b\u001a\u00020B2\u0006\u0010D\u001a\u000205H\u0004J#\u0010h\u001a\u00020B2\u0006\u0010D\u001a\u0002052\f\u0010i\u001a\b\u0012\u0004\u0012\u00020j0+H\u0016\u00a2\u0006\u0002\u0010kJ\b\u0010l\u001a\u00020BH\u0004J\u0006\u0010m\u001a\u00020BR\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020)0+X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010,R\"\u0010-\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010<\u001a\u00020;2\u0006\u0010:\u001a\u00020;8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010]\u001a\u00020FX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR\u001a\u0010c\u001a\u00020)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010e\"\u0004\bf\u0010g\u00a8\u0006n"}, d2={"Linfo/appdev/charting/renderer/PieChartRenderer;", "Linfo/appdev/charting/renderer/DataRenderer;", "chart", "Linfo/appdev/charting/charts/PieChart;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/charts/PieChart;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "getChart", "()Linfo/appdev/charting/charts/PieChart;", "setChart", "(Linfo/appdev/charting/charts/PieChart;)V", "value", "Landroid/graphics/Paint;", "paintHole", "getPaintHole", "()Landroid/graphics/Paint;", "setPaintHole", "(Landroid/graphics/Paint;)V", "paintTransparentCircle", "getPaintTransparentCircle", "setPaintTransparentCircle", "valueLinePaint", "getValueLinePaint", "setValueLinePaint", "roundedCornerPaint", "getRoundedCornerPaint", "setRoundedCornerPaint", "paintCenterText", "Landroid/text/TextPaint;", "getPaintCenterText", "()Landroid/text/TextPaint;", "paintEntryLabels", "getPaintEntryLabels", "centerTextLayout", "Landroid/text/StaticLayout;", "centerTextLastValue", "", "centerTextLastBounds", "Landroid/graphics/RectF;", "rectBuffer", "", "[Landroid/graphics/RectF;", "mDrawBitmap", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "getMDrawBitmap", "()Ljava/lang/ref/WeakReference;", "setMDrawBitmap", "(Ljava/lang/ref/WeakReference;)V", "bitmapCanvas", "Landroid/graphics/Canvas;", "getBitmapCanvas", "()Landroid/graphics/Canvas;", "setBitmapCanvas", "(Landroid/graphics/Canvas;)V", "radius", "", "roundedCornerRadius", "getRoundedCornerRadius", "()F", "setRoundedCornerRadius", "(F)V", "initBuffers", "", "drawData", "canvas", "mPathBuffer", "Landroid/graphics/Path;", "mInnerRectBuffer", "calculateMinimumRadiusForSpacedSlice", "center", "Linfo/appdev/charting/utils/PointF;", "angle", "arcStartPointX", "arcStartPointY", "startAngle", "sweepAngle", "getSliceSpace", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IPieDataSet;", "drawDataSet", "drawValues", "drawEntryLabel", "label", "", "x", "y", "drawExtras", "mHoleCirclePath", "drawHole", "mDrawCenterTextPathBuffer", "getMDrawCenterTextPathBuffer", "()Landroid/graphics/Path;", "setMDrawCenterTextPathBuffer", "(Landroid/graphics/Path;)V", "drawCenterText", "mDrawHighlightedRectF", "getMDrawHighlightedRectF", "()Landroid/graphics/RectF;", "setMDrawHighlightedRectF", "(Landroid/graphics/RectF;)V", "drawHighlighted", "indices", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "drawRoundedSlices", "releaseBitmap", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nPieChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieChartRenderer.kt\ninfo/appdev/charting/renderer/PieChartRenderer\n+ 2 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n+ 3 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,968:1\n88#2:969\n27#3,7:970\n27#3,7:977\n*S KotlinDebug\n*F\n+ 1 PieChartRenderer.kt\ninfo/appdev/charting/renderer/PieChartRenderer\n*L\n98#1:969\n390#1:970,7\n690#1:977,7\n*E\n"})
public class PieChartRenderer
extends DataRenderer {
    @NotNull
    private PieChart chart;
    @NotNull
    private Paint paintHole;
    @NotNull
    private Paint paintTransparentCircle;
    @NotNull
    private Paint valueLinePaint;
    @NotNull
    private Paint roundedCornerPaint;
    @NotNull
    private final TextPaint paintCenterText;
    @NotNull
    private final Paint paintEntryLabels;
    @Nullable
    private StaticLayout centerTextLayout;
    @Nullable
    private CharSequence centerTextLastValue;
    @NotNull
    private final RectF centerTextLastBounds;
    @NotNull
    private final RectF[] rectBuffer;
    @Nullable
    private WeakReference<Bitmap> mDrawBitmap;
    @Nullable
    private Canvas bitmapCanvas;
    @NotNull
    private final Path mPathBuffer;
    @NotNull
    private final RectF mInnerRectBuffer;
    @NotNull
    private final Path mHoleCirclePath;
    @NotNull
    private Path mDrawCenterTextPathBuffer;
    @NotNull
    private RectF mDrawHighlightedRectF;

    public PieChartRenderer(@NotNull PieChart chart, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.centerTextLastBounds = new RectF();
        RectF[] rectFArray = new RectF[]{new RectF(), new RectF(), new RectF()};
        this.rectBuffer = rectFArray;
        this.mPathBuffer = new Path();
        this.mInnerRectBuffer = new RectF();
        this.mHoleCirclePath = new Path();
        this.mDrawCenterTextPathBuffer = new Path();
        this.mDrawHighlightedRectF = new RectF();
        this.paintHole = new Paint(1);
        this.paintHole.setColor(-1);
        this.paintHole.setStyle(Paint.Style.FILL);
        this.paintTransparentCircle = new Paint(1);
        this.paintTransparentCircle.setColor(-1);
        this.paintTransparentCircle.setStyle(Paint.Style.FILL);
        this.paintTransparentCircle.setAlpha(105);
        this.paintCenterText = new TextPaint(1);
        this.paintCenterText.setColor(-16777216);
        this.paintCenterText.setTextSize(NumberUtilsKt.convertDpToPixel(12.0f));
        this.getPaintValues().setTextSize(NumberUtilsKt.convertDpToPixel(13.0f));
        this.getPaintValues().setColor(-1);
        this.getPaintValues().setTextAlign(Paint.Align.CENTER);
        this.paintEntryLabels = new Paint(1);
        this.paintEntryLabels.setColor(-1);
        this.paintEntryLabels.setTextAlign(Paint.Align.CENTER);
        this.paintEntryLabels.setTextSize(NumberUtilsKt.convertDpToPixel(13.0f));
        this.valueLinePaint = new Paint(1);
        this.valueLinePaint.setStyle(Paint.Style.STROKE);
        this.roundedCornerPaint = new Paint(1);
        this.roundedCornerPaint.setStyle(Paint.Style.STROKE);
        this.roundedCornerPaint.setAntiAlias(true);
    }

    @NotNull
    protected final PieChart getChart() {
        return this.chart;
    }

    protected final void setChart(@NotNull PieChart pieChart) {
        Intrinsics.checkNotNullParameter((Object)pieChart, (String)"<set-?>");
        this.chart = pieChart;
    }

    @NotNull
    public final Paint getPaintHole() {
        return this.paintHole;
    }

    protected final void setPaintHole(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintHole = paint;
    }

    @NotNull
    public final Paint getPaintTransparentCircle() {
        return this.paintTransparentCircle;
    }

    protected final void setPaintTransparentCircle(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintTransparentCircle = paint;
    }

    @NotNull
    protected final Paint getValueLinePaint() {
        return this.valueLinePaint;
    }

    protected final void setValueLinePaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.valueLinePaint = paint;
    }

    @NotNull
    protected final Paint getRoundedCornerPaint() {
        return this.roundedCornerPaint;
    }

    protected final void setRoundedCornerPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.roundedCornerPaint = paint;
    }

    @NotNull
    public final TextPaint getPaintCenterText() {
        return this.paintCenterText;
    }

    @NotNull
    public final Paint getPaintEntryLabels() {
        return this.paintEntryLabels;
    }

    @Nullable
    protected final WeakReference<Bitmap> getMDrawBitmap() {
        return this.mDrawBitmap;
    }

    protected final void setMDrawBitmap(@Nullable WeakReference<Bitmap> weakReference) {
        this.mDrawBitmap = weakReference;
    }

    @Nullable
    protected final Canvas getBitmapCanvas() {
        return this.bitmapCanvas;
    }

    protected final void setBitmapCanvas(@Nullable Canvas canvas) {
        this.bitmapCanvas = canvas;
    }

    public final float getRoundedCornerRadius() {
        return this.roundedCornerPaint.getStrokeWidth();
    }

    public final void setRoundedCornerRadius(float radius) {
        this.roundedCornerPaint.setStrokeWidth(radius);
    }

    @Override
    public void initBuffers() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawData(@NotNull Canvas canvas) {
        Bitmap drawBitmap;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int width = (int)this.getViewPortHandler().getChartWidth();
        int height = (int)this.getViewPortHandler().getChartHeight();
        if (this.mDrawBitmap == null) {
            v0 = null;
        } else {
            WeakReference<Bitmap> weakReference = this.mDrawBitmap;
            Intrinsics.checkNotNull(weakReference);
            v0 = drawBitmap = (Bitmap)weakReference.get();
        }
        if (drawBitmap == null || drawBitmap.getWidth() != width || drawBitmap.getHeight() != height) {
            if (width > 0 && height > 0) {
                void height$iv;
                void width$iv;
                int n = width;
                int n2 = height;
                Bitmap.Config config$iv = Bitmap.Config.ARGB_4444;
                boolean $i$f$createBitmap = false;
                drawBitmap = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
                this.mDrawBitmap = new WeakReference<Bitmap>(drawBitmap);
                this.bitmapCanvas = new Canvas(drawBitmap);
            } else {
                return;
            }
        }
        drawBitmap.eraseColor(0);
        PieData pieData = (PieData)this.chart.getData();
        Object object = pieData;
        if (object == null || (object = ((PieData)object).getDataSets()) == null) {
            return;
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            IPieDataSet set = (IPieDataSet)iterator.next();
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(set);
        }
    }

    protected final float calculateMinimumRadiusForSpacedSlice(@NotNull PointF center, float radius, float angle, float arcStartPointX, float arcStartPointY, float startAngle, float sweepAngle) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        float angleMiddle = startAngle + sweepAngle / 2.0f;
        float arcEndPointX = center.getX() + radius * (float)Math.cos((startAngle + sweepAngle) * ((float)Math.PI / 180));
        float arcEndPointY = center.getY() + radius * (float)Math.sin((startAngle + sweepAngle) * ((float)Math.PI / 180));
        float arcMidPointX = center.getX() + radius * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
        float arcMidPointY = center.getY() + radius * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
        double basePointsDistance = Math.sqrt(Math.pow(arcEndPointX - arcStartPointX, 2.0) + Math.pow(arcEndPointY - arcStartPointY, 2.0));
        float containedTriangleHeight = (float)(basePointsDistance / 2.0 * Math.tan((180.0 - (double)angle) / 2.0 * (Math.PI / 180)));
        float spacedRadius = radius - containedTriangleHeight;
        return spacedRadius -= (float)Math.sqrt(Math.pow(arcMidPointX - (arcEndPointX + arcStartPointX) / 2.0f, 2.0) + Math.pow(arcMidPointY - (arcEndPointY + arcStartPointY) / 2.0f, 2.0));
    }

    protected final float getSliceSpace(@NotNull IPieDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (!dataSet.isAutomaticallyDisableSliceSpacingEnabled()) {
            return dataSet.getSliceSpace();
        }
        float spaceSizeRatio = dataSet.getSliceSpace() / this.getViewPortHandler().getSmallestContentExtension();
        float f = dataSet.getYMin();
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        float minValueRatio = f / ((PieData)t).getYValueSum() * (float)2;
        float sliceSpace = spaceSizeRatio > minValueRatio ? 0.0f : dataSet.getSliceSpace();
        return sliceSpace;
    }

    protected final void drawDataSet(@NotNull IPieDataSet dataSet) {
        float sliceSpace;
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        float angle = 0.0f;
        float rotationAngle = this.chart.getRotationAngle();
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        RectF circleBox = this.chart.getCircleBox();
        int entryCount = dataSet.getEntryCount();
        float[] drawAngles = this.chart.getDrawAngles();
        PointF center = this.chart.getCenterCircleBox();
        float radius = this.chart.getRadius();
        boolean drawInnerArc = this.chart.isDrawHoleEnabled() && !this.chart.isDrawSlicesUnderHoleEnabled();
        float userInnerRadius = drawInnerArc ? radius * (this.chart.getHoleRadius() / 100.0f) : 0.0f;
        float roundedRadius = (radius - radius * this.chart.getHoleRadius() / 100.0f) / 2.0f;
        RectF roundedCircleBox = new RectF();
        boolean drawRoundedSlices = drawInnerArc && this.chart.isDrawRoundedSlicesEnabled();
        int visibleAngleCount = 0;
        for (int j = 0; j < entryCount; ++j) {
            Object t = dataSet.getEntryForIndex(j);
            Intrinsics.checkNotNull(t);
            if (!(Math.abs((double)((PieEntry)t).getY()) > (double)Utils.INSTANCE.getFLOAT_EPSILON())) continue;
            ++visibleAngleCount;
        }
        float f = sliceSpace = visibleAngleCount <= 1 ? 0.0f : this.getSliceSpace(dataSet);
        if (this.getRoundedCornerRadius() > 0.0f) {
            this.roundedCornerPaint.setStrokeCap(Paint.Cap.ROUND);
            this.roundedCornerPaint.setStrokeJoin(Paint.Join.ROUND);
        }
        for (int j = 0; j < entryCount; ++j) {
            float sliceAngle = drawAngles[j];
            float innerRadius = userInnerRadius;
            if ((PieEntry)dataSet.getEntryForIndex(j) != null) {
                PieEntry pieEntry;
                boolean bl = false;
                if (!(Math.abs((double)pieEntry.getY()) > (double)Utils.INSTANCE.getFLOAT_EPSILON())) {
                    angle += sliceAngle * phaseX;
                    continue;
                }
            }
            if (dataSet.isHighlightEnabled() && this.chart.needsHighlight(j) && !drawRoundedSlices) {
                angle += sliceAngle * phaseX;
                continue;
            }
            boolean accountForSliceSpacing = sliceSpace > 0.0f && sliceAngle <= 180.0f;
            this.getPaintRender().setColor(dataSet.getColorByIndex(j));
            this.roundedCornerPaint.setColor(dataSet.getColorByIndex(j));
            float sliceSpaceAngleOuter = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * radius);
            float startAngleOuter = rotationAngle + (angle + sliceSpaceAngleOuter / 2.0f) * phaseY;
            float sweepAngleOuter = (sliceAngle - sliceSpaceAngleOuter) * phaseY;
            if (sweepAngleOuter < 0.0f) {
                sweepAngleOuter = 0.0f;
            }
            this.mPathBuffer.reset();
            if (drawRoundedSlices) {
                float x = center.getX() + (radius - roundedRadius) * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180));
                float y = center.getY() + (radius - roundedRadius) * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180));
                roundedCircleBox.set(x - roundedRadius, y - roundedRadius, x + roundedRadius, y + roundedRadius);
            }
            float arcStartPointX = center.getX() + radius * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180));
            float arcStartPointY = center.getY() + radius * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180));
            if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.INSTANCE.getFLOAT_EPSILON()) {
                this.mPathBuffer.addCircle(center.getX(), center.getY(), radius, Path.Direction.CW);
            } else {
                if (drawRoundedSlices) {
                    this.mPathBuffer.arcTo(roundedCircleBox, startAngleOuter + (float)180, -180.0f);
                }
                this.mPathBuffer.arcTo(circleBox, startAngleOuter, sweepAngleOuter);
            }
            this.mInnerRectBuffer.set(center.getX() - innerRadius, center.getY() - innerRadius, center.getX() + innerRadius, center.getY() + innerRadius);
            if (drawInnerArc && (innerRadius > 0.0f || accountForSliceSpacing)) {
                if (accountForSliceSpacing) {
                    float minSpacedRadius = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, arcStartPointX, arcStartPointY, startAngleOuter, sweepAngleOuter);
                    if (minSpacedRadius < 0.0f) {
                        minSpacedRadius = -minSpacedRadius;
                    }
                    innerRadius = (float)Math.max((double)innerRadius, (double)minSpacedRadius);
                }
                float sliceSpaceAngleInner = visibleAngleCount == 1 || innerRadius == 0.0f ? 0.0f : sliceSpace / ((float)Math.PI / 180 * innerRadius);
                float startAngleInner = rotationAngle + (angle + sliceSpaceAngleInner / 2.0f) * phaseY;
                float sweepAngleInner = (sliceAngle - sliceSpaceAngleInner) * phaseY;
                if (sweepAngleInner < 0.0f) {
                    sweepAngleInner = 0.0f;
                }
                float endAngleInner = startAngleInner + sweepAngleInner;
                if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.INSTANCE.getFLOAT_EPSILON()) {
                    this.mPathBuffer.addCircle(center.getX(), center.getY(), innerRadius, Path.Direction.CCW);
                } else {
                    if (drawRoundedSlices) {
                        float x = center.getX() + (radius - roundedRadius) * (float)Math.cos(endAngleInner * ((float)Math.PI / 180));
                        float y = center.getY() + (radius - roundedRadius) * (float)Math.sin(endAngleInner * ((float)Math.PI / 180));
                        roundedCircleBox.set(x - roundedRadius, y - roundedRadius, x + roundedRadius, y + roundedRadius);
                        this.mPathBuffer.arcTo(roundedCircleBox, endAngleInner, 180.0f);
                    } else {
                        this.mPathBuffer.lineTo(center.getX() + innerRadius * (float)Math.cos(endAngleInner * ((float)Math.PI / 180)), center.getY() + innerRadius * (float)Math.sin(endAngleInner * ((float)Math.PI / 180)));
                    }
                    this.mPathBuffer.arcTo(this.mInnerRectBuffer, endAngleInner, -sweepAngleInner);
                }
            } else if (sweepAngleOuter % 360.0f > Utils.INSTANCE.getFLOAT_EPSILON()) {
                if (accountForSliceSpacing) {
                    float angleMiddle = startAngleOuter + sweepAngleOuter / 2.0f;
                    float sliceSpaceOffset = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, arcStartPointX, arcStartPointY, startAngleOuter, sweepAngleOuter);
                    float arcEndPointX = center.getX() + sliceSpaceOffset * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
                    float arcEndPointY = center.getY() + sliceSpaceOffset * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
                    this.mPathBuffer.lineTo(arcEndPointX, arcEndPointY);
                } else {
                    this.mPathBuffer.lineTo(center.getX(), center.getY());
                }
            }
            this.mPathBuffer.close();
            Canvas canvas = this.bitmapCanvas;
            Intrinsics.checkNotNull((Object)canvas);
            canvas.drawPath(this.mPathBuffer, this.getPaintRender());
            if (this.getRoundedCornerRadius() > 0.0f) {
                Canvas canvas2 = this.bitmapCanvas;
                Intrinsics.checkNotNull((Object)canvas2);
                canvas2.drawPath(this.mPathBuffer, this.roundedCornerPaint);
            }
            angle += sliceAngle * phaseX;
        }
        PointF.Companion.recycleInstance(center);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawValues(@NotNull Canvas canvas) {
        PieData data;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        PointF center = this.chart.getCenterCircleBox();
        float radius = this.chart.getRadius();
        float rotationAngle = 0.0f;
        rotationAngle = this.chart.getRotationAngle();
        float[] drawAngles = this.chart.getDrawAngles();
        float[] absoluteAngles = this.chart.getAbsoluteAngles();
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        float roundedRadius = (radius - radius * this.chart.getHoleRadius() / 100.0f) / 2.0f;
        float holeRadiusPercent = this.chart.getHoleRadius() / 100.0f;
        float labelRadiusOffset = radius / 10.0f * 3.6f;
        if (this.chart.isDrawHoleEnabled()) {
            labelRadiusOffset = (radius - radius * holeRadiusPercent) / 2.0f;
            if (!this.chart.isDrawSlicesUnderHoleEnabled() && this.chart.isDrawRoundedSlicesEnabled()) {
                rotationAngle += (float)((double)(roundedRadius * (float)360) / (Math.PI * 2 * (double)radius));
            }
        }
        float labelRadius = radius - labelRadiusOffset;
        PieData pieData = data = (PieData)this.chart.getData();
        Intrinsics.checkNotNull((Object)pieData);
        List<IPieDataSet> dataSets = pieData.getDataSets();
        float yValueSum = data.getYValueSum();
        boolean drawEntryLabels = this.chart.isDrawEntryLabelsEnabled();
        float angle = 0.0f;
        int xIndex = 0;
        Canvas $this$withSave$iv = canvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawValues_u24lambda_u240 = $this$withSave$iv;
            boolean bl = false;
            float offset = NumberUtilsKt.convertDpToPixel(5.0f);
            List<IPieDataSet> list = dataSets;
            if (list != null) {
                List<IPieDataSet> it = list;
                boolean bl2 = false;
                int n = ((Collection)it).size();
                for (int i = 0; i < n; ++i) {
                    boolean drawValues;
                    IPieDataSet dataSet = dataSets.get(i);
                    if (dataSet.getEntryCount() == 0 || !(drawValues = dataSet.isDrawValues()) && !drawEntryLabels) continue;
                    PieDataSet.ValuePosition xValuePosition = dataSet.getXValuePosition();
                    PieDataSet.ValuePosition yValuePosition = dataSet.getYValuePosition();
                    this.applyValueTextStyle(dataSet);
                    float lineHeight = (float)PaintUtilsKt.calcTextHeight(this.getPaintValues(), "Q") + NumberUtilsKt.convertDpToPixel(4.0f);
                    IValueFormatter formatter = dataSet.getValueFormatter();
                    int entryCount = dataSet.getEntryCount();
                    boolean isUseValueColorForLineEnabled = dataSet.isUseValueColorForLineEnabled();
                    int valueLineColor = dataSet.getValueLineColor();
                    this.valueLinePaint.setStrokeWidth(NumberUtilsKt.convertDpToPixel(dataSet.getValueLineWidth()));
                    float sliceSpace = this.getSliceSpace(dataSet);
                    PointF iconsOffset = PointF.Companion.getInstance(dataSet.getIconsOffset());
                    iconsOffset.setX(NumberUtilsKt.convertDpToPixel(iconsOffset.getX()));
                    iconsOffset.setY(NumberUtilsKt.convertDpToPixel(iconsOffset.getY()));
                    for (int j = 0; j < entryCount; ++j) {
                        if ((PieEntry)dataSet.getEntryForIndex(j) != null) {
                            boolean drawYInside;
                            PieEntry entry;
                            boolean bl3 = false;
                            angle = xIndex == 0 ? 0.0f : absoluteAngles[xIndex - 1] * phaseX;
                            float sliceAngle = drawAngles[xIndex];
                            float sliceSpaceMiddleAngle = sliceSpace / ((float)Math.PI / 180 * labelRadius);
                            float angleOffset = (sliceAngle - sliceSpaceMiddleAngle / 2.0f) / 2.0f;
                            float transformedAngle = rotationAngle + (angle += angleOffset) * phaseY;
                            float value = this.chart.isUsePercentValuesEnabled() ? entry.getY() / yValueSum * 100.0f : entry.getY();
                            String entryLabel = entry.getLabel();
                            float sliceXBase = (float)Math.cos(transformedAngle * ((float)Math.PI / 180));
                            float sliceYBase = (float)Math.sin(transformedAngle * ((float)Math.PI / 180));
                            boolean drawXOutside = drawEntryLabels && xValuePosition == PieDataSet.ValuePosition.OUTSIDE_SLICE;
                            boolean drawYOutside = drawValues && yValuePosition == PieDataSet.ValuePosition.OUTSIDE_SLICE;
                            boolean drawXInside = drawEntryLabels && xValuePosition == PieDataSet.ValuePosition.INSIDE_SLICE;
                            boolean bl4 = drawYInside = drawValues && yValuePosition == PieDataSet.ValuePosition.INSIDE_SLICE;
                            if (drawXOutside || drawYOutside) {
                                float line1Radius;
                                float valueLineLength1 = dataSet.getValueLinePart1Length();
                                float valueLineLength2 = dataSet.getValueLinePart2Length();
                                float valueLinePart1OffsetPercentage = dataSet.getValueLinePart1OffsetPercentage() / 100.0f;
                                float pt2x = 0.0f;
                                float pt2y = 0.0f;
                                float labelPtx = 0.0f;
                                float labelPty = 0.0f;
                                float f = line1Radius = this.chart.isDrawHoleEnabled() ? (radius - radius * holeRadiusPercent) * valueLinePart1OffsetPercentage + radius * holeRadiusPercent : radius * valueLinePart1OffsetPercentage;
                                float polyline2Width = dataSet.isValueLineVariableLength() ? labelRadius * valueLineLength2 * (float)Math.abs(Math.sin(transformedAngle * ((float)Math.PI / 180))) : labelRadius * valueLineLength2;
                                float pt0x = line1Radius * sliceXBase + center.getX();
                                float pt0y = line1Radius * sliceYBase + center.getY();
                                float pt1x = labelRadius * (1.0f + valueLineLength1) * sliceXBase + center.getX();
                                float pt1y = labelRadius * (1.0f + valueLineLength1) * sliceYBase + center.getY();
                                double d = (double)transformedAngle % 360.0;
                                boolean bl5 = 90.0 <= d ? d <= 270.0 : false;
                                if (bl5) {
                                    pt2x = pt1x - polyline2Width;
                                    pt2y = pt1y;
                                    this.getPaintValues().setTextAlign(Paint.Align.RIGHT);
                                    if (drawXOutside) {
                                        this.paintEntryLabels.setTextAlign(Paint.Align.RIGHT);
                                    }
                                    labelPtx = pt2x - offset;
                                    labelPty = pt2y;
                                } else {
                                    pt2x = pt1x + polyline2Width;
                                    pt2y = pt1y;
                                    this.getPaintValues().setTextAlign(Paint.Align.LEFT);
                                    if (drawXOutside) {
                                        this.paintEntryLabels.setTextAlign(Paint.Align.LEFT);
                                    }
                                    labelPtx = pt2x + offset;
                                    labelPty = pt2y;
                                }
                                int lineColor = 0x112233;
                                if (isUseValueColorForLineEnabled) {
                                    lineColor = dataSet.getColorByIndex(j);
                                } else if (valueLineColor != 0x112233) {
                                    lineColor = valueLineColor;
                                }
                                if (lineColor != 0x112233) {
                                    this.valueLinePaint.setColor(lineColor);
                                    $this$drawValues_u24lambda_u240.drawLine(pt0x, pt0y, pt1x, pt1y, this.valueLinePaint);
                                    $this$drawValues_u24lambda_u240.drawLine(pt1x, pt1y, pt2x, pt2y, this.valueLinePaint);
                                }
                                if (drawXOutside && drawYOutside) {
                                    this.drawValue($this$drawValues_u24lambda_u240, formatter, value, entry, 0, labelPtx, labelPty, dataSet.getValueTextColor(j));
                                    if (j < data.getEntryCount() && entryLabel != null) {
                                        this.drawEntryLabel($this$drawValues_u24lambda_u240, entryLabel, labelPtx, labelPty + lineHeight);
                                    }
                                } else if (drawXOutside) {
                                    if (j < data.getEntryCount() && entryLabel != null) {
                                        this.drawEntryLabel($this$drawValues_u24lambda_u240, entryLabel, labelPtx, labelPty + lineHeight / 2.0f);
                                    }
                                } else if (drawYOutside) {
                                    this.drawValue($this$drawValues_u24lambda_u240, formatter, value, entry, 0, labelPtx, labelPty + lineHeight / 2.0f, dataSet.getValueTextColor(j));
                                }
                            }
                            if (drawXInside || drawYInside) {
                                float x = labelRadius * sliceXBase + center.getX();
                                float y = labelRadius * sliceYBase + center.getY();
                                this.getPaintValues().setTextAlign(Paint.Align.CENTER);
                                if (drawXInside && drawYInside) {
                                    this.drawValue($this$drawValues_u24lambda_u240, formatter, value, entry, 0, x, y, dataSet.getValueTextColor(j));
                                    if (j < data.getEntryCount() && entryLabel != null) {
                                        this.drawEntryLabel($this$drawValues_u24lambda_u240, entryLabel, x, y + lineHeight);
                                    }
                                } else if (drawXInside) {
                                    if (j < data.getEntryCount() && entryLabel != null) {
                                        this.drawEntryLabel($this$drawValues_u24lambda_u240, entryLabel, x, y + lineHeight / 2.0f);
                                    }
                                } else if (drawYInside) {
                                    this.drawValue($this$drawValues_u24lambda_u240, formatter, value, entry, 0, x, y + lineHeight / 2.0f, dataSet.getValueTextColor(j));
                                }
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIcons()) {
                                Drawable icon = entry.getIcon();
                                float x = (labelRadius + iconsOffset.getY()) * sliceXBase + center.getX();
                                float y = 0.0f;
                                y = (labelRadius + iconsOffset.getY()) * sliceYBase + center.getY();
                                y += iconsOffset.getX();
                                if (icon != null) {
                                    Drawable it2;
                                    boolean bl6 = false;
                                    CanvasUtilsKt.drawImage($this$drawValues_u24lambda_u240, it2, (int)x, (int)y);
                                    v5 = Unit.INSTANCE;
                                } else {
                                    v5 = null;
                                }
                            }
                            v6 = Unit.INSTANCE;
                        } else {
                            v6 = null;
                        }
                        ++xIndex;
                    }
                    PointF.Companion.recycleInstance(iconsOffset);
                }
                v7 = Unit.INSTANCE;
            } else {
                v7 = null;
            }
            PointF.Companion.recycleInstance(center);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }

    protected final void drawEntryLabel(@NotNull Canvas canvas, @NotNull String label, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        canvas.drawText(label, x, y, this.paintEntryLabels);
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.drawHole();
        WeakReference<Bitmap> weakReference = this.mDrawBitmap;
        Intrinsics.checkNotNull(weakReference);
        Object t = weakReference.get();
        Intrinsics.checkNotNull(t);
        canvas.drawBitmap((Bitmap)t, 0.0f, 0.0f, null);
        this.drawCenterText(canvas);
    }

    protected final void drawHole() {
        if (this.chart.isDrawHoleEnabled() && this.bitmapCanvas != null) {
            float radius = this.chart.getRadius();
            float holeRadius = radius * (this.chart.getHoleRadius() / (float)100);
            PointF center = this.chart.getCenterCircleBox();
            if (Color.alpha((int)this.paintHole.getColor()) > 0) {
                Canvas canvas = this.bitmapCanvas;
                Intrinsics.checkNotNull((Object)canvas);
                canvas.drawCircle(center.getX(), center.getY(), holeRadius, this.paintHole);
            }
            if (Color.alpha((int)this.paintTransparentCircle.getColor()) > 0 && this.chart.getTransparentCircleRadius() > this.chart.getHoleRadius()) {
                int alpha = this.paintTransparentCircle.getAlpha();
                float secondHoleRadius = radius * (this.chart.getTransparentCircleRadius() / (float)100);
                this.paintTransparentCircle.setAlpha((int)((float)alpha * this.getAnimator().getPhaseX() * this.getAnimator().getPhaseY()));
                this.mHoleCirclePath.reset();
                this.mHoleCirclePath.addCircle(center.getX(), center.getY(), secondHoleRadius, Path.Direction.CW);
                this.mHoleCirclePath.addCircle(center.getX(), center.getY(), holeRadius, Path.Direction.CCW);
                Canvas canvas = this.bitmapCanvas;
                Intrinsics.checkNotNull((Object)canvas);
                canvas.drawPath(this.mHoleCirclePath, this.paintTransparentCircle);
                this.paintTransparentCircle.setAlpha(alpha);
            }
            PointF.Companion.recycleInstance(center);
        }
    }

    @NotNull
    protected final Path getMDrawCenterTextPathBuffer() {
        return this.mDrawCenterTextPathBuffer;
    }

    protected final void setMDrawCenterTextPathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.mDrawCenterTextPathBuffer = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void drawCenterText(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        CharSequence centerText = this.chart.getCenterText();
        if (this.chart.isDrawCenterTextEnabled() && centerText != null) {
            PointF center = this.chart.getCenterCircleBox();
            PointF offset = this.chart.getCenterTextOffset();
            float x = center.getX() + offset.getX();
            float y = center.getY() + offset.getY();
            float innerRadius = this.chart.isDrawHoleEnabled() && !this.chart.isDrawSlicesUnderHoleEnabled() ? this.chart.getRadius() * (this.chart.getHoleRadius() / 100.0f) : this.chart.getRadius();
            RectF holeRect = this.rectBuffer[0];
            holeRect.left = x - innerRadius;
            holeRect.top = y - innerRadius;
            holeRect.right = x + innerRadius;
            holeRect.bottom = y + innerRadius;
            RectF boundingRect = this.rectBuffer[1];
            boundingRect.set(holeRect);
            float radiusPercent = this.chart.getCenterTextRadiusPercent() / 100.0f;
            if ((double)radiusPercent > 0.0) {
                boundingRect.inset((boundingRect.width() - boundingRect.width() * radiusPercent) / 2.0f, (boundingRect.height() - boundingRect.height() * radiusPercent) / 2.0f);
            }
            if (!Intrinsics.areEqual((Object)centerText, (Object)this.centerTextLastValue) || !Intrinsics.areEqual((Object)boundingRect, (Object)this.centerTextLastBounds)) {
                this.centerTextLastBounds.set(boundingRect);
                this.centerTextLastValue = centerText;
                float width = this.centerTextLastBounds.width();
                this.centerTextLayout = new StaticLayout(centerText, 0, centerText.length(), this.paintCenterText, (int)Math.max(Math.ceil(width), 1.0), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
            }
            StaticLayout staticLayout = this.centerTextLayout;
            Intrinsics.checkNotNull((Object)staticLayout);
            float layoutHeight = staticLayout.getHeight();
            Canvas $this$withSave$iv = canvas;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$drawCenterText_u24lambda_u240 = $this$withSave$iv;
                boolean bl = false;
                Path path = this.mDrawCenterTextPathBuffer;
                path.reset();
                path.addOval(holeRect, Path.Direction.CW);
                $this$drawCenterText_u24lambda_u240.clipPath(path);
                $this$drawCenterText_u24lambda_u240.translate(boundingRect.left, boundingRect.top + (boundingRect.height() - layoutHeight) / 2.0f);
                StaticLayout staticLayout2 = this.centerTextLayout;
                Intrinsics.checkNotNull((Object)staticLayout2);
                staticLayout2.draw($this$drawCenterText_u24lambda_u240);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
            PointF.Companion.recycleInstance(center);
            PointF.Companion.recycleInstance(offset);
        }
    }

    @NotNull
    protected final RectF getMDrawHighlightedRectF() {
        return this.mDrawHighlightedRectF;
    }

    protected final void setMDrawHighlightedRectF(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.mDrawHighlightedRectF = rectF;
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        boolean drawInnerArc;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        boolean bl = drawInnerArc = this.chart.isDrawHoleEnabled() && !this.chart.isDrawSlicesUnderHoleEnabled();
        if (drawInnerArc && this.chart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        float angle = 0.0f;
        float rotationAngle = this.chart.getRotationAngle();
        float[] drawAngles = this.chart.getDrawAngles();
        float[] absoluteAngles = this.chart.getAbsoluteAngles();
        PointF center = this.chart.getCenterCircleBox();
        float radius = this.chart.getRadius();
        float userInnerRadius = drawInnerArc ? radius * (this.chart.getHoleRadius() / 100.0f) : 0.0f;
        RectF highlightedCircleBox = this.mDrawHighlightedRectF;
        highlightedCircleBox.set(0.0f, 0.0f, 0.0f, 0.0f);
        int n = indices.length;
        for (int i = 0; i < n; ++i) {
            IPieDataSet set;
            int index = (int)indices[i].getX();
            if (index >= drawAngles.length) continue;
            PieData pieData = (PieData)this.chart.getData();
            IPieDataSet iPieDataSet = set = pieData != null ? pieData.getDataSetByIndex(indices[i].getDataSetIndex()) : null;
            if (set == null || !set.isHighlightEnabled()) continue;
            int entryCount = set.getEntryCount();
            int visibleAngleCount = 0;
            for (int j = 0; j < entryCount; ++j) {
                Object t = set.getEntryForIndex(j);
                Intrinsics.checkNotNull(t);
                if (!(Math.abs((double)((PieEntry)t).getY()) > (double)Utils.INSTANCE.getFLOAT_EPSILON())) continue;
                ++visibleAngleCount;
            }
            angle = index == 0 ? 0.0f : absoluteAngles[index - 1] * phaseX;
            float sliceSpace = visibleAngleCount <= 1 ? 0.0f : set.getSliceSpace();
            float sliceAngle = drawAngles[index];
            float innerRadius = userInnerRadius;
            float shift = set.getSelectionShift();
            float highlightedRadius = radius + shift;
            highlightedCircleBox.set(this.chart.getCircleBox());
            highlightedCircleBox.inset(-shift, -shift);
            boolean accountForSliceSpacing = sliceSpace > 0.0f && sliceAngle <= 180.0f;
            Integer highlightColor = set.getHighlightColor();
            if (highlightColor == null) {
                highlightColor = set.getColorByIndex(index);
            }
            this.getPaintRender().setColor(highlightColor.intValue());
            float sliceSpaceAngleOuter = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * radius);
            float sliceSpaceAngleShifted = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * highlightedRadius);
            float startAngleOuter = rotationAngle + (angle + sliceSpaceAngleOuter / 2.0f) * phaseY;
            float sweepAngleOuter = (sliceAngle - sliceSpaceAngleOuter) * phaseY;
            if (sweepAngleOuter < 0.0f) {
                sweepAngleOuter = 0.0f;
            }
            float startAngleShifted = rotationAngle + (angle + sliceSpaceAngleShifted / 2.0f) * phaseY;
            float sweepAngleShifted = (sliceAngle - sliceSpaceAngleShifted) * phaseY;
            if (sweepAngleShifted < 0.0f) {
                sweepAngleShifted = 0.0f;
            }
            this.mPathBuffer.reset();
            if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.INSTANCE.getFLOAT_EPSILON()) {
                this.mPathBuffer.addCircle(center.getX(), center.getY(), highlightedRadius, Path.Direction.CW);
            } else {
                this.mPathBuffer.moveTo(center.getX() + highlightedRadius * (float)Math.cos(startAngleShifted * ((float)Math.PI / 180)), center.getY() + highlightedRadius * (float)Math.sin(startAngleShifted * ((float)Math.PI / 180)));
                this.mPathBuffer.arcTo(highlightedCircleBox, startAngleShifted, sweepAngleShifted);
            }
            float sliceSpaceRadius = 0.0f;
            if (accountForSliceSpacing) {
                sliceSpaceRadius = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, center.getX() + radius * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180)), center.getY() + radius * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180)), startAngleOuter, sweepAngleOuter);
            }
            this.mInnerRectBuffer.set(center.getX() - innerRadius, center.getY() - innerRadius, center.getX() + innerRadius, center.getY() + innerRadius);
            if (drawInnerArc && (innerRadius > 0.0f || accountForSliceSpacing)) {
                if (accountForSliceSpacing) {
                    float minSpacedRadius = sliceSpaceRadius;
                    if (minSpacedRadius < 0.0f) {
                        minSpacedRadius = -minSpacedRadius;
                    }
                    innerRadius = (float)Math.max((double)innerRadius, (double)minSpacedRadius);
                }
                float sliceSpaceAngleInner = visibleAngleCount == 1 || innerRadius == 0.0f ? 0.0f : sliceSpace / ((float)Math.PI / 180 * innerRadius);
                float startAngleInner = rotationAngle + (angle + sliceSpaceAngleInner / 2.0f) * phaseY;
                float sweepAngleInner = (sliceAngle - sliceSpaceAngleInner) * phaseY;
                if (sweepAngleInner < 0.0f) {
                    sweepAngleInner = 0.0f;
                }
                float endAngleInner = startAngleInner + sweepAngleInner;
                if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.INSTANCE.getFLOAT_EPSILON()) {
                    this.mPathBuffer.addCircle(center.getX(), center.getY(), innerRadius, Path.Direction.CCW);
                } else {
                    this.mPathBuffer.lineTo(center.getX() + innerRadius * (float)Math.cos(endAngleInner * ((float)Math.PI / 180)), center.getY() + innerRadius * (float)Math.sin(endAngleInner * ((float)Math.PI / 180)));
                    this.mPathBuffer.arcTo(this.mInnerRectBuffer, endAngleInner, -sweepAngleInner);
                }
            } else if (sweepAngleOuter % 360.0f > Utils.INSTANCE.getFLOAT_EPSILON()) {
                if (accountForSliceSpacing) {
                    float angleMiddle = startAngleOuter + sweepAngleOuter / 2.0f;
                    float arcEndPointX = center.getX() + sliceSpaceRadius * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
                    float arcEndPointY = center.getY() + sliceSpaceRadius * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
                    this.mPathBuffer.lineTo(arcEndPointX, arcEndPointY);
                } else {
                    this.mPathBuffer.lineTo(center.getX(), center.getY());
                }
            }
            this.mPathBuffer.close();
            Canvas canvas2 = this.bitmapCanvas;
            Intrinsics.checkNotNull((Object)canvas2);
            canvas2.drawPath(this.mPathBuffer, this.getPaintRender());
        }
        PointF.Companion.recycleInstance(center);
    }

    protected final void drawRoundedSlices() {
        if (!this.chart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        IPieDataSet dataSet = ((PieData)t).getDataSet();
        if (!dataSet.isVisible()) {
            return;
        }
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        PointF center = this.chart.getCenterCircleBox();
        float r = this.chart.getRadius();
        float circleRadius = (r - r * this.chart.getHoleRadius() / 100.0f) / 2.0f;
        float[] drawAngles = this.chart.getDrawAngles();
        float angle = 0.0f;
        angle = this.chart.getRotationAngle();
        int n = dataSet.getEntryCount();
        for (int j = 0; j < n; ++j) {
            float sliceAngle = drawAngles[j];
            if ((PieEntry)dataSet.getEntryForIndex(j) != null) {
                PieEntry entry;
                boolean bl = false;
                if (Math.abs((double)entry.getY()) > (double)Utils.INSTANCE.getFLOAT_EPSILON()) {
                    double v = Math.toRadians((angle + sliceAngle) * phaseY);
                    float x = (float)((double)(r - circleRadius) * Math.cos(v) + (double)center.getX());
                    float y = (float)((double)(r - circleRadius) * Math.sin(v) + (double)center.getY());
                    this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                    Canvas canvas = this.bitmapCanvas;
                    Intrinsics.checkNotNull((Object)canvas);
                    canvas.drawCircle(x, y, circleRadius, this.getPaintRender());
                }
            }
            angle += sliceAngle * phaseX;
        }
        PointF.Companion.recycleInstance(center);
    }

    public final void releaseBitmap() {
        if (this.bitmapCanvas != null) {
            Canvas canvas = this.bitmapCanvas;
            Intrinsics.checkNotNull((Object)canvas);
            canvas.setBitmap(null);
            this.bitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            Bitmap drawBitmap;
            WeakReference<Bitmap> weakReference = this.mDrawBitmap;
            Intrinsics.checkNotNull(weakReference);
            Bitmap bitmap = drawBitmap = (Bitmap)weakReference.get();
            if (bitmap != null) {
                bitmap.recycle();
            }
            WeakReference<Bitmap> weakReference2 = this.mDrawBitmap;
            if (weakReference2 != null) {
                weakReference2.clear();
            }
            this.mDrawBitmap = null;
        }
    }
}

