/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.highlight;

import info.appdev.charting.components.YAxis;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.DataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.highlight.IHighlighter;
import info.appdev.charting.interfaces.dataprovider.base.BarLineScatterCandleBubbleDataProvider;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0004J\"\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0004J(\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0004J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\rH\u0004J(\u0010!\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J4\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u00142\b\u0010'\u001a\u0004\u0018\u00010(H\u0014J8\u0010)\u001a\u0004\u0018\u00010\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010*\u001a\u00020\u0014J(\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0014H\u0014R\u001c\u0010\u0004\u001a\u00028\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u0001018TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Linfo/appdev/charting/highlight/ChartHighlighter;", "T", "Linfo/appdev/charting/interfaces/dataprovider/base/BarLineScatterCandleBubbleDataProvider;", "Linfo/appdev/charting/highlight/IHighlighter;", "provider", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/base/BarLineScatterCandleBubbleDataProvider;)V", "getProvider", "()Linfo/appdev/charting/interfaces/dataprovider/base/BarLineScatterCandleBubbleDataProvider;", "setProvider", "Linfo/appdev/charting/interfaces/dataprovider/base/BarLineScatterCandleBubbleDataProvider;", "highlightBuffer", "", "Linfo/appdev/charting/highlight/Highlight;", "getHighlightBuffer", "()Ljava/util/List;", "setHighlightBuffer", "(Ljava/util/List;)V", "getHighlight", "x", "", "y", "getValsForTouch", "Linfo/appdev/charting/utils/PointD;", "getHighlightForX", "xVal", "getMinimumDistance", "closestValues", "pos", "axis", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "getHighlightPos", "h", "getHighlightsAtXValue", "buildHighlights", "set", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "dataSetIndex", "", "rounding", "Linfo/appdev/charting/data/DataSet$Rounding;", "getClosestHighlightByPixel", "minSelectionDistance", "getDistance", "x1", "y1", "x2", "y2", "data", "Linfo/appdev/charting/data/ChartData;", "getData", "()Linfo/appdev/charting/data/ChartData;", "chartLib_release"})
public class ChartHighlighter<T extends BarLineScatterCandleBubbleDataProvider<?>>
implements IHighlighter {
    @NotNull
    private T provider;
    @NotNull
    private List<Highlight> highlightBuffer;

    public ChartHighlighter(@NotNull T provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.provider = provider;
        this.highlightBuffer = new ArrayList();
    }

    @NotNull
    protected final T getProvider() {
        return this.provider;
    }

    protected final void setProvider(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.provider = t;
    }

    @NotNull
    protected final List<Highlight> getHighlightBuffer() {
        return this.highlightBuffer;
    }

    protected final void setHighlightBuffer(@NotNull List<Highlight> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.highlightBuffer = list;
    }

    @Override
    @Nullable
    public Highlight getHighlight(float x, float y) {
        PointD pos = this.getValsForTouch(x, y);
        float xVal = (float)pos.getX();
        PointD.Companion.recycleInstance(pos);
        Highlight high = this.getHighlightForX(xVal, x, y);
        return high;
    }

    @NotNull
    protected final PointD getValsForTouch(float x, float y) {
        Transformer transformer = this.provider.getTransformer(YAxis.AxisDependency.LEFT);
        Intrinsics.checkNotNull((Object)transformer);
        return transformer.getValuesByTouchPoint(x, y);
    }

    @Nullable
    protected final Highlight getHighlightForX(float xVal, float x, float y) {
        float rightAxisMinDist;
        List<Highlight> closestValues;
        List<Highlight> list = closestValues = this.getHighlightsAtXValue(xVal, x, y);
        Intrinsics.checkNotNull(list);
        if (list.isEmpty()) {
            return null;
        }
        float leftAxisMinDist = this.getMinimumDistance(closestValues, y, YAxis.AxisDependency.LEFT);
        YAxis.AxisDependency axis = leftAxisMinDist < (rightAxisMinDist = this.getMinimumDistance(closestValues, y, YAxis.AxisDependency.RIGHT)) ? YAxis.AxisDependency.LEFT : YAxis.AxisDependency.RIGHT;
        return this.getClosestHighlightByPixel(closestValues, x, y, axis, this.provider.getMaxHighlightDistance());
    }

    protected final float getMinimumDistance(@NotNull List<Highlight> closestValues, float pos, @Nullable YAxis.AxisDependency axis) {
        Intrinsics.checkNotNullParameter(closestValues, (String)"closestValues");
        float distance = Float.MAX_VALUE;
        int n = ((Collection)closestValues).size();
        for (int i = 0; i < n; ++i) {
            float tempDistance;
            Highlight high = closestValues.get(i);
            if (high.getAxis() != axis || !((tempDistance = Math.abs(this.getHighlightPos(high) - pos)) < distance)) continue;
            distance = tempDistance;
        }
        return distance;
    }

    protected final float getHighlightPos(@NotNull Highlight h) {
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        return h.getYPx();
    }

    @Nullable
    protected List<Highlight> getHighlightsAtXValue(float xVal, float x, float y) {
        block3: {
            this.highlightBuffer.clear();
            ChartData<?> chartData = this.getData();
            if (chartData == null) break block3;
            ChartData<?> myData = chartData;
            boolean bl = false;
            int i = 0;
            int dataSetCount = myData.getDataSetCount();
            while (i < dataSetCount) {
                Object dataSet = myData.getDataSetByIndex(i);
                if (dataSet != null) {
                    Object it;
                    boolean bl2 = false;
                    if (!it.isHighlightEnabled()) {
                        ++i;
                        continue;
                    }
                    this.highlightBuffer.addAll((Collection<Highlight>)this.buildHighlights((IDataSet<?>)it, i, xVal, DataSet.Rounding.CLOSEST));
                }
                ++i;
            }
        }
        return this.highlightBuffer;
    }

    @NotNull
    protected List<Highlight> buildHighlights(@NotNull IDataSet<?> set, int dataSetIndex, float xVal, @Nullable DataSet.Rounding rounding) {
        Object closest;
        Intrinsics.checkNotNullParameter(set, (String)"set");
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        List<?> entries = set.getEntriesForXValue(xVal);
        if (entries != null && entries.isEmpty() && (closest = set.getEntryForXValue(xVal, Float.NaN, rounding)) != null) {
            entries = set.getEntriesForXValue(((Entry)closest).getX());
        }
        if (entries != null && entries.isEmpty()) {
            return highlights;
        }
        if (entries != null) {
            for (Entry e : entries) {
                Transformer transformer = this.provider.getTransformer(set.getAxisDependency());
                Intrinsics.checkNotNull((Object)transformer);
                PointD pixels = transformer.getPixelForValues(e.getX(), e.getY());
                highlights.add(new Highlight(e.getX(), e.getY(), (float)pixels.getX(), (float)pixels.getY(), dataSetIndex, set.getAxisDependency()));
            }
        }
        return highlights;
    }

    @Nullable
    public final Highlight getClosestHighlightByPixel(@NotNull List<Highlight> closestValues, float x, float y, @Nullable YAxis.AxisDependency axis, float minSelectionDistance) {
        Intrinsics.checkNotNullParameter(closestValues, (String)"closestValues");
        Highlight closest = null;
        float distance = minSelectionDistance;
        int n = ((Collection)closestValues).size();
        for (int i = 0; i < n; ++i) {
            float cDistance;
            Highlight high = closestValues.get(i);
            if (axis != null && high.getAxis() != axis || !((cDistance = this.getDistance(x, y, high.getXPx(), high.getYPx())) < distance)) continue;
            closest = high;
            distance = cDistance;
        }
        return closest;
    }

    protected float getDistance(float x1, float y1, float x2, float y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    @Nullable
    protected ChartData<?> getData() {
        return this.provider.getData();
    }
}

